/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.mixin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import java.util.WeakHashMap;
import net.minecraft.class_1255;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1255.class})
public class ThreadExecutorMixin {
    private static final Cache<Runnable, Exception> stackTraces = CacheBuilder.newBuilder().weakKeys().build();
    private final WeakHashMap<Thread, Runnable> executeTask_task = new WeakHashMap();

    @Inject(method={"send"}, at={@At(value="HEAD")})
    @Group(name="send", min=1)
    private void send_new(Runnable runnable, CallbackInfo info) {
        stackTraces.put((Object)runnable, (Object)new Exception("Stack trace"));
    }

    @Inject(method={"method_18858(Ljava/lang/Runnable;)V"}, at={@At(value="HEAD")}, remap=false)
    @Group(name="send", min=1)
    private void send_old(Runnable runnable, CallbackInfo info) {
        stackTraces.put((Object)runnable, (Object)new Exception("Stack trace"));
    }

    @Inject(method={"executeTask"}, at={@At(value="HEAD")})
    private void executeTask(Runnable task, CallbackInfo info) {
        this.executeTask_task.put(Thread.currentThread(), task);
    }

    @ModifyVariable(method={"executeTask"}, at=@At(value="STORE"))
    private Exception executeTask(Exception exception) {
        Runnable task = this.executeTask_task.remove(Thread.currentThread());
        Exception stackTrace = (Exception)stackTraces.getIfPresent((Object)task);
        if (stackTrace == null) {
            NBTEditor.LOGGER.warn("Missing additional #executeTask stack trace for exception");
        } else {
            exception.addSuppressed(stackTrace);
        }
        if (MixinLink.CATCH_BYPASSING_TASKS.remove(task) != null) {
            if (exception instanceof RuntimeException) {
                RuntimeException e = (RuntimeException)exception;
                throw e;
            }
            throw new RuntimeException("Failed to execute crashable task", exception);
        }
        return exception;
    }
}

