/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.mixin;

import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ImportScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.CreativeTabWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2558;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5684;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_437.class})
public class ScreenMixin {
    @Inject(method={"clearChildren"}, at={@At(value="RETURN")})
    private void clearChildren(CallbackInfo info) {
        CreativeTabWidget.addCreativeTabs((class_437)this);
    }

    @Inject(method={"init(Lnet/minecraft/client/MinecraftClient;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/Screen;init()V")}, require=0)
    private void init(class_310 client, int width, int height, CallbackInfo info) {
        Version.newSwitch().range("1.19.4", (String)null, () -> CreativeTabWidget.addCreativeTabs((class_437)this)).range((String)null, "1.19.3", () -> {}).run();
    }

    @Inject(method={"onFilesDropped"}, at={@At(value="HEAD")})
    private void onFilesDropped(List<Path> paths, CallbackInfo info) {
        class_437 source = (class_437)this;
        if (source instanceof class_465 || source instanceof class_433) {
            ImportScreen.importFiles(paths, Optional.empty());
        }
    }

    @Inject(method={"handleTextClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleTextClick(class_2583 style, CallbackInfoReturnable<Boolean> info) {
        if (style != null && !class_437.method_25442() && style.method_10970() != null && style.method_10970().method_10845() == class_2558.class_2559.field_11746 && MixinLink.tryRunClickEvent(style.method_10970().method_10844())) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"method_32633(Lnet/minecraft/class_4587;Ljava/util/List;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_4587;method_22903()V", shift=At.Shift.AFTER)}, remap=false, require=0)
    private void renderTooltipFromComponents(class_4587 matrices, List<class_5684> tooltip, int x, int y, CallbackInfo info) {
        if (!ConfigScreen.isTooltipOverflowFix()) {
            return;
        }
        int[] size = MixinLink.getTooltipSize(tooltip);
        int width = size[0];
        int height = size[1];
        int screenWidth = MainUtil.client.field_1755.field_22789;
        int screenHeight = MainUtil.client.field_1755.field_22790;
        y -= 12;
        if ((x += 12) + width > screenWidth) {
            x -= 28 + width;
        }
        if (y + height + 6 > screenHeight) {
            y = screenHeight - height - 6;
        }
        MixinLink.renderTooltipFromComponents(matrices, x, y, width, height, screenWidth, screenHeight);
    }
}

