/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.mixin;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.commands.factories.BookCommand;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalBlock;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.ScreenTexts;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.BlockReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ContainerItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.OverlaySupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.BookScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3872;
import net.minecraft.class_3935;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3872.class})
public class BookScreenMixin
extends class_437 {
    @Shadow
    private class_3872.class_3931 field_17418;
    @Shadow
    private int field_17119;
    private boolean renderLogo;
    private class_4185 openBtn;
    private class_4185 convertBtn;

    protected BookScreenMixin() {
        super(null);
    }

    private CompletableFuture<Optional<ItemReference>> getReference() {
        if (this instanceof class_3935) {
            return BlockReference.getLecternBlock().thenApply(optionalRef -> {
                if (optionalRef.isEmpty()) {
                    MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.no_ref.unknown", new Object[0]), false);
                    return Optional.empty();
                }
                return optionalRef.map(ref -> new ContainerItemReference<LocalBlock>((NBTReference<LocalBlock>)ref, 0));
            });
        }
        try {
            return CompletableFuture.completedFuture(Optional.of(ItemReference.getHeldItem()));
        }
        catch (CommandSyntaxException e) {
            MainUtil.client.field_1724.method_7353((class_2561)TextInst.literal(e.getMessage()).formatted(class_124.field_1061), false);
            return CompletableFuture.completedFuture(Optional.empty());
        }
    }

    private void getReference(Consumer<ItemReference> consumer) {
        this.getReference().thenAccept(ref -> MainUtil.client.execute(() -> ref.ifPresent(consumer)));
    }

    private void updateButtons(class_3872.class_3931 contents) {
        boolean editable;
        this.renderLogo = editable = (!(this instanceof class_3935) || NBTEditorClient.SERVER_CONN.isEditingExpanded()) && NBTEditorClient.SERVER_CONN.isEditingAllowed() && MVMisc.isWrittenBookContents(contents);
        this.openBtn.field_22764 = editable;
        this.convertBtn.field_22764 = editable;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo info) {
        if (MainUtil.client.field_1755 instanceof BookScreen) {
            this.renderLogo = true;
            return;
        }
        this.openBtn = (class_4185)this.method_37063((class_364)MVMisc.newButton(16, 64, 100, 20, TextInst.translatable("nbteditor.book.open", new Object[0]), btn -> this.getReference(ref -> {
            if (this instanceof class_3935) {
                MainUtil.client.field_1724.method_7346();
            }
            MainUtil.client.method_1507((class_437)new BookScreen((ItemReference)ref, Math.max(0, this.field_17119)));
        })));
        this.convertBtn = (class_4185)this.method_37063((class_364)MVMisc.newButton(16, 88, 100, 20, TextInst.translatable("nbteditor.book.convert", new Object[0]), btn -> this.getReference(itemRef -> {
            if (BookCommand.convertBookToWritable(itemRef)) {
                this.openBtn.field_22764 = false;
                this.convertBtn.field_22764 = false;
                if (!(this instanceof class_3935)) {
                    this.method_25419();
                }
            }
        })));
        this.updateButtons(this.field_17418);
    }

    @Inject(method={"setPageProvider"}, at={@At(value="HEAD")})
    private void setPageProvider(class_3872.class_3931 contents, CallbackInfo info) {
        this.updateButtons(contents);
    }

    @Inject(method={"addCloseButton"}, at={@At(value="HEAD")}, cancellable=true)
    private void addCloseButton(CallbackInfo info) {
        if (MainUtil.client.field_1755 instanceof BookScreen) {
            info.cancel();
            this.method_37063((class_364)MVMisc.newButton(this.field_22789 / 2 - 100, 196, 200, 20, ScreenTexts.DONE, btn -> OverlaySupportingScreen.setOverlayStatic(null)));
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    @Group(name="render", min=1)
    private void render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (this.renderLogo) {
            MainUtil.renderLogo(MVDrawableHelper.getMatrices(context));
        }
    }

    @Inject(method={"method_25394(Lnet/minecraft/class_4587;IIF)V"}, at={@At(value="TAIL")})
    @Group(name="render", min=1)
    private void render(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (this.renderLogo) {
            MainUtil.renderLogo(matrices);
        }
    }
}

