/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.misc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.async.ItemSize;
import com.luneruniverse.minecraft.mod.nbteditor.commands.get.GetLostItemCommand;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.mixin.ChatScreenAccessor;
import com.luneruniverse.minecraft.mod.nbteditor.mixin.HandledScreenAccessor;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVComponentType;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientHandledScreen;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.specific.data.Enchants;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3872;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5251;
import net.minecraft.class_5684;
import net.minecraft.class_7919;
import net.minecraft.class_9326;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class MixinLink {
    public static boolean CLIENT_LOADED = false;
    private static final Map<String, Runnable> events = new HashMap<String, Runnable>();
    public static File screenshotTarget;
    public static final Set<Thread> hiddenExceptionHandlers;
    public static final Set<Thread> specialNumbers;
    public static final List<class_1799> ENCHANT_GLINT_FIX;
    public static final Cache<class_3872.class_3931, Boolean> WRITTEN_BOOK_CONTENTS;
    public static final WeakHashMap<Runnable, Boolean> CATCH_BYPASSING_TASKS;
    public static final WeakHashMap<class_7919, Boolean> NEW_TOOLTIPS;
    public static volatile Thread MAIN_THREAD;
    public static final Map<Thread, class_1799> ITEM_BEING_RENDERED;
    public static final Set<Thread> SET_CHANGES;

    public static class_2583 withRunClickEvent(class_2583 style, Runnable onClick) {
        String id = "\u0000nbteditor_runnable@" + new Random().nextLong();
        events.put(id, onClick);
        return style.method_10958(new class_2558(class_2558.class_2559.field_11746, id));
    }

    public static boolean tryRunClickEvent(String id) {
        Runnable onClick = events.get(id);
        if (onClick != null) {
            onClick.run();
            return true;
        }
        return false;
    }

    public static int[] getTooltipSize(List<class_5684> tooltip) {
        int width = 0;
        int height = tooltip.size() == 1 ? -2 : 0;
        for (class_5684 line : tooltip) {
            width = Math.max(width, line.method_32664(MainUtil.client.field_1772));
            height += MVMisc.getTooltipComponentHeight(line);
        }
        return new int[]{width, height};
    }

    public static void renderTooltipFromComponents(class_4587 matrices, int x, int y, int width, int height, int screenWidth, int screenHeight) {
        int newX = x -= 5;
        int newY = y -= 5;
        int newWidth = width += 10;
        int newHeight = height += 10;
        if (width > screenWidth || height > screenHeight) {
            double scale = Math.min((double)screenWidth / (double)width, (double)screenHeight / (double)height);
            newWidth = (int)((double)width * scale);
            newHeight = (int)((double)height * scale);
            int[] mousePos = MainUtil.getMousePos();
            newX = mousePos[0] + 12;
            newY = mousePos[1] - 12;
        }
        if (newX < 0) {
            newX = 0;
        } else if (newX + newWidth > screenWidth) {
            newX = screenWidth - newWidth;
        }
        if (newY < 0) {
            newY = 0;
        } else if (newY + newHeight > screenHeight) {
            newY = screenHeight - newHeight;
        }
        MainUtil.mapMatrices(matrices, x, y, width, height, newX, newY, newWidth, newHeight);
    }

    public static void throwHiddenException(DangerousRunnable toRun) throws Throwable {
        hiddenExceptionHandlers.add(Thread.currentThread());
        try {
            toRun.run();
        }
        catch (HiddenException e) {
            throw e.getCause();
        }
        finally {
            hiddenExceptionHandlers.remove(Thread.currentThread());
        }
    }

    public static void renderChatLimitWarning(class_408 source, class_4587 matrices) {
        if (!ConfigScreen.isChatLimitExtended()) {
            return;
        }
        class_342 chatField = ((ChatScreenAccessor)source).getChatField();
        if (chatField.method_1882().length() > 256) {
            MVDrawableHelper.fill(matrices, source.field_22789 - 202, source.field_22790 - 40, source.field_22789 - 2, source.field_22790 - 14, -1426085376);
            class_327 textRenderer = MainUtil.client.field_1772;
            EditableText editableText = TextInst.translatable("nbteditor.chat_length_warning_1", new Object[0]);
            int n = source.field_22789 - 102;
            int n2 = source.field_22790 - 40;
            Objects.requireNonNull(textRenderer);
            MVDrawableHelper.drawCenteredTextWithShadow(matrices, textRenderer, editableText, n, n2 + 9 / 2, -5614336);
            EditableText editableText2 = TextInst.translatable("nbteditor.chat_length_warning_2", new Object[0]);
            int n3 = source.field_22789 - 102;
            int n4 = source.field_22790 - 28;
            Objects.requireNonNull(textRenderer);
            MVDrawableHelper.drawCenteredTextWithShadow(matrices, textRenderer, editableText2, n3, n4 + 9 / 2, -5614336);
        }
    }

    public static class_2520 parseSpecialElement(StringReader reader) throws CommandSyntaxException {
        specialNumbers.add(Thread.currentThread());
        try {
            class_2520 class_25202 = new class_2522(reader).method_10723();
            return class_25202;
        }
        finally {
            specialNumbers.remove(Thread.currentThread());
        }
    }

    public static void onMouseClick(class_465<?> source, class_1735 slot, int slotId, int button, class_1713 actionType, CallbackInfo info) {
        boolean creativeInv;
        if (!source.method_17577().method_34255().method_7960()) {
            GetLostItemCommand.addToHistory(source.method_17577().method_34255());
        }
        if (!(creativeInv = source instanceof class_481) && !NBTEditorClient.SERVER_CONN.isScreenEditable()) {
            return;
        }
        if (!class_437.method_25441()) {
            return;
        }
        if (slot instanceof class_481.class_484) {
            class_481.class_484 creativeSlot = (class_481.class_484)slot;
            slot = creativeSlot.field_2898;
        }
        if (!(actionType != class_1713.field_7790 || slot == null || slot.field_7871 != MainUtil.client.field_1724.method_31548() && creativeInv || source instanceof class_490 && slot.field_7874 <= 4)) {
            class_1799 cursor = source.method_17577().method_34255();
            class_1799 item = slot.method_7677();
            if (cursor == null || cursor.method_7960() || item == null || item.method_7960()) {
                return;
            }
            if (cursor.method_7909() == class_1802.field_8598 || item.method_7909() == class_1802.field_8598) {
                if (cursor.method_7909() != class_1802.field_8598) {
                    class_1799 temp = cursor;
                    cursor = item;
                    item = temp;
                }
                Enchants enchants = ItemTagReferences.ENCHANTMENTS.get(item);
                enchants.addEnchants(ItemTagReferences.ENCHANTMENTS.get(cursor).getEnchants());
                ItemTagReferences.ENCHANTMENTS.set(item, enchants);
                ItemReference.getContainerItem(source, slot).saveItem(item);
                NBTEditorClient.CURSOR_MANAGER.setCursor(class_1799.field_8037);
                info.cancel();
            }
        }
    }

    public static void keyPressed(class_465<?> source, int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> info) {
        boolean creativeInv = source instanceof class_481;
        class_1735 hoveredSlot = ((HandledScreenAccessor)source).getFocusedSlot();
        if (hoveredSlot instanceof class_481.class_484) {
            class_481.class_484 creativeSlot = (class_481.class_484)hoveredSlot;
            hoveredSlot = creativeSlot.field_2898;
        }
        if (hoveredSlot != null && (creativeInv && hoveredSlot.field_7871 == MainUtil.client.field_1724.method_31548() || !creativeInv && NBTEditorClient.SERVER_CONN.isScreenEditable()) && (!(source instanceof class_490) || hoveredSlot.field_7874 > 4) && (ConfigScreen.isAirEditable() || hoveredSlot.method_7677() != null && !hoveredSlot.method_7677().method_7960()) && ClientHandledScreen.handleKeybind(keyCode, hoveredSlot.method_7677(), ItemReference.getContainerItem(source, hoveredSlot))) {
            info.setReturnValue((Object)true);
        }
    }

    public static void modifyTooltip(class_1799 source, List<class_2561> tooltip) {
        boolean creativeInv;
        if (MainUtil.client.field_1687 == null) {
            return;
        }
        if (NBTManagers.COMPONENTS_EXIST && source.contains(MVComponentType.HIDE_TOOLTIP)) {
            return;
        }
        ConfigScreen.ItemSizeFormat sizeConfig = ConfigScreen.getItemSizeFormat();
        if (sizeConfig != ConfigScreen.ItemSizeFormat.HIDDEN) {
            class_124 sizeFormat;
            Object displaySize;
            OptionalLong loadingSize = ItemSize.getItemSize(source, sizeConfig.isCompressed());
            if (loadingSize.isEmpty()) {
                displaySize = "...";
                sizeFormat = class_124.field_1080;
            } else {
                long size = loadingSize.getAsLong();
                int magnitude = sizeConfig.getMagnitude();
                if (magnitude == 0) {
                    magnitude = size < 1000L ? 1 : (size < 1000000L ? 1000 : (size < 1000000000L ? 1000000 : 1000000000));
                }
                displaySize = magnitude == 1 ? "" + size : String.format("%.1f", (double)size / (double)magnitude);
                switch (magnitude) {
                    case 1: {
                        displaySize = (String)displaySize + "B";
                        sizeFormat = class_124.field_1060;
                        break;
                    }
                    case 1000: {
                        displaySize = (String)displaySize + "KB";
                        sizeFormat = class_124.field_1054;
                        break;
                    }
                    case 1000000: {
                        displaySize = (String)displaySize + "MB";
                        sizeFormat = class_124.field_1061;
                        break;
                    }
                    case 1000000000: {
                        displaySize = (String)displaySize + "GB";
                        sizeFormat = null;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid magnitude!");
                    }
                }
            }
            class_5251 sizeColor = sizeFormat != null ? class_5251.method_27718((class_124)sizeFormat) : class_5251.method_27717((int)Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 1.0f, 1.0f));
            tooltip.add(TextInst.translatable("nbteditor.item_size." + (sizeConfig.isCompressed() ? "compressed" : "uncompressed"), TextInst.literal((String)displaySize).styled(style -> style.method_27703(sizeColor))));
        }
        if (!ConfigScreen.isKeybindsHidden() && ((creativeInv = MVMisc.isCreativeInventoryTabSelected()) || !(MainUtil.client.field_1755 instanceof class_481) && NBTEditorClient.SERVER_CONN.isScreenEditable())) {
            tooltip.add(TextInst.translatable("nbteditor.keybind.edit", new Object[0]));
            tooltip.add(TextInst.translatable("nbteditor.keybind.factory", new Object[0]));
            if (ContainerIO.isContainer(source)) {
                tooltip.add(TextInst.translatable("nbteditor.keybind.container", new Object[0]));
            }
            if (source.method_7909() == class_1802.field_8598) {
                tooltip.add(TextInst.translatable("nbteditor.keybind.enchant", new Object[0]));
            }
            tooltip.add(TextInst.translatable("nbteditor.keybind.delete", new Object[0]));
        }
    }

    public static void executeCrashableTask(Runnable task) {
        CATCH_BYPASSING_TASKS.put(task, true);
        MainUtil.client.execute(task);
    }

    public static boolean isOnMainThread() {
        return Thread.currentThread() == MAIN_THREAD;
    }

    public static void setChanges(class_1799 item, class_9326 changes) {
        try {
            SET_CHANGES.add(Thread.currentThread());
            item.method_59692(changes);
        }
        finally {
            SET_CHANGES.remove(Thread.currentThread());
        }
    }

    static {
        hiddenExceptionHandlers = Collections.synchronizedSet(new HashSet());
        specialNumbers = Collections.synchronizedSet(new HashSet());
        ENCHANT_GLINT_FIX = new ArrayList<class_1799>();
        WRITTEN_BOOK_CONTENTS = CacheBuilder.newBuilder().weakKeys().build();
        CATCH_BYPASSING_TASKS = new WeakHashMap();
        NEW_TOOLTIPS = new WeakHashMap();
        ITEM_BEING_RENDERED = Collections.synchronizedMap(new WeakHashMap());
        SET_CHANGES = Collections.synchronizedSet(new HashSet());
    }

    public static interface DangerousRunnable {
        public void run() throws Throwable;
    }

    public static class HiddenException
    extends RuntimeException {
        public HiddenException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

