/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.localnbt;

import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalBlock;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalEntity;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItemStack;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVQuaternionf;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public interface LocalNBT {
    public static Optional<LocalNBT> deserialize(class_2487 nbt, int defaultDataVersion) {
        return Optional.ofNullable(switch (nbt.method_10573("type", 8) ? nbt.method_10558("type") : "item") {
            case "item" -> LocalItemStack.deserialize(nbt, defaultDataVersion);
            case "block" -> LocalBlock.deserialize(nbt, defaultDataVersion);
            case "entity" -> LocalEntity.deserialize(nbt, defaultDataVersion);
            default -> null;
        });
    }

    public static <T extends LocalNBT> T copy(T localNBT) {
        return (T)localNBT.copy();
    }

    public static MVQuaternionf makeRotatingIcon(class_4587 matrices, int x, int y, float scale, boolean inverse) {
        matrices.method_22904((double)(x + 8), (double)(y + 8), 8.0);
        matrices.method_22905(scale, scale, scale);
        matrices.method_22905(12.0f, 12.0f, 12.0f);
        MVQuaternionf quatX = MVQuaternionf.ofXRotation(-0.5235988f);
        MVQuaternionf quatY = MVQuaternionf.ofYRotation((float)((double)((float)(System.currentTimeMillis() % 2000L) / 2000.0f) * Math.PI * 2.0));
        MVQuaternionf quatZ = MVQuaternionf.ofZRotation((float)Math.PI);
        if (inverse) {
            quatX.conjugate().applyToMatrixStack(matrices);
            quatY.copy().conjugate().applyToMatrixStack(matrices);
        } else {
            quatX.applyToMatrixStack(matrices);
            quatY.applyToMatrixStack(matrices);
        }
        quatZ.applyToMatrixStack(matrices);
        return quatY;
    }

    default public boolean isEmpty() {
        return this.isEmpty(this.getId());
    }

    public boolean isEmpty(class_2960 var1);

    public class_2561 getName();

    public void setName(class_2561 var1);

    public String getDefaultName();

    public class_2960 getId();

    public void setId(class_2960 var1);

    public Set<class_2960> getIdOptions();

    public class_2487 getNBT();

    public void setNBT(class_2487 var1);

    default public class_2487 getOrCreateNBT() {
        class_2487 nbt = this.getNBT();
        if (nbt == null) {
            nbt = new class_2487();
            this.setNBT(nbt);
        }
        return nbt;
    }

    default public void modifyNBT(UnaryOperator<class_2487> modifier) {
        class_2487 nbt = this.getNBT();
        if (nbt == null) {
            nbt = new class_2487();
        }
        this.setNBT((class_2487)modifier.apply(nbt));
    }

    default public void modifyNBT(Consumer<class_2487> modifier) {
        this.modifyNBT(nbt -> {
            modifier.accept((class_2487)nbt);
            return nbt;
        });
    }

    public void renderIcon(class_4587 var1, int var2, int var3, float var4);

    public Optional<class_1799> toItem();

    public class_2487 serialize();

    public class_2561 toHoverableText();

    public LocalNBT copy();

    public boolean equals(Object var1);
}

