/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.localnbt;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItemStack;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class LocalItemParts
extends LocalItem {
    private class_1792 item;
    private class_2487 nbt;
    private int count;
    private class_1799 cachedItem;
    private class_2487 cachedNbt;

    public LocalItemParts(class_1799 item) {
        this.item = item.method_7909();
        this.nbt = item.manager$getNbt();
        this.count = item.method_7947();
        if (this.item == null) {
            this.item = class_1802.field_8162;
        }
        this.cachedItem = MainUtil.copyAirable(item);
        this.cachedNbt = this.nbt == null ? null : this.nbt.method_10553();
    }

    private LocalItemParts(LocalItemParts toCopy) {
        this.item = toCopy.item;
        this.nbt = toCopy.nbt == null ? null : toCopy.nbt.method_10553();
        this.count = toCopy.count;
        this.cachedItem = MainUtil.copyAirable(toCopy.cachedItem);
        this.cachedNbt = toCopy.cachedNbt == null ? null : toCopy.cachedNbt.method_10553();
    }

    @Override
    public LocalItemStack toStack() {
        return new LocalItemStack(this.getCachedItem());
    }

    @Override
    public LocalItemParts toParts() {
        return this;
    }

    private void setCachedItemCount() {
        Version.newSwitch().range("1.21.0", (String)null, () -> this.cachedItem.method_7939(Math.min(this.count, this.cachedItem.method_7914()))).range((String)null, "1.20.6", () -> this.cachedItem.method_7939(this.count)).run();
    }

    private class_1799 getCachedItem() {
        if (this.cachedItem.method_7909() == this.item && Objects.equals(this.cachedNbt, this.nbt)) {
            this.setCachedItemCount();
            return this.cachedItem;
        }
        class_1799 oldCachedItem = this.cachedItem;
        this.cachedItem = new class_1799((class_1935)this.item, 1);
        this.cachedNbt = this.nbt == null ? null : this.nbt.method_10553();
        try {
            this.cachedItem.manager$setNbt(this.cachedNbt);
        }
        catch (Exception e) {
            NBTEditor.LOGGER.warn("Error while updating item cache", (Throwable)e);
            this.cachedItem = oldCachedItem;
        }
        this.setCachedItemCount();
        return this.cachedItem;
    }

    @Override
    public class_1799 getEditableItem() {
        throw new UnsupportedOperationException("LocalItemParts's items cannot be edited directly!");
    }

    @Override
    public class_1799 getReadableItem() {
        return this.getCachedItem();
    }

    @Override
    public boolean isEmpty() {
        return this.item == class_1802.field_8162 || this.count <= 0;
    }

    @Override
    public boolean isEmpty(class_2960 id) {
        return MVRegistry.ITEM.get(id) == class_1802.field_8162;
    }

    @Override
    public class_2561 getName() {
        return MainUtil.getCustomItemNameSafely(this.getCachedItem());
    }

    @Override
    public void setName(class_2561 name) {
        if (NBTManagers.COMPONENTS_EXIST) {
            if (name == null) {
                if (this.nbt != null) {
                    this.nbt.method_10551("custom_name");
                    this.nbt.method_10551("minecraft:custom_name");
                }
            } else {
                class_2487 nbt;
                nbt.method_10582((nbt = this.getOrCreateNBT()).method_10545("minecraft:custom_name") || !nbt.method_10545("custom_name") ? "minecraft:custom_name" : "custom_name", TextInst.toJsonString(name));
            }
        } else {
            class_2487 nbt = this.getOrCreateNBT();
            class_2487 display = nbt.method_10562("display");
            if (name == null) {
                display.method_10551("Name");
            } else {
                display.method_10582("Name", TextInst.toJsonString(name));
                nbt.method_10566("display", (class_2520)display);
            }
        }
    }

    @Override
    public String getDefaultName() {
        return MainUtil.getBaseItemNameSafely(this.getCachedItem()).getString();
    }

    @Override
    public class_1792 getItemType() {
        return this.item;
    }

    @Override
    public class_2960 getId() {
        return MVRegistry.ITEM.getId(this.item);
    }

    @Override
    public void setId(class_2960 id) {
        this.item = MVRegistry.ITEM.get(id);
    }

    @Override
    public Set<class_2960> getIdOptions() {
        return MVRegistry.ITEM.getIds();
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public class_2487 getNBT() {
        return this.nbt;
    }

    @Override
    public void setNBT(class_2487 nbt) {
        this.nbt = nbt;
    }

    @Override
    public class_2487 getOrCreateNBT() {
        if (this.nbt == null) {
            this.nbt = new class_2487();
        }
        return this.nbt;
    }

    @Override
    public void renderIcon(class_4587 matrices, int x, int y, float tickDelta) {
        MVDrawableHelper.renderItem(matrices, 200.0f, true, this.getCachedItem(), x, y);
    }

    @Override
    public Optional<class_1799> toItem() {
        return Optional.of(this.getCachedItem().method_7972());
    }

    @Override
    public class_2487 serialize() {
        class_2487 output = new class_2487();
        output.method_10582("id", this.getId().toString());
        output.method_10566(NBTManagers.COMPONENTS_EXIST ? "components" : "tag", (class_2520)this.nbt);
        output.method_10569("count", this.count);
        output.method_10582("type", "item");
        return output;
    }

    @Override
    public class_2561 toHoverableText() {
        return this.getCachedItem().method_7954();
    }

    @Override
    public LocalItemParts copy() {
        return new LocalItemParts(this);
    }

    @Override
    public boolean equals(Object nbt) {
        if (nbt instanceof LocalItemParts) {
            LocalItemParts item = (LocalItemParts)nbt;
            return this.item == item.item && Objects.equals(this.nbt, item.nbt) && this.count == item.count;
        }
        return super.equals(nbt);
    }
}

