/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.localnbt;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMatrix4f;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVQuaternionf;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.EntityReference;
import com.luneruniverse.minecraft.mod.nbteditor.packets.SummonEntityC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ViewEntityS2CPacket;
import com.luneruniverse.minecraft.mod.nbteditor.server.ServerMVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_1208;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_898;

public class LocalEntity
implements LocalNBT {
    private class_1299<?> entityType;
    private class_2487 nbt;
    private class_1297 cachedEntity;
    private class_2487 cachedNbt;

    public static LocalEntity deserialize(class_2487 nbt, int defaultDataVersion) {
        class_2487 tag = nbt.method_10562("tag");
        tag.method_10582("id", nbt.method_10558("id"));
        tag = MainUtil.updateDynamic(class_1208.field_5729, tag, nbt.method_10580("DataVersion"), defaultDataVersion);
        String id = tag.method_10558("id");
        tag.method_10551("id");
        return new LocalEntity(MVRegistry.ENTITY_TYPE.get(IdentifierInst.of(id)), tag);
    }

    public LocalEntity(class_1299<?> entityType, class_2487 nbt) {
        this.entityType = entityType;
        this.nbt = nbt;
    }

    private class_1297 getCachedEntity() {
        if (this.cachedEntity != null && this.cachedEntity.method_5864() == this.entityType && Objects.equals(this.cachedNbt, this.nbt)) {
            return this.cachedEntity;
        }
        this.cachedEntity = ServerMVMisc.createEntity(this.entityType, (class_1937)MainUtil.client.field_1687);
        NBTManagers.ENTITY.setNbt(this.cachedEntity, this.nbt);
        this.cachedNbt = this.nbt.method_10553();
        return this.cachedEntity;
    }

    @Override
    public boolean isEmpty(class_2960 id) {
        return false;
    }

    @Override
    public class_2561 getName() {
        return MainUtil.getNbtNameSafely(this.nbt, "CustomName", () -> TextInst.of(this.getDefaultName()));
    }

    @Override
    public void setName(class_2561 name) {
        if (name == null) {
            this.getOrCreateNBT().method_10551("CustomName");
        } else {
            this.getOrCreateNBT().method_10582("CustomName", TextInst.toJsonString(name));
        }
    }

    @Override
    public String getDefaultName() {
        return this.entityType.method_5897().getString();
    }

    @Override
    public class_2960 getId() {
        return MVRegistry.ENTITY_TYPE.getId(this.entityType);
    }

    @Override
    public void setId(class_2960 id) {
        this.entityType = MVRegistry.ENTITY_TYPE.get(id);
    }

    @Override
    public Set<class_2960> getIdOptions() {
        return MVRegistry.ENTITY_TYPE.getIds();
    }

    public class_1299<?> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(class_1299<?> entityType) {
        this.entityType = entityType;
    }

    @Override
    public class_2487 getNBT() {
        return this.nbt;
    }

    @Override
    public void setNBT(class_2487 nbt) {
        this.nbt = nbt;
    }

    @Override
    public class_2487 getOrCreateNBT() {
        return this.nbt;
    }

    @Override
    public void renderIcon(class_4587 matrices, int x, int y, float tickDelta) {
        matrices.method_22903();
        matrices.method_22904(0.0, 8.0, 0.0);
        class_4587 renderMatrices = (class_4587)Version.newSwitch().range("1.19.4", null, matrices).range(null, "1.19.3", (class_4587)((Supplier<class_4587>)class_4587::new)).get();
        MVMatrix4f.ofScale(1.0f, 1.0f, -1.0f).applyToPositionMatrix(matrices);
        MVQuaternionf rotation = LocalNBT.makeRotatingIcon(renderMatrices, x, y, 0.75f, true);
        rotation.conjugate();
        if (Version.newSwitch().range("1.21.0", null, true).range(null, "1.20.6", false).get().booleanValue()) {
            rotation.rotateY((float)Math.PI);
        }
        MVDrawableHelper.applyModelViewMatrix();
        class_308.method_34742();
        class_4597.class_4598 provider = MVDrawableHelper.getVertexConsumerProvider();
        class_898 dispatcher = MainUtil.client.method_1561();
        dispatcher.method_3948(false);
        rotation.applyToEntityRenderDispatcher(dispatcher);
        MVMisc.renderEntity(dispatcher, this.getCachedEntity(), 0.0, 0.0, 0.0, 0.0f, tickDelta, renderMatrices, (class_4597)provider, 0xF000F0);
        dispatcher.method_3948(true);
        provider.method_22993();
        matrices.method_22909();
        MVDrawableHelper.applyModelViewMatrix();
    }

    @Override
    public Optional<class_1799> toItem() {
        class_1799 output = null;
        for (class_1792 item : MVRegistry.ITEM) {
            class_1826 spawnEggItem;
            if (!(item instanceof class_1826) || MVMisc.getEntityType(new class_1799((class_1935)(spawnEggItem = (class_1826)item))) != this.entityType) continue;
            output = new class_1799((class_1935)spawnEggItem);
        }
        if (output == null) {
            output = this.entityType == class_1299.field_6131 ? new class_1799((class_1935)class_1802.field_8694) : new class_1799((class_1935)class_1802.field_8493);
        }
        class_2487 nbt = this.nbt.method_10553();
        nbt.method_10582("id", this.getId().toString());
        ItemTagReferences.ENTITY_DATA.set(output, nbt);
        return Optional.of(output);
    }

    @Override
    public class_2487 serialize() {
        class_2487 output = new class_2487();
        output.method_10582("id", this.getId().toString());
        output.method_10566("tag", (class_2520)this.nbt);
        output.method_10582("type", "entity");
        return output;
    }

    @Override
    public class_2561 toHoverableText() {
        UUID uuid = this.nbt.method_25928("UUID") ? this.nbt.method_25926("UUID") : UUID.nameUUIDFromBytes(new byte[]{0, 0, 0, 0});
        return TextInst.bracketed(this.getName()).styled(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24344, (Object)new class_2568.class_5248(this.entityType, uuid, MainUtil.getNbtNameSafely(this.nbt, "CustomName", () -> null)))));
    }

    public CompletableFuture<Optional<EntityReference>> summon(class_5321<class_1937> world, class_243 pos) {
        return NBTEditorClient.SERVER_CONN.sendRequest(requestId -> new SummonEntityC2SPacket((int)requestId, world, pos, this.getId(), this.nbt), ViewEntityS2CPacket.class).thenApply(optional -> optional.filter(ViewEntityS2CPacket::foundEntity).map(packet -> {
            EntityReference ref = new EntityReference(packet.getWorld(), packet.getUUID(), MVRegistry.ENTITY_TYPE.get(packet.getId()), packet.getNbt());
            MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.get.entity", new Object[0]).append(ref.getLocalNBT().toHoverableText()), false);
            return ref;
        }));
    }

    @Override
    public LocalEntity copy() {
        return new LocalEntity(this.entityType, this.nbt.method_10553());
    }

    @Override
    public boolean equals(Object nbt) {
        if (nbt instanceof LocalEntity) {
            LocalEntity entity = (LocalEntity)nbt;
            return this.entityType == entity.entityType && this.nbt.equals((Object)entity.nbt);
        }
        return false;
    }
}

