/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.localnbt;

import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMatrix4f;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.BlockReference;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.util.BlockStateProperties;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1208;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class LocalBlock
implements LocalNBT {
    private class_2248 block;
    private BlockStateProperties state;
    private class_2487 nbt;
    private class_2586 cachedBlockEntity;
    private BlockStateProperties cachedState;
    private class_2487 cachedNbt;

    public static LocalBlock deserialize(class_2487 nbt, int defaultDataVersion) {
        class_2520 dataVersion = nbt.method_10580("DataVersion");
        String id = MainUtil.updateDynamic(class_1208.field_5731, class_2519.method_23256((String)nbt.method_10558("id")), dataVersion, defaultDataVersion).method_10714();
        class_2248 block = MVRegistry.BLOCK.get(IdentifierInst.of(id));
        BlockStateProperties state = new BlockStateProperties(block.method_9564());
        state.setValues(MainUtil.updateDynamic(class_1208.field_5720, nbt.method_10562("state"), dataVersion, defaultDataVersion));
        class_2487 tag = null;
        if (nbt.method_10573("tag", 10)) {
            tag = nbt.method_10562("tag");
            tag.method_10582("id", nbt.method_10558("id"));
            tag = MainUtil.updateDynamic(class_1208.field_5727, tag, dataVersion, defaultDataVersion);
            tag.method_10551("id");
        }
        return new LocalBlock(block, state, tag);
    }

    public LocalBlock(class_2248 block, BlockStateProperties state, class_2487 nbt) {
        this.block = block;
        this.state = state;
        this.nbt = nbt;
    }

    private class_2586 getCachedBlockEntity() {
        class_2248 class_22482 = this.block;
        if (!(class_22482 instanceof class_2343)) {
            return null;
        }
        class_2343 entityProvider = (class_2343)class_22482;
        if (this.cachedBlockEntity != null && this.cachedBlockEntity.method_11010().method_26204() == this.block && this.cachedState.equals(this.state) && Objects.equals(this.cachedNbt, this.nbt)) {
            return this.cachedBlockEntity;
        }
        this.cachedBlockEntity = entityProvider.method_10123(new class_2338(0, 1000, 0), this.state.applyTo(this.block.method_9564()));
        this.cachedBlockEntity.method_31662((class_1937)MainUtil.client.field_1687);
        if (this.nbt != null) {
            NBTManagers.BLOCK_ENTITY.setNbt(this.cachedBlockEntity, this.nbt);
        }
        this.cachedState = this.state.copy();
        this.cachedNbt = this.nbt.method_10553();
        return this.cachedBlockEntity;
    }

    public boolean isBlockEntity() {
        return this.block instanceof class_2343;
    }

    @Override
    public boolean isEmpty(class_2960 id) {
        return MVRegistry.BLOCK.get(id) == class_2246.field_10124;
    }

    @Override
    public class_2561 getName() {
        return MainUtil.getNbtNameSafely(this.nbt, "CustomName", () -> TextInst.of(this.getDefaultName()));
    }

    @Override
    public void setName(class_2561 name) {
        if (name == null) {
            this.getOrCreateNBT().method_10551("CustomName");
        } else {
            this.getOrCreateNBT().method_10582("CustomName", TextInst.toJsonString(name));
        }
    }

    @Override
    public String getDefaultName() {
        return this.block.method_9518().getString();
    }

    @Override
    public class_2960 getId() {
        return MVRegistry.BLOCK.getId(this.block);
    }

    @Override
    public void setId(class_2960 id) {
        this.block = MVRegistry.BLOCK.get(id);
        this.state = this.state.mapTo(this.block.method_9564());
    }

    @Override
    public Set<class_2960> getIdOptions() {
        return MVRegistry.BLOCK.getIds();
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public void setBlock(class_2248 block) {
        this.block = block;
    }

    public BlockStateProperties getState() {
        return this.state;
    }

    public void setState(BlockStateProperties state) {
        this.state = state;
    }

    @Override
    public class_2487 getNBT() {
        return this.nbt;
    }

    @Override
    public void setNBT(class_2487 nbt) {
        this.nbt = nbt;
    }

    @Override
    public void renderIcon(class_4587 matrices, int x, int y, float tickDelta) {
        RenderSystem.disableCull();
        matrices.method_22903();
        class_4587 renderMatrices = (class_4587)Version.newSwitch().range("1.19.4", null, matrices).range(null, "1.19.3", (class_4587)((Supplier<class_4587>)class_4587::new)).get();
        MVMatrix4f.ofScale(1.0f, 1.0f, -1.0f).applyToPositionMatrix(renderMatrices);
        LocalNBT.makeRotatingIcon(renderMatrices, x, y, 1.0f, true);
        renderMatrices.method_22904(-0.5, -0.5, -0.5);
        class_4597.class_4598 provider = MVDrawableHelper.getVertexConsumerProvider();
        MVMisc.renderBlock(MainUtil.client.method_1541(), this.state.applyTo(this.block.method_9564()), new class_2338(0, 1000, 0), (class_1920)MainUtil.client.field_1687, renderMatrices, provider.getBuffer(class_1921.method_23581()), false);
        if (this.isBlockEntity()) {
            MVMisc.renderBlockEntity(MainUtil.client.method_31975(), this.getCachedBlockEntity(), tickDelta, renderMatrices, (class_4597)provider);
        }
        provider.method_22993();
        matrices.method_22909();
        RenderSystem.enableCull();
    }

    @Override
    public Optional<class_1799> toItem() {
        for (class_1792 item : MVRegistry.ITEM) {
            class_1747 blockItem;
            if (!(item instanceof class_1747) || (blockItem = (class_1747)item).method_7711() != this.block) continue;
            class_1799 output = new class_1799((class_1935)blockItem);
            if (this.nbt != null) {
                if (NBTManagers.COMPONENTS_EXIST) {
                    class_2248 class_22482 = this.block;
                    if (class_22482 instanceof class_2343) {
                        class_2343 provider = (class_2343)class_22482;
                        class_2586 entity = provider.method_10123(new class_2338(0, 1000, 0), this.state.applyTo(this.block.method_9564()));
                        entity.method_31662((class_1937)MainUtil.client.field_1687);
                        NBTManagers.BLOCK_ENTITY.setNbt(entity, this.nbt);
                        MVMisc.addBlockEntityNbtWithoutXYZ(output, entity);
                    }
                } else {
                    class_2487 nbt = new class_2487();
                    nbt.method_10566("BlockEntityTag", (class_2520)this.nbt);
                    output.manager$setNbt(nbt);
                }
            }
            ItemTagReferences.BLOCK_STATE.set(output, this.state.getValuesMap());
            return Optional.of(output);
        }
        return Optional.empty();
    }

    @Override
    public class_2487 serialize() {
        class_2487 output = new class_2487();
        output.method_10582("id", this.getId().toString());
        output.method_10566("state", (class_2520)this.state.getValues());
        if (this.nbt != null && (!this.nbt.method_33133() || this.isBlockEntity())) {
            output.method_10566("tag", (class_2520)this.nbt);
        }
        output.method_10582("type", "block");
        return output;
    }

    @Override
    public class_2561 toHoverableText() {
        class_2561 customName;
        EditableText tooltip = TextInst.translatable("gui.entity_tooltip.type", this.block.method_9518());
        if (!this.state.getProperties().isEmpty()) {
            tooltip.append("\n" + String.valueOf(this.state));
        }
        if ((customName = MainUtil.getNbtNameSafely(this.nbt, "CustomName", () -> null)) != null) {
            tooltip = TextInst.literal("").append(customName).append("\n").append(tooltip);
        }
        EditableText finalTooltip = tooltip;
        return TextInst.bracketed(this.getName()).styled(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)finalTooltip)));
    }

    public BlockReference place(class_2338 pos) {
        BlockReference ref = BlockReference.getBlockWithoutNBT(pos);
        ref.saveLocalNBT(this, TextInst.translatable("nbteditor.get.block", new Object[0]).append(this.toHoverableText()));
        return ref;
    }

    @Override
    public LocalBlock copy() {
        return new LocalBlock(this.block, this.state.copy(), this.nbt == null ? null : this.nbt.method_10553());
    }

    @Override
    public boolean equals(Object nbt) {
        if (nbt instanceof LocalBlock) {
            LocalBlock block = (LocalBlock)nbt;
            return this.block == block.block && this.state.equals(block.state) && Objects.equals(this.nbt, block.nbt);
        }
        return false;
    }
}

