/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.integrations;

import com.luneruniverse.minecraft.mod.nbteditor.integrations.Integration;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalBlock;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalEntity;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.DynamicRegistryManagerHolder;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_2291;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5626;

public class NBTAutocompleteIntegration
extends Integration {
    public static final Optional<NBTAutocompleteIntegration> INSTANCE = Integration.getOptional(NBTAutocompleteIntegration::new);

    private static StringRange shiftRange(StringRange range, int shift) {
        return new StringRange(range.getStart() + shift, range.getEnd() + shift);
    }

    private static Suggestion shiftSuggestion(Suggestion suggestion, int shift) {
        Suggestion shiftedSuggestion = new Suggestion(NBTAutocompleteIntegration.shiftRange(suggestion.getRange(), shift), suggestion.getText(), suggestion.getTooltip());
        NbtSuggestionManager.subtextMap.put(shiftedSuggestion, (String)NbtSuggestionManager.subtextMap.remove(suggestion));
        return shiftedSuggestion;
    }

    private NBTAutocompleteIntegration() {
    }

    @Override
    public String getModId() {
        return "nbt_ac";
    }

    private CompletableFuture<Suggestions> getSuggestions(String type, class_2960 id, class_2520 nbt, List<String> path, String key, String value, int cursor, Collection<String> otherTags) {
        boolean nextTagAllowed;
        boolean components;
        if (value != null && otherTags != null) {
            throw new IllegalArgumentException("Both value and otherTags can't be non-null at the same time!");
        }
        if (key == null && value == null) {
            throw new IllegalArgumentException("Both key and value can't be null at the same time!");
        }
        boolean bl = components = NBTManagers.COMPONENTS_EXIST && type.equals("item");
        if (value == null) {
            key = key.substring(0, cursor);
            nextTagAllowed = false;
        } else {
            nextTagAllowed = cursor < value.length();
            value = value.substring(0, cursor);
        }
        if (key != null && (key.contains("{") || key.contains("["))) {
            return new SuggestionsBuilder("", 0).buildFuture();
        }
        StringBuilder pathBuilder = new StringBuilder();
        boolean firstKey = true;
        if (nbt != null) {
            for (String piece : path) {
                if (nbt instanceof class_2487) {
                    class_2487 compound = (class_2487)nbt;
                    if (firstKey && components) {
                        pathBuilder.append('[');
                        pathBuilder.append(piece);
                        pathBuilder.append('=');
                    } else {
                        pathBuilder.append('{');
                        pathBuilder.append(this.escapeKey(piece));
                        pathBuilder.append(':');
                    }
                    nbt = compound.method_10580(piece);
                } else if (nbt instanceof class_2499) {
                    class_2499 list = (class_2499)nbt;
                    pathBuilder.append('[');
                    nbt = list.method_10534(Integer.parseInt(piece));
                } else {
                    return new SuggestionsBuilder("", 0).buildFuture();
                }
                firstKey = false;
            }
        }
        int fieldStart = pathBuilder.length();
        if (key != null) {
            if (nbt instanceof class_2487) {
                if (firstKey && components) {
                    pathBuilder.append('[');
                } else {
                    pathBuilder.append('{');
                }
            } else if (nbt instanceof class_2499) {
                pathBuilder.append('[');
            } else {
                return new SuggestionsBuilder("", 0).buildFuture();
            }
            fieldStart = pathBuilder.length();
            if (nbt instanceof class_2487) {
                if (firstKey && components) {
                    pathBuilder.append(key);
                } else {
                    String escapedKey = this.escapeKey(key);
                    pathBuilder.append(key.equals(escapedKey) ? key : escapedKey.substring(0, escapedKey.length() - 1));
                }
            }
            if (value != null) {
                if (nbt instanceof class_2487) {
                    if (firstKey && components) {
                        pathBuilder.append('=');
                    } else {
                        pathBuilder.append(':');
                    }
                    fieldStart = pathBuilder.length();
                }
                pathBuilder.append(value);
            }
        } else {
            if (firstKey && components) {
                pathBuilder.append("[container=[{item:{id:\"" + String.valueOf(id) + "\",components:");
                fieldStart = pathBuilder.length();
            }
            pathBuilder.append(value);
        }
        String pathStr = pathBuilder.toString();
        String suggestionId = type + "/" + String.valueOf(id);
        int fieldStartFinal = fieldStart;
        String valueFinal = value;
        boolean firstKeyFinal = firstKey;
        return this.loadFromName(suggestionId, pathStr, components).thenApply(suggestions -> {
            List shiftedSuggestions = suggestions.getList().stream().filter(suggestion -> !(suggestion.getText().isEmpty() || valueFinal == null && suggestion.getText().contains(":") || valueFinal == null && firstKeyFinal && components && suggestion.getText().contains("{") || !nextTagAllowed && (suggestion.getText().contains(",") || suggestion.getText().contains("}")) || otherTags != null && otherTags.contains(suggestion.getText()))).map(suggestion -> {
                suggestion = NBTAutocompleteIntegration.shiftSuggestion(suggestion, -fieldStartFinal);
                if (firstKeyFinal && components && suggestion.getText().endsWith("=")) {
                    String newText = suggestion.getText().substring(0, suggestion.getText().length() - 1);
                    if (otherTags.contains(newText) || otherTags.contains(MainUtil.addNamespace(newText))) {
                        return null;
                    }
                    suggestion = new Suggestion(suggestion.getRange(), newText, suggestion.getTooltip());
                }
                return suggestion;
            }).filter(suggestion -> suggestion != null).collect(Collectors.toList());
            return new Suggestions(NBTAutocompleteIntegration.shiftRange(suggestions.getRange(), -fieldStartFinal), shiftedSuggestions);
        });
    }

    private String escapeKey(String key) {
        if (key.isEmpty() || class_5626.field_27829.matcher(key).matches()) {
            return key;
        }
        return class_2519.method_10706((String)key);
    }

    private CompletableFuture<Suggestions> loadFromName(String name, String tag, boolean components) {
        if (components) {
            name = name.substring("item/".length());
            int shift = name.length();
            SuggestionsBuilder builder = new SuggestionsBuilder(name + tag, 0);
            return new class_2291(DynamicRegistryManagerHolder.get()).method_9793(builder).thenApply(suggestions -> new Suggestions(NBTAutocompleteIntegration.shiftRange(suggestions.getRange(), -shift), suggestions.getList().stream().map(suggestion -> NBTAutocompleteIntegration.shiftSuggestion(suggestion, -shift)).collect(Collectors.toList())));
        }
        return NbtSuggestionManager.loadFromName((String)name, (String)tag, (SuggestionsBuilder)new SuggestionsBuilder(tag, 0), (boolean)false);
    }

    public CompletableFuture<Suggestions> getSuggestions(LocalNBT nbt, List<String> path, String key, String value, int cursor, Collection<String> otherTags) {
        if (nbt instanceof LocalItem) {
            return this.getSuggestions("item", nbt.getId(), (class_2520)nbt.getNBT(), path, key, value, cursor, otherTags);
        }
        if (nbt instanceof LocalBlock) {
            return this.getSuggestions("block", nbt.getId(), (class_2520)nbt.getNBT(), path, key, value, cursor, otherTags);
        }
        if (nbt instanceof LocalEntity) {
            return this.getSuggestions("entity", nbt.getId(), (class_2520)nbt.getNBT(), path, key, value, cursor, otherTags);
        }
        return new SuggestionsBuilder("", 0).buildFuture();
    }

    public CompletableFuture<Suggestions> getSuggestions(LocalNBT nbt, List<String> path, String key, String value, int cursor) {
        return this.getSuggestions(nbt, path, key, value, cursor, null);
    }
}

