/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.integrations;

import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;

public abstract class Integration {
    private Boolean loaded;

    public static <T extends Integration> Optional<T> getOptional(Supplier<T> integration) {
        Integration value = (Integration)integration.get();
        if (value.isLoaded()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public boolean isLoaded() {
        if (this.loaded == null) {
            this.loaded = FabricLoader.getInstance().getAllMods().stream().anyMatch(mod -> mod.getMetadata().getId().equals(this.getModId()));
        }
        return this.loaded;
    }

    public abstract String getModId();
}

