/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.fancytext;

import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyText;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextNode;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.StyleOption;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.UUID;
import java.util.stream.StreamSupport;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2568;
import net.minecraft.class_2583;

public record FancyTextStyleOptionNode(StyleOption option, String value, List<FancyTextNode> contents) implements FancyTextNode
{
    @Override
    public class_2583 modifyStyle(class_2583 style) {
        return switch (this.option) {
            default -> throw new IncompatibleClassChangeError();
            case StyleOption.OPEN_URL, StyleOption.RUN_COMMAND, StyleOption.SUGGEST_COMMAND, StyleOption.CHANGE_PAGE, StyleOption.COPY_TO_CLIPBOARD -> {
                class_2583 var2_2;
                yield var2_2 = style.method_10958(new class_2558(class_2558.class_2559.valueOf((String)this.option.name()), this.value == null ? "" : this.value));
            }
            case StyleOption.SHOW_TEXT -> {
                class_2583 var2_3;
                yield var2_3 = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)(this.value == null ? TextInst.of("") : FancyText.parse(this.value))));
            }
            case StyleOption.SHOW_ITEM -> {
                class_2583 var2_4;
                class_1799 item;
                try {
                    item = MainUtil.client.field_1724.method_31548().method_5438(Integer.parseInt(this.value));
                }
                catch (NumberFormatException e) {
                    try {
                        item = ItemReference.getHeldItem().getItem();
                    }
                    catch (CommandSyntaxException e2) {
                        item = class_1799.field_8037;
                    }
                }
                yield var2_4 = style.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(item)));
            }
            case StyleOption.SHOW_ENTITY -> {
                class_2583 var2_5;
                Object entity;
                try {
                    if (this.value == null) {
                        throw new IllegalArgumentException();
                    }
                    String uuid = this.value;
                    if (!uuid.contains("-")) {
                        uuid = uuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
                    }
                    UUID uuidObj = UUID.fromString(uuid);
                    entity = StreamSupport.stream(MainUtil.client.field_1687.method_18112().spliterator(), false).filter(testEntity -> testEntity.method_5667().equals(uuidObj)).findFirst().orElseThrow(IllegalArgumentException::new);
                }
                catch (IllegalArgumentException e) {
                    entity = MainUtil.client.field_1692 != null ? MainUtil.client.field_1692 : MainUtil.client.field_1724;
                }
                yield var2_5 = style.method_10949(new class_2568(class_2568.class_5247.field_24344, (Object)new class_2568.class_5248(entity.method_5864(), entity.method_5667(), entity.method_5477())));
            }
            case StyleOption.INSERTION -> {
                class_2583 var2_6;
                yield var2_6 = style.method_10975(this.value);
            }
            case StyleOption.FONT -> {
                try {
                    class_2583 var2_7;
                    yield var2_7 = style.method_27704(IdentifierInst.of(this.value));
                }
                catch (class_151 e) {
                    class_2583 var2_8;
                    yield var2_8 = style.method_27704(class_2583.field_24359);
                }
            }
        };
    }

    @Override
    public int getNumberOfTextNodes() {
        return this.contents.stream().mapToInt(FancyTextNode::getNumberOfTextNodes).sum();
    }
}

