/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.fancytext;

import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextColorNode;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextFormattingNode;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextShadowColorNode;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextStyleOptionNode;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextTextNode;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextToken;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.StyleOption;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_5251;

public interface FancyTextNode {
    public static List<FancyTextNode> parse(List<FancyTextToken> tokens) {
        return FancyTextNode.parse(tokens, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<FancyTextNode> parse(List<FancyTextToken> tokens, AtomicInteger internalParseIndex) {
        int i;
        ArrayList<FancyTextNode> output = new ArrayList<FancyTextNode>();
        int parenLevel = 0;
        int n = i = internalParseIndex == null ? 0 : internalParseIndex.getPlain();
        block12: while (i < tokens.size()) {
            FancyTextToken token = tokens.get(i);
            switch (token.type()) {
                case TEXT: {
                    output.add(new FancyTextTextNode((String)token.content().get()));
                    break;
                }
                case COLOR: {
                    output.add(new FancyTextColorNode((class_5251)token.content().get()));
                    break;
                }
                case FORMATTING: {
                    output.add(new FancyTextFormattingNode((class_124)token.content().get()));
                    break;
                }
                case SHADOW_COLOR: {
                    output.add(new FancyTextShadowColorNode((Integer)token.content().get()));
                    break;
                }
                case OPEN_PAREN: {
                    ++parenLevel;
                    output.add(new FancyTextTextNode("("));
                    break;
                }
                case CLOSE_PAREN: {
                    if (internalParseIndex == null || parenLevel > 0) {
                        if (parenLevel > 0) {
                            --parenLevel;
                        }
                        output.add(new FancyTextTextNode(")"));
                        break;
                    }
                    internalParseIndex.setPlain(i);
                    break block12;
                }
                case OPEN_SQUARE: {
                    boolean success = false;
                    if (i + 4 < tokens.size()) {
                        StyleOption action;
                        FancyTextToken event = tokens.get(i + 1);
                        FancyTextToken closeSquare = tokens.get(i + 2);
                        if (event.type() == FancyTextToken.Type.TEXT && closeSquare.type() == FancyTextToken.Type.CLOSE_SQUARE && (action = StyleOption.valueOf(((String)event.content().get()).toUpperCase())) != null) {
                            int openIndex = i + 3;
                            FancyTextToken open = tokens.get(openIndex);
                            String value = null;
                            if (open.type() == FancyTextToken.Type.OPEN_CURLY && i + 6 < tokens.size()) {
                                FancyTextToken valueToken = tokens.get(i + 4);
                                FancyTextToken closeCurly = tokens.get(i + 5);
                                if (valueToken.type() == FancyTextToken.Type.CLOSE_CURLY) {
                                    value = "";
                                    openIndex = i + 5;
                                    open = closeCurly;
                                } else if (valueToken.type() == FancyTextToken.Type.TEXT && closeCurly.type() == FancyTextToken.Type.CLOSE_CURLY) {
                                    value = (String)valueToken.content().get();
                                    openIndex = i + 6;
                                    open = tokens.get(i + 6);
                                }
                            }
                            if (open.type() == FancyTextToken.Type.OPEN_PAREN) {
                                AtomicInteger internalParseIndex2 = new AtomicInteger(openIndex + 1);
                                List<FancyTextNode> contents = FancyTextNode.parse(tokens, internalParseIndex2);
                                i = internalParseIndex2.getPlain();
                                output.add(new FancyTextStyleOptionNode(action, value, contents));
                                success = true;
                            }
                        }
                    }
                    if (success) break;
                    output.add(new FancyTextTextNode("["));
                    break;
                }
                case CLOSE_SQUARE: {
                    output.add(new FancyTextTextNode("]"));
                    break;
                }
                case OPEN_CURLY: {
                    output.add(new FancyTextTextNode("{"));
                    break;
                }
                case CLOSE_CURLY: {
                    output.add(new FancyTextTextNode("}"));
                }
            }
            ++i;
        }
        FancyTextTextNode prevText = null;
        ListIterator<FancyTextTextNode> i2 = output.listIterator();
        while (i2.hasNext()) {
            FancyTextNode node = (FancyTextNode)i2.next();
            if (node instanceof FancyTextTextNode) {
                FancyTextTextNode text = (FancyTextTextNode)node;
                if (prevText == null) {
                    prevText = text;
                    continue;
                }
                prevText = new FancyTextTextNode(prevText.text() + text.text());
                i2.remove();
                i2.previous();
                i2.set(prevText);
                i2.next();
                continue;
            }
            prevText = null;
        }
        return output;
    }

    public class_2583 modifyStyle(class_2583 var1);

    public int getNumberOfTextNodes();
}

