/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.fancytext;

import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextNode;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextStyleOptionNode;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextTextNode;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyTextToken;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.util.StyleUtil;
import com.mojang.brigadier.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;

public class FancyText {
    public static class_2561 parse(String str, class_2583 base) {
        List<FancyTextToken> tokens = FancyTextToken.parse(new StringReader(str));
        List<FancyTextNode> nodes = FancyTextNode.parse(tokens);
        return FancyText.gen(nodes, base.method_27702(StyleUtil.RESET_STYLE));
    }

    private static EditableText gen(List<FancyTextNode> nodes, class_2583 base) {
        int numberOfTextNodes = nodes.stream().mapToInt(FancyTextNode::getNumberOfTextNodes).sum();
        if (numberOfTextNodes == 0) {
            return TextInst.literal("");
        }
        EditableText output = TextInst.literal("");
        class_2583 style = base;
        for (FancyTextNode node : nodes) {
            if (node instanceof FancyTextTextNode) {
                FancyTextTextNode text = (FancyTextTextNode)node;
                output.append(TextInst.literal(text.text()).setStyle(StyleUtil.minus(style, base)));
                continue;
            }
            if (node instanceof FancyTextStyleOptionNode) {
                FancyTextStyleOptionNode event = (FancyTextStyleOptionNode)node;
                if (numberOfTextNodes == 1 && event.getNumberOfTextNodes() != 1) continue;
                class_2583 eventStyle = event.modifyStyle(style);
                output.append(FancyText.gen(event.contents(), eventStyle).styled(genStyle -> StyleUtil.minus(genStyle.method_27702(eventStyle), base)));
                continue;
            }
            style = node.modifyStyle(style);
        }
        if (numberOfTextNodes == 1) {
            return (EditableText)output.method_10855().get(0);
        }
        return output;
    }

    public static Map.Entry<String, Boolean> stringify(class_2561 text, class_2583 base) {
        base = base.method_27702(StyleUtil.RESET_STYLE);
        StringBuilder output = new StringBuilder();
        AtomicReference<class_2583> style = new AtomicReference<class_2583>(base);
        AtomicReference<class_2583> eventContentsStyle = new AtomicReference<class_2583>(base);
        AtomicReference<Object> clickEvent = new AtomicReference<Object>(null);
        AtomicReference<Object> hoverEvent = new AtomicReference<Object>(null);
        AtomicReference<Object> insertion = new AtomicReference<Object>(null);
        AtomicReference<Object> font = new AtomicReference<Object>(null);
        AtomicBoolean errors = new AtomicBoolean(false);
        text.method_27658((partStyle, partText) -> {
            if (!(Objects.equals(partStyle.method_10970(), clickEvent.getPlain()) && Objects.equals(partStyle.method_10969(), hoverEvent.getPlain()) && Objects.equals(partStyle.method_10955(), insertion.getPlain()) && Objects.equals(partStyle.field_24361, font.getPlain()))) {
                if (clickEvent.getPlain() != null) {
                    output.append(')');
                }
                if (hoverEvent.getPlain() != null) {
                    output.append(')');
                }
                if (insertion.getPlain() != null) {
                    output.append(')');
                }
                if (font.getPlain() != null) {
                    output.append(')');
                }
                eventContentsStyle.setPlain((class_2583)style.getPlain());
                clickEvent.setPlain(partStyle.method_10970());
                hoverEvent.setPlain(partStyle.method_10969());
                insertion.setPlain(partStyle.method_10955());
                font.setPlain(partStyle.field_24361);
                if (partStyle.method_10970() != null) {
                    output.append('[');
                    output.append(MVMisc.getClickEventActionName(partStyle.method_10970().method_10845()));
                    output.append("]{");
                    output.append(partStyle.method_10970().method_10844().replace("\\", "\\\\").replace("{", "\\{").replace("}", "\\}"));
                    output.append("}(");
                }
                if (partStyle.method_10969() != null) {
                    output.append('[');
                    output.append(MVMisc.getHoverEventActionName(partStyle.method_10969().method_10892()));
                    output.append(']');
                    if (partStyle.method_10969().method_10892() == class_2568.class_5247.field_24342) {
                        Map.Entry<String, Boolean> showTextContents = FancyText.stringify((class_2561)partStyle.method_10969().method_10891(class_2568.class_5247.field_24342));
                        if (showTextContents.getValue().booleanValue()) {
                            errors.setPlain(true);
                        }
                        output.append('{');
                        output.append(showTextContents.getKey());
                        output.append('}');
                    } else if (partStyle.method_10969().method_10892() == class_2568.class_5247.field_24343) {
                        errors.setPlain(true);
                    } else if (partStyle.method_10969().method_10892() == class_2568.class_5247.field_24344) {
                        output.append('{');
                        output.append(((class_2568.class_5248)partStyle.method_10969().method_10891((class_2568.class_5247)class_2568.class_5247.field_24344)).field_24352.toString());
                        output.append('}');
                        errors.setPlain(true);
                    }
                    output.append("(");
                }
                if (partStyle.method_10955() != null) {
                    output.append("[insertion]{");
                    output.append(partStyle.method_10955().replace("\\", "\\\\").replace("{", "\\{").replace("}", "\\}"));
                    output.append("}(");
                }
                if (partStyle.field_24361 != null) {
                    output.append("[font]{");
                    output.append(partStyle.field_24361.toString());
                    output.append("}(");
                }
            }
            AtomicReference currentStyle = clickEvent.getPlain() != null || hoverEvent.getPlain() != null ? eventContentsStyle : style;
            class_2583 changes = StyleUtil.minus(partStyle, (class_2583)currentStyle.getPlain());
            currentStyle.setPlain(partStyle);
            if (changes.field_11856 != null && changes.field_11856 == false || changes.field_11852 != null && changes.field_11852 == false || changes.field_11851 != null && changes.field_11851 == false || changes.field_11857 != null && changes.field_11857 == false || changes.field_11861 != null && !changes.field_11861.booleanValue()) {
                output.append("&r");
                changes = StyleUtil.minus(partStyle, StyleUtil.RESET_STYLE);
            }
            if (changes.method_10973() != null) {
                class_124 formatting = class_124.method_533((String)changes.method_10973().method_27721());
                if (formatting == null) {
                    output.append("&" + changes.method_10973().method_27723());
                } else {
                    output.append("&" + formatting.method_36145());
                }
            }
            if (StyleUtil.SHADOW_COLOR_EXISTS && changes.method_65301() != null) {
                if (changes.method_65301() >>> 24 == 255) {
                    output.append(String.format("&_#%06X;", changes.method_65301() & 0xFFFFFF));
                } else {
                    output.append(String.format("&_#%08X;", changes.method_65301()));
                }
            }
            if (changes.method_10984()) {
                output.append("&l");
            }
            if (changes.method_10966()) {
                output.append("&o");
            }
            if (changes.method_10965()) {
                output.append("&n");
            }
            if (changes.method_10986()) {
                output.append("&m");
            }
            if (changes.method_10987()) {
                output.append("&k");
            }
            output.append(partText.replace("\\", "\\\\").replace("&", "\\&").replace("\u00a7", "\\\u00a7").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}"));
            return Optional.empty();
        }, base);
        if (clickEvent.getPlain() != null) {
            output.append(')');
        }
        if (hoverEvent.getPlain() != null) {
            output.append(')');
        }
        if (insertion.getPlain() != null) {
            output.append(')');
        }
        if (font.getPlain() != null) {
            output.append(')');
        }
        return Map.entry(output.toString(), errors.getPlain());
    }

    public static class_2561 parse(String str) {
        return FancyText.parse(str, class_2583.field_24360);
    }

    public static Map.Entry<String, Boolean> stringify(class_2561 text) {
        return FancyText.stringify(text, class_2583.field_24360);
    }
}

