/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.containers;

import com.luneruniverse.minecraft.mod.nbteditor.containers.ItemContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.NBTContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.SourceContainerType;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class ItemTagContainerIO
implements ItemContainerIO {
    private final String tag;
    private final NBTContainerIO nbtIO;

    protected static class_2487 getNBT(LocalNBT localNBT) {
        class_2487 nbt = localNBT.getNBT();
        return nbt == null ? new class_2487() : nbt;
    }

    public ItemTagContainerIO(String tag, NBTContainerIO nbtIO) {
        this.tag = tag;
        this.nbtIO = nbtIO;
    }

    private class_2487 getNBT(class_1799 item) {
        class_2487 nbt = item.manager$getNbt();
        if (nbt == null) {
            nbt = new class_2487();
        }
        if (this.tag == null || this.nbtIO.getDefaultEntityId() == null) {
            return nbt;
        }
        return nbt.method_10562(this.tag);
    }

    private void setNBT(class_1799 item, class_2487 nbt) {
        String defaultEntityId = this.nbtIO.getDefaultEntityId();
        if (this.tag == null || defaultEntityId == null) {
            item.manager$setNbt(nbt);
        } else {
            item.manager$modifyNbt(itemNbt -> itemNbt.method_10566(this.tag, (class_2520)MainUtil.fillId(nbt, defaultEntityId)));
        }
    }

    @Override
    public int getMaxItemSize(class_1799 item) {
        return this.nbtIO.getMaxNBTSize(item == null ? null : this.getNBT(item), SourceContainerType.ITEM);
    }

    @Override
    public boolean isItemReadable(class_1799 item) {
        return this.nbtIO.isNBTReadable(this.getNBT(item), SourceContainerType.ITEM);
    }

    @Override
    public class_1799[] readItem(class_1799 container) {
        return this.nbtIO.readNBT(this.getNBT(container), SourceContainerType.ITEM);
    }

    @Override
    public int writeItem(class_1799 container, class_1799[] contents) {
        class_2487 nbt = this.getNBT(container);
        int output = this.nbtIO.writeNBT(nbt, contents, SourceContainerType.ITEM);
        this.setNBT(container, nbt);
        return output;
    }

    @Override
    public int getWrittenItemSlotIndex(class_1799 container, class_1799[] contents, int slot) {
        return this.nbtIO.getWrittenNBTSlotIndex(this.getNBT(container), contents, slot, SourceContainerType.ITEM);
    }
}

