/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.containers;

import com.luneruniverse.minecraft.mod.nbteditor.containers.EntityContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ItemTagContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.NBTContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.NonItemNBTContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.SourceContainerType;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalEntity;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.TagNames;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class EntityTagContainerIO
extends ItemTagContainerIO
implements EntityContainerIO {
    private final NonItemNBTContainerIO entityNbtIO;

    public EntityTagContainerIO(NBTContainerIO itemNbtIO, NonItemNBTContainerIO entityNbtIO) {
        super(TagNames.ENTITY_TAG, itemNbtIO);
        this.entityNbtIO = entityNbtIO;
    }

    public EntityTagContainerIO(NBTContainerIO nbtIO) {
        this(nbtIO, (NonItemNBTContainerIO)nbtIO);
    }

    @Override
    public int getMaxEntitySize(LocalEntity entity) {
        return this.entityNbtIO.getMaxNBTSize(EntityTagContainerIO.getNBT(entity), SourceContainerType.ENTITY);
    }

    @Override
    public boolean isEntityReadable(LocalEntity entity) {
        return this.entityNbtIO.isNBTReadable(EntityTagContainerIO.getNBT(entity), SourceContainerType.ENTITY);
    }

    @Override
    public class_1799[] readEntity(LocalEntity container) {
        return this.entityNbtIO.readNBT(EntityTagContainerIO.getNBT(container), SourceContainerType.ENTITY);
    }

    @Override
    public int writeEntity(LocalEntity container, class_1799[] contents) {
        class_2487 nbt = EntityTagContainerIO.getNBT(container);
        int output = this.entityNbtIO.writeNBT(nbt, contents, SourceContainerType.ENTITY);
        container.setNBT(nbt);
        return output;
    }

    @Override
    public int getWrittenEntitySlotIndex(LocalEntity container, class_1799[] contents, int slot) {
        return this.entityNbtIO.getWrittenNBTSlotIndex(EntityTagContainerIO.getNBT(container), contents, slot, SourceContainerType.ENTITY);
    }
}

