/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.containers;

import com.luneruniverse.minecraft.mod.nbteditor.containers.NonItemNBTContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.SourceContainerType;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Arrays;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class DynamicSizeContainerIO
implements NonItemNBTContainerIO {
    private final String key;
    private final int maxSize;

    public DynamicSizeContainerIO(String key, int maxSize) {
        this.key = key;
        this.maxSize = maxSize;
    }

    @Override
    public int getMaxNBTSize(class_2487 nbt, SourceContainerType source) {
        return this.maxSize;
    }

    @Override
    public boolean isNBTReadable(class_2487 nbt, SourceContainerType source) {
        return nbt.method_10554(this.key, 10).size() <= this.maxSize;
    }

    @Override
    public class_1799[] readNBT(class_2487 container, SourceContainerType source) {
        return (class_1799[])container.method_10554(this.key, 10).stream().limit(this.maxSize).map(item -> NBTManagers.ITEM.deserialize((class_2487)item, true)).toArray(class_1799[]::new);
    }

    @Override
    public int writeNBT(class_2487 container, class_1799[] contents, SourceContainerType source) {
        class_2499 nbt = Arrays.stream(contents).limit(this.maxSize).filter(item -> item != null && !item.method_7960()).map(item -> item.manager$serialize(true)).collect(class_2499::new, AbstractList::add, AbstractCollection::addAll);
        container.method_10566(this.key, (class_2520)nbt);
        return Math.min(contents.length, this.maxSize);
    }

    @Override
    public int getWrittenNBTSlotIndex(class_2487 container, class_1799[] contents, int slot, SourceContainerType source) {
        int output = slot;
        for (int i = 0; i < slot; ++i) {
            if (contents[i] != null && !contents[i].method_7960()) continue;
            --output;
        }
        return output;
    }
}

