/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.containers;

import com.luneruniverse.minecraft.mod.nbteditor.containers.ConstSizeContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.NonItemNBTContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.SourceContainerType;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class DonkeyChestContainerIO
implements NonItemNBTContainerIO {
    private static final boolean ITEMS_SHIFTED = Version.newSwitch().range("1.20.5", null, false).range(null, "1.20.4", true).get();
    private final boolean llama;
    private final ConstSizeContainerIO chest;

    public DonkeyChestContainerIO(boolean llama) {
        this.llama = llama;
        this.chest = new ConstSizeContainerIO(ITEMS_SHIFTED ? 17 : 15);
    }

    @Override
    public int getMaxNBTSize(class_2487 nbt, SourceContainerType source) {
        return 15;
    }

    @Override
    public class_1799[] readNBT(class_2487 container, SourceContainerType source) {
        class_1799[] output = this.chest.readNBT(container, SourceContainerType.ENTITY);
        if (ITEMS_SHIFTED) {
            class_1799[] temp = new class_1799[15];
            System.arraycopy(output, 2, temp, 0, temp.length);
            output = temp;
        }
        return output;
    }

    @Override
    public int writeNBT(class_2487 container, class_1799[] contents, SourceContainerType source) {
        class_1799[] shiftedContents = contents;
        if (ITEMS_SHIFTED) {
            shiftedContents = new class_1799[contents.length + 2];
            shiftedContents[0] = class_1799.field_8037;
            shiftedContents[1] = class_1799.field_8037;
            System.arraycopy(contents, 0, shiftedContents, 2, contents.length);
        }
        int output = this.chest.writeNBT(container, shiftedContents, SourceContainerType.ENTITY) - (ITEMS_SHIFTED ? 2 : 0);
        for (class_1799 item : contents) {
            if (item == null || item.method_7960()) continue;
            container.method_10556("ChestedHorse", true);
            break;
        }
        if (this.llama) {
            int columns = 1;
            for (int i = 3; i < contents.length; ++i) {
                if (contents[i] == null || contents[i].method_7960()) continue;
                columns = i / 3 + 1;
            }
            if (columns != 1 && container.method_10550("Strength") < columns) {
                container.method_10569("Strength", columns);
            }
        }
        return output;
    }
}

