/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.containers;

import com.luneruniverse.minecraft.mod.nbteditor.containers.ArmorHandsContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.BlockContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.BlockEntityTagContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ChiseledBookshelfContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ConcatNonItemNBTContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ConstSizeContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.DonkeyChestContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.DynamicSizeContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.EntityContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.EntityTagContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ItemContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.SpawnEggContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.SpecificItemsContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalBlock;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalEntity;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItemStack;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVClientNetworking;
import com.luneruniverse.minecraft.mod.nbteditor.server.ServerMVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.TagNames;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2480;
import net.minecraft.class_2591;
import net.minecraft.class_5537;
import net.minecraft.class_7264;

public class ContainerIO {
    private static final Map<class_1792, ItemContainerIO> ITEM_IO = new HashMap<class_1792, ItemContainerIO>();
    private static final Map<class_2248, BlockContainerIO> BLOCK_IO = new HashMap<class_2248, BlockContainerIO>();
    private static final Map<class_1299<?>, EntityContainerIO> ENTITY_IO = new HashMap();
    private static final BlockEntityTagContainerIO CHEST_IO = new BlockEntityTagContainerIO(new ConstSizeContainerIO(27));
    private static final BlockEntityTagContainerIO FURNACE_IO = new BlockEntityTagContainerIO(new ConstSizeContainerIO(3));
    private static final BlockEntityTagContainerIO BREWING_STAND_IO = new BlockEntityTagContainerIO(new ConstSizeContainerIO(5));
    private static final BlockEntityTagContainerIO CAMPFIRE_IO = new BlockEntityTagContainerIO(new ConstSizeContainerIO(4));
    private static final BlockEntityTagContainerIO DISPENSER_IO = new BlockEntityTagContainerIO(new ConstSizeContainerIO(9));
    private static final BlockEntityTagContainerIO HOPPER_IO = new BlockEntityTagContainerIO(new ConstSizeContainerIO(5));
    private static final BlockEntityTagContainerIO JUKEBOX_IO = new BlockEntityTagContainerIO(new SpecificItemsContainerIO("RecordItem").withItemSupport(class_2591.field_11907));
    private static final BlockEntityTagContainerIO LECTERN_IO = new BlockEntityTagContainerIO(new SpecificItemsContainerIO("Book").withItemSupport(class_2591.field_16412));
    private static final Function<class_1299<?>, EntityTagContainerIO> ITEM_FRAME_IO = entity -> new EntityTagContainerIO(new SpecificItemsContainerIO("Item").withItemSupport((class_1299<?>)entity));
    private static final ItemContainerIO BUNDLE_IO = ItemContainerIO.forNBTIO(new DynamicSizeContainerIO(TagNames.BUNDLE_CONTENTS, 27).withItemSupport((String)null));
    private static final BlockEntityTagContainerIO CHISELED_BOOKSHELF_IO = new ChiseledBookshelfContainerIO();
    private static final BlockEntityTagContainerIO SUSPICIOUS_SAND_IO = (BlockEntityTagContainerIO)((Object)Version.newSwitch().range("1.20.0", (String)null, () -> new BlockEntityTagContainerIO(new SpecificItemsContainerIO("item").withItemSupport(class_2591.field_42780))).range((String)null, "1.19.4", () -> null).get());
    private static final BlockEntityTagContainerIO DECORATED_POT_IO = (BlockEntityTagContainerIO)((Object)Version.newSwitch().range("1.20.5", (String)null, () -> new BlockEntityTagContainerIO(new ConstSizeContainerIO(1), new SpecificItemsContainerIO("item"))).range("1.20.3", "1.20.4", () -> new BlockEntityTagContainerIO(new SpecificItemsContainerIO("item").withItemSupport(class_2591.field_42781))).range((String)null, "1.20.2", () -> null).get());
    private static final BlockEntityTagContainerIO CRAFTER_IO = new BlockEntityTagContainerIO(new ConstSizeContainerIO(9));
    private static final ItemContainerIO SPAWN_EGG_IO = new SpawnEggContainerIO();
    private static final Function<class_1299<?>, EntityTagContainerIO> ARMOR_HANDS_IO = entity -> new EntityTagContainerIO(new ArmorHandsContainerIO().withItemSupport((class_1299<?>)entity));
    private static final EntityContainerIO HORSE_IO = EntityContainerIO.forNBTIO(new SpecificItemsContainerIO("SaddleItem", TagNames.ARMOR_ITEM));
    private static final EntityContainerIO BASIC_HORSE_IO = EntityContainerIO.forNBTIO(new SpecificItemsContainerIO("SaddleItem"));
    private static final EntityContainerIO DONKEY_IO = EntityContainerIO.forNBTIO(new ConcatNonItemNBTContainerIO(new SpecificItemsContainerIO("SaddleItem"), new DonkeyChestContainerIO(false)));
    private static final EntityContainerIO LLAMA_IO = EntityContainerIO.forNBTIO(new ConcatNonItemNBTContainerIO(new SpecificItemsContainerIO(TagNames.DECOR_ITEM), new DonkeyChestContainerIO(true)));
    private static final EntityContainerIO CHEST_BOAT_IO = new EntityTagContainerIO(new ConstSizeContainerIO(27));

    public static void registerItemIO(class_1792 item, ItemContainerIO io) {
        ITEM_IO.put(item, io);
    }

    public static void registerBlockIO(class_2248 block, BlockContainerIO io) {
        BLOCK_IO.put(block, io);
    }

    public static void registerEntityIO(class_1299<?> entity, EntityContainerIO io) {
        ENTITY_IO.put(entity, io);
    }

    public static void registerBlockEntityTagIO(class_1747 blockItem, BlockEntityTagContainerIO io) {
        ContainerIO.registerItemIO((class_1792)blockItem, io);
        ContainerIO.registerBlockIO(blockItem.method_7711(), io);
    }

    public static void registerBlockEntityTagIO(class_1747 blockItem, Function<class_2591<?>, BlockEntityTagContainerIO> io) {
        ContainerIO.registerBlockEntityTagIO(blockItem, io.apply(((class_2237)blockItem.method_7711()).method_10123(class_2338.field_10980, blockItem.method_7711().method_9564()).method_11017()));
    }

    public static void registerEntityTagIO(class_1792 item, class_1299<?> entity, EntityTagContainerIO io) {
        ContainerIO.registerItemIO(item, io);
        ContainerIO.registerEntityIO(entity, io);
    }

    public static void registerEntityTagIO(class_1792 item, class_1299<?> entity, Function<class_1299<?>, EntityTagContainerIO> io) {
        ContainerIO.registerEntityTagIO(item, entity, io.apply(entity));
    }

    public static void loadClass() {
    }

    public static int getMaxSize(class_1792 item) {
        ItemContainerIO io = ITEM_IO.get(item);
        return io == null ? 0 : io.getMaxItemSize(null);
    }

    public static int getMaxSize(class_2248 block) {
        BlockContainerIO io = BLOCK_IO.get(block);
        return io == null ? 0 : io.getMaxBlockSize(null);
    }

    public static int getMaxSize(class_1299<?> entity) {
        EntityContainerIO io = ENTITY_IO.get(entity);
        return io == null ? 0 : io.getMaxEntitySize(null);
    }

    public static int getMaxSize(class_1799 item) {
        ItemContainerIO io = ITEM_IO.get(item.method_7909());
        return io == null ? 0 : io.getMaxItemSize(item);
    }

    public static boolean isContainer(class_1799 item) {
        ItemContainerIO io = ITEM_IO.get(item.method_7909());
        return io != null && io.isItemReadable(item);
    }

    public static class_1799[] read(class_1799 container) {
        class_1799[] output = ITEM_IO.get(container.method_7909()).readItem(container);
        for (int i = 0; i < output.length; ++i) {
            if (output[i] != null) continue;
            output[i] = class_1799.field_8037;
        }
        return output;
    }

    public static int write(class_1799 container, class_1799[] contents) {
        return ITEM_IO.get(container.method_7909()).writeItem(container, contents);
    }

    public static int getWrittenSlotIndex(class_1799 container, class_1799[] contents, int slot) {
        return ITEM_IO.get(container.method_7909()).getWrittenItemSlotIndex(container, contents, slot);
    }

    public static int getMaxSize(LocalNBT nbt) {
        if (nbt instanceof LocalItem) {
            LocalItem item = (LocalItem)nbt;
            ItemContainerIO io = ITEM_IO.get(item.getItemType());
            return io == null ? 0 : io.getMaxItemSize(item.getReadableItem());
        }
        if (nbt instanceof LocalBlock) {
            LocalBlock block = (LocalBlock)nbt;
            BlockContainerIO io = BLOCK_IO.get(block.getBlock());
            return io == null ? 0 : io.getMaxBlockSize(block);
        }
        if (nbt instanceof LocalEntity) {
            LocalEntity entity = (LocalEntity)nbt;
            EntityContainerIO io = ENTITY_IO.get(entity.getEntityType());
            return io == null ? 0 : io.getMaxEntitySize(entity);
        }
        return 0;
    }

    public static boolean isContainer(LocalNBT nbt) {
        if (nbt instanceof LocalItem) {
            LocalItem item = (LocalItem)nbt;
            ItemContainerIO io = ITEM_IO.get(item.getItemType());
            return io != null && io.isItemReadable(item.getReadableItem());
        }
        if (nbt instanceof LocalBlock) {
            LocalBlock block = (LocalBlock)nbt;
            BlockContainerIO io = BLOCK_IO.get(block.getBlock());
            return io != null && io.isBlockReadable(block);
        }
        if (nbt instanceof LocalEntity) {
            LocalEntity entity = (LocalEntity)nbt;
            EntityContainerIO io = ENTITY_IO.get(entity.getEntityType());
            return io != null && io.isEntityReadable(entity);
        }
        return false;
    }

    public static class_1799[] read(LocalNBT container) {
        class_1799[] output = null;
        if (container instanceof LocalItem) {
            LocalItem item = (LocalItem)container;
            output = ITEM_IO.get(item.getItemType()).readItem(item.getReadableItem());
        }
        if (container instanceof LocalBlock) {
            LocalBlock block = (LocalBlock)container;
            output = BLOCK_IO.get(block.getBlock()).readBlock(block);
        }
        if (container instanceof LocalEntity) {
            LocalEntity entity = (LocalEntity)container;
            output = ENTITY_IO.get(entity.getEntityType()).readEntity(entity);
        }
        if (output == null) {
            throw new IllegalArgumentException("Not a container!");
        }
        for (int i = 0; i < output.length; ++i) {
            if (output[i] != null) continue;
            output[i] = class_1799.field_8037;
        }
        return output;
    }

    public static int write(LocalNBT container, class_1799[] contents) {
        if (container instanceof LocalItem) {
            LocalItem item = (LocalItem)container;
            return ITEM_IO.get(item.getItemType()).writeItem(item.getEditableItem(), contents);
        }
        if (container instanceof LocalBlock) {
            LocalBlock block = (LocalBlock)container;
            return BLOCK_IO.get(block.getBlock()).writeBlock(block, contents);
        }
        if (container instanceof LocalEntity) {
            LocalEntity entity = (LocalEntity)container;
            return ENTITY_IO.get(entity.getEntityType()).writeEntity(entity, contents);
        }
        throw new IllegalArgumentException("Not a container!");
    }

    public static int getWrittenSlotIndex(LocalNBT container, class_1799[] contents, int slot) {
        if (container instanceof LocalItem) {
            LocalItem item = (LocalItem)container;
            return ITEM_IO.get(item.getItemType()).getWrittenItemSlotIndex(item.getEditableItem(), contents, slot);
        }
        if (container instanceof LocalBlock) {
            LocalBlock block = (LocalBlock)container;
            return BLOCK_IO.get(block.getBlock()).getWrittenBlockSlotIndex(block, contents, slot);
        }
        if (container instanceof LocalEntity) {
            LocalEntity entity = (LocalEntity)container;
            return ENTITY_IO.get(entity.getEntityType()).getWrittenEntitySlotIndex(entity, contents, slot);
        }
        throw new IllegalArgumentException("Not a container!");
    }

    private static void writeRecursively(LocalNBT container, Supplier<class_1799> subContainers, List<class_1799> contents, String path) {
        int maxSize = ContainerIO.getMaxSize(container);
        if (contents.size() <= maxSize) {
            ContainerIO.write(container, (class_1799[])contents.toArray(class_1799[]::new));
            return;
        }
        class_1799[] sections = new class_1799[maxSize];
        int sectionSize = maxSize;
        while (contents.size() / sectionSize > maxSize) {
            sectionSize *= maxSize;
        }
        for (int i = 0; i < maxSize && i * sectionSize < contents.size(); ++i) {
            class_1799 section = subContainers.get();
            String subPath = path == null ? "" + i : path + "." + i;
            section.manager$setCustomName(TextInst.of(TextInst.translatable("nbteditor.hdb.section", new Object[0]).getString() + ": " + subPath));
            ContainerIO.writeRecursively(new LocalItemStack(section), subContainers, contents.subList(i * sectionSize, Math.min(contents.size(), (i + 1) * sectionSize)), subPath);
            sections[i] = section;
        }
        ContainerIO.write(container, sections);
    }

    public static void writeRecursively(LocalNBT container, Supplier<class_1799> subContainers, List<class_1799> contents) {
        ContainerIO.writeRecursively(container, subContainers, contents, null);
    }

    public static void writeRecursively(class_1799 container, List<class_1799> contents) {
        ContainerIO.writeRecursively(new LocalItemStack(container), () -> new class_1799((class_1935)class_1802.field_8545), contents);
    }

    static {
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_8106, CHEST_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_8247, CHEST_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_16307, CHEST_IO);
        for (class_1792 item : MVRegistry.ITEM) {
            class_1747 blockItem;
            if (!(item instanceof class_1747) || !((blockItem = (class_1747)item).method_7711() instanceof class_2480)) continue;
            ContainerIO.registerBlockEntityTagIO(blockItem, CHEST_IO);
        }
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_8732, FURNACE_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_16306, FURNACE_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_16309, FURNACE_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_8740, BREWING_STAND_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_17346, CAMPFIRE_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_23842, CAMPFIRE_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_8357, DISPENSER_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_8878, DISPENSER_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_8239, HOPPER_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_8565, JUKEBOX_IO);
        ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_16312, LECTERN_IO);
        ContainerIO.registerEntityTagIO(class_1802.field_8143, class_1299.field_6043, ITEM_FRAME_IO);
        ContainerIO.registerEntityTagIO(class_1802.field_28408, class_1299.field_28401, ITEM_FRAME_IO);
        for (class_1792 item : MVRegistry.ITEM) {
            if (!(item instanceof class_5537)) continue;
            class_5537 bundle = (class_5537)item;
            ContainerIO.registerItemIO((class_1792)bundle, BUNDLE_IO);
        }
        Version.newSwitch().range("1.20.0", (String)null, () -> {
            ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_40215, CHISELED_BOOKSHELF_IO);
            ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_42689, SUSPICIOUS_SAND_IO);
            ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_43191, SUSPICIOUS_SAND_IO);
        }).range((String)null, "1.19.4", () -> {}).run();
        Version.newSwitch().range("1.20.3", (String)null, () -> ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_42699, DECORATED_POT_IO)).range((String)null, "1.20.2", () -> {}).run();
        Version.newSwitch().range("1.21.0", (String)null, () -> ContainerIO.registerBlockEntityTagIO((class_1747)class_1802.field_46791, CRAFTER_IO)).range((String)null, "1.20.6", () -> {}).run();
        ContainerIO.registerEntityTagIO(class_1802.field_8694, class_1299.field_6131, ARMOR_HANDS_IO);
        for (class_1792 item : MVRegistry.ITEM) {
            if (!(item instanceof class_1826)) continue;
            class_1826 spawnEgg = (class_1826)item;
            ContainerIO.registerItemIO((class_1792)spawnEgg, SPAWN_EGG_IO);
        }
        ContainerIO.registerEntityIO(class_1299.field_6139, HORSE_IO);
        ContainerIO.registerEntityIO(class_1299.field_6075, BASIC_HORSE_IO);
        ContainerIO.registerEntityIO(class_1299.field_6048, BASIC_HORSE_IO);
        Version.newSwitch().range("1.20.0", (String)null, () -> ContainerIO.registerEntityIO(class_1299.field_40116, BASIC_HORSE_IO)).range((String)null, "1.19.4", () -> {}).run();
        ContainerIO.registerEntityIO(class_1299.field_6067, DONKEY_IO);
        ContainerIO.registerEntityIO(class_1299.field_6057, DONKEY_IO);
        ContainerIO.registerEntityIO(class_1299.field_6074, LLAMA_IO);
        ContainerIO.registerEntityIO(class_1299.field_17714, LLAMA_IO);
        MVClientNetworking.PlayNetworkStateEvents.Join.EVENT.register(() -> {
            for (class_1299<?> entityType : MVRegistry.ENTITY_TYPE) {
                if (ENTITY_IO.containsKey(entityType)) continue;
                class_1297 entity = ServerMVMisc.createEntity(entityType, (class_1937)MainUtil.client.field_1687);
                if (entity instanceof class_1308) {
                    ContainerIO.registerEntityIO(entityType, ARMOR_HANDS_IO.apply(entityType));
                }
                Version.newSwitch().range("1.19.0", (String)null, () -> {
                    if (entity instanceof class_7264) {
                        ContainerIO.registerEntityIO(entityType, CHEST_BOAT_IO);
                    }
                }).range((String)null, "1.18.2", () -> {}).run();
            }
        });
    }
}

