/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.containers;

import com.luneruniverse.minecraft.mod.nbteditor.containers.NBTContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.SourceContainerType;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ConstSizeContainerIO
implements NBTContainerIO {
    private final int numItems;

    public ConstSizeContainerIO(int numItems) {
        this.numItems = numItems;
    }

    @Override
    public String getDefaultEntityId() {
        return NBTManagers.COMPONENTS_EXIST ? null : "";
    }

    @Override
    public int getMaxNBTSize(class_2487 nbt, SourceContainerType source) {
        return this.numItems;
    }

    @Override
    public class_1799[] readNBT(class_2487 container, SourceContainerType source) {
        boolean itemComponent = NBTManagers.COMPONENTS_EXIST && source == SourceContainerType.ITEM;
        class_1799[] items = new class_1799[this.numItems];
        class_2499 itemsNbt = container.method_10554(itemComponent ? "minecraft:container" : "Items", 10);
        for (class_2520 itemNbtElement : itemsNbt) {
            class_2487 itemNbt = (class_2487)itemNbtElement;
            int slot = itemNbt.method_10550(itemComponent ? "slot" : "Slot");
            if (slot < 0 || slot >= this.numItems) continue;
            items[slot] = NBTManagers.ITEM.deserialize(itemComponent ? itemNbt.method_10562("item") : itemNbt, true);
        }
        return items;
    }

    @Override
    public int writeNBT(class_2487 container, class_1799[] contents, SourceContainerType source) {
        boolean itemComponent = NBTManagers.COMPONENTS_EXIST && source == SourceContainerType.ITEM;
        class_2499 itemsNbt = new class_2499();
        for (int i = 0; i < contents.length; ++i) {
            String slotKey;
            class_1799 item = contents[i];
            if (item == null || item.method_7960()) continue;
            class_2487 itemNbt = item.manager$serialize(true);
            if (itemComponent) {
                class_2487 wrapper = new class_2487();
                wrapper.method_10566("item", (class_2520)itemNbt);
                itemNbt = wrapper;
            }
            String string = slotKey = itemComponent ? "slot" : "Slot";
            if (i < 128) {
                itemNbt.method_10567(slotKey, (byte)i);
            } else {
                itemNbt.method_10569(slotKey, i);
            }
            itemsNbt.add((Object)itemNbt);
        }
        container.method_10566(itemComponent ? "minecraft:container" : "Items", (class_2520)itemsNbt);
        return this.numItems;
    }
}

