/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.containers;

import com.luneruniverse.minecraft.mod.nbteditor.containers.NonItemNBTContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.SourceContainerType;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class ConcatNonItemNBTContainerIO
implements NonItemNBTContainerIO {
    private final NonItemNBTContainerIO[] nbtIOs;

    public ConcatNonItemNBTContainerIO(NonItemNBTContainerIO ... nbtIOs) {
        this.nbtIOs = nbtIOs;
    }

    @Override
    public int getMaxNBTSize(class_2487 nbt, SourceContainerType source) {
        int total = 0;
        for (NonItemNBTContainerIO nbtIO : this.nbtIOs) {
            int size = nbtIO.getMaxNBTSize(nbt, source);
            if (size == 0) {
                return 0;
            }
            total += size;
        }
        return total;
    }

    @Override
    public boolean isNBTReadable(class_2487 nbt, SourceContainerType source) {
        for (NonItemNBTContainerIO nbtIO : this.nbtIOs) {
            if (nbtIO.isNBTReadable(nbt, source)) continue;
            return false;
        }
        return true;
    }

    @Override
    public class_1799[] readNBT(class_2487 container, SourceContainerType source) {
        ArrayList<class_1799> output = new ArrayList<class_1799>();
        for (NonItemNBTContainerIO nbtIO : this.nbtIOs) {
            for (class_1799 item : nbtIO.readNBT(container, source)) {
                output.add(item);
            }
        }
        return (class_1799[])output.toArray(class_1799[]::new);
    }

    @Override
    public int writeNBT(class_2487 container, class_1799[] contents, SourceContainerType source) {
        int total = 0;
        for (NonItemNBTContainerIO nbtIO : this.nbtIOs) {
            int numWritten = nbtIO.writeNBT(container, contents, source);
            if (numWritten >= contents.length) {
                contents = new class_1799[]{};
            } else {
                class_1799[] temp = new class_1799[contents.length - numWritten];
                System.arraycopy(contents, numWritten, temp, 0, temp.length);
                contents = temp;
            }
            total += numWritten;
        }
        return total;
    }

    @Override
    public int getWrittenNBTSlotIndex(class_2487 container, class_1799[] contents, int slot, SourceContainerType source) {
        class_2487 tempContainer = container.method_10553();
        int total = 0;
        for (NonItemNBTContainerIO nbtIO : this.nbtIOs) {
            int numWritten = nbtIO.writeNBT(tempContainer, contents, source);
            if (slot < total + numWritten) {
                return nbtIO.getWrittenNBTSlotIndex(container, contents, slot - total, source) + total;
            }
            if (numWritten >= contents.length) {
                contents = new class_1799[]{};
            } else {
                class_1799[] temp = new class_1799[contents.length - numWritten];
                System.arraycopy(contents, numWritten, temp, 0, temp.length);
                contents = temp;
            }
            total += numWritten;
        }
        throw new IllegalArgumentException("Slot is never written: " + slot);
    }
}

