/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.containers;

import com.luneruniverse.minecraft.mod.nbteditor.containers.BlockContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ItemTagContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.NBTContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.NonItemNBTContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.SourceContainerType;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalBlock;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.TagNames;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class BlockEntityTagContainerIO
extends ItemTagContainerIO
implements BlockContainerIO {
    private final NonItemNBTContainerIO blockNbtIO;

    public BlockEntityTagContainerIO(NBTContainerIO itemNbtIO, NonItemNBTContainerIO blockNbtIO) {
        super(TagNames.BLOCK_ENTITY_TAG, itemNbtIO);
        this.blockNbtIO = blockNbtIO;
    }

    public BlockEntityTagContainerIO(NBTContainerIO nbtIO) {
        this(nbtIO, (NonItemNBTContainerIO)nbtIO);
    }

    @Override
    public int getMaxBlockSize(LocalBlock block) {
        return this.blockNbtIO.getMaxNBTSize(BlockEntityTagContainerIO.getNBT(block), SourceContainerType.BLOCK);
    }

    @Override
    public boolean isBlockReadable(LocalBlock block) {
        return this.blockNbtIO.isNBTReadable(BlockEntityTagContainerIO.getNBT(block), SourceContainerType.BLOCK);
    }

    @Override
    public class_1799[] readBlock(LocalBlock container) {
        return this.blockNbtIO.readNBT(BlockEntityTagContainerIO.getNBT(container), SourceContainerType.BLOCK);
    }

    @Override
    public int writeBlock(LocalBlock container, class_1799[] contents) {
        class_2487 nbt = BlockEntityTagContainerIO.getNBT(container);
        int output = this.blockNbtIO.writeNBT(nbt, contents, SourceContainerType.BLOCK);
        container.setNBT(nbt);
        return output;
    }

    @Override
    public int getWrittenBlockSlotIndex(LocalBlock container, class_1799[] contents, int slot) {
        return this.blockNbtIO.getWrittenNBTSlotIndex(BlockEntityTagContainerIO.getNBT(container), contents, slot, SourceContainerType.BLOCK);
    }
}

