/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.nbt;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalBlock;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalEntity;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReferenceFilter;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.TagNames;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_4239;

public class NBTExportCommand
extends ClientCommand {
    public static final NBTReferenceFilter EXPORT_FILTER = NBTReferenceFilter.create(ref -> true, ref -> true, ref -> true, TextInst.translatable("nbteditor.no_ref.to_export", new Object[0]), TextInst.translatable("nbteditor.no_hand.no_item.to_export", new Object[0]));
    public static final NBTReferenceFilter EXPORT_ITEM_FILTER = NBTReferenceFilter.create(null, ref -> true, ref -> true, TextInst.translatable("nbteditor.no_ref.to_export_item", new Object[0]), TextInst.translatable("nbteditor.requires_server", new Object[0]));
    private static final File exportDir = new File(NBTEditorClient.SETTINGS_FOLDER, "exported");

    private static LocalEntity stripEntityTags(LocalEntity entity, String ... tags) {
        LocalEntity output = entity.copy();
        NBTExportCommand.stripEntityTags(output.getNBT(), tags);
        return output;
    }

    private static void stripEntityTags(class_2487 nbt, String ... tags) {
        for (String tag : tags) {
            nbt.method_10551(tag);
        }
        for (class_2520 passenger : nbt.method_10554("Passengers", 10)) {
            NBTExportCommand.stripEntityTags((class_2487)passenger, tags);
        }
    }

    private static String getItemArgs(class_1799 item) {
        return MVRegistry.ITEM.getId(item.method_7909()).toString() + NBTManagers.ITEM.getNbtString(item) + " " + item.method_7947();
    }

    private static String getBlockArgs(LocalBlock block) {
        return block.getId().toString() + block.getState().toString() + (block.getNBT() == null ? "" : block.getNBT().method_10714());
    }

    private static String getEntityArgs(LocalEntity entity) {
        return entity.getId().toString() + " ~ ~ ~" + (String)(entity.getNBT() == null ? "" : " " + entity.getNBT().method_10714());
    }

    private static String getCommand(String itemPrefix, String blockPrefix, String entityPrefix, LocalNBT nbt, boolean stripEntityUUIDs) {
        if (nbt instanceof LocalItem) {
            LocalItem item = (LocalItem)nbt;
            return itemPrefix + NBTExportCommand.getItemArgs(item.getReadableItem());
        }
        if (nbt instanceof LocalBlock) {
            LocalBlock block = (LocalBlock)nbt;
            return blockPrefix + NBTExportCommand.getBlockArgs(block);
        }
        if (nbt instanceof LocalEntity) {
            LocalEntity entity = (LocalEntity)nbt;
            return entityPrefix + NBTExportCommand.getEntityArgs(stripEntityUUIDs ? NBTExportCommand.stripEntityTags(entity, "UUID") : entity);
        }
        throw new IllegalArgumentException("Cannot export " + nbt.getClass().getName());
    }

    private static String getVanillaCommand(NBTReference<?> ref) {
        return NBTExportCommand.getCommand("/give @p ", "/setblock ~ ~ ~ ", "/summon ", ref.getLocalNBT(), true);
    }

    private static String getGetCommand(NBTReference<?> ref) {
        return NBTExportCommand.getCommand("/get item ", "/get block ~ ~ ~ ", "/get entity ", ref.getLocalNBT(), false);
    }

    private static void exportToClipboard(String str) {
        MainUtil.client.field_1774.method_1455(str);
        MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.nbt.export.copied", new Object[0]), false);
    }

    private static void exportToFile(class_2487 nbt, String name) {
        try {
            if (!exportDir.exists()) {
                Files.createDirectory(exportDir.toPath(), new FileAttribute[0]);
            }
            File output = new File(exportDir, class_4239.method_19773((Path)exportDir.toPath(), (String)name, (String)".nbt"));
            nbt.method_10569("DataVersion", Version.getDataVersion());
            MVMisc.writeCompressedNbt(nbt, output);
            MainUtil.client.field_1724.method_7353(TextUtil.attachFileTextOptions(TextInst.translatable("nbteditor.nbt.export.file.success", TextInst.literal(output.getName()).formatted(class_124.field_1073).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, output.getAbsolutePath())))), output), false);
        }
        catch (Exception e) {
            NBTEditor.LOGGER.error("Error while exporting item", (Throwable)e);
            MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.nbt.export.file.error", e.getMessage()), false);
        }
    }

    @Override
    public String getName() {
        return "export";
    }

    @Override
    public String getExtremeAlias() {
        return "x";
    }

    @Override
    public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder, String path) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(ClientCommandManager.literal("cmd").executes(context -> {
            NBTReference.getReference(EXPORT_FILTER, false, ref -> NBTExportCommand.exportToClipboard(NBTExportCommand.getVanillaCommand(ref)));
            return 1;
        }))).then(ClientCommandManager.literal("cmdblock").executes(context -> {
            NBTReference.getReference(EXPORT_FILTER, false, ref -> {
                class_1799 cmdBlock = new class_1799((class_1935)class_1802.field_8866);
                cmdBlock.manager$modifySubNbt(TagNames.BLOCK_ENTITY_TAG, nbt -> MainUtil.fillId(nbt, "minecraft:command_block").method_10582("Command", NBTExportCommand.getVanillaCommand(ref)));
                MainUtil.getWithMessage(cmdBlock);
            });
            return 1;
        }))).then(ClientCommandManager.literal("get").executes(context -> {
            NBTReference.getReference(EXPORT_FILTER, false, ref -> NBTExportCommand.exportToClipboard(NBTExportCommand.getGetCommand(ref)));
            return 1;
        }))).then(ClientCommandManager.literal("item").executes(context -> {
            NBTReference.getReference(EXPORT_ITEM_FILTER, false, ref -> {
                Object localNBT = ref.getLocalNBT();
                if (localNBT instanceof LocalEntity) {
                    LocalEntity localEntity = (LocalEntity)localNBT;
                    localNBT = NBTExportCommand.stripEntityTags(localEntity, "UUID", "Pos");
                }
                localNBT.toItem().ifPresentOrElse(MainUtil::getWithMessage, () -> MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.nbt.export.item.error", new Object[0]), false));
            });
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal("file").then(ClientCommandManager.argument("name", StringArgumentType.greedyString()).executes(context -> {
            NBTReference.getReference(EXPORT_FILTER, false, ref -> NBTExportCommand.exportToFile(ref.getLocalNBT().serialize(), (String)context.getArgument("name", String.class)));
            return 1;
        }))).executes(context -> {
            NBTReference.getReference(EXPORT_FILTER, false, ref -> NBTExportCommand.exportToFile(ref.getLocalNBT().serialize(), ref.getLocalNBT().getName().getString() + "_" + MainUtil.getFormattedCurrentTime()));
            return 1;
        }));
    }
}

