/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.factories;

import com.google.gson.JsonParseException;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.arguments.FancyTextArgumentType;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.util.StyleUtil;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class SignatureCommand
extends ClientCommand {
    private static final File SIGNATURE_FILE = new File(NBTEditorClient.SETTINGS_FOLDER, "signature.json");
    private static class_2561 signature;

    @Override
    public String getName() {
        return "signature";
    }

    @Override
    public String getExtremeAlias() {
        return null;
    }

    @Override
    public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder, String path) {
        Command addSignature = context -> {
            ItemReference ref = ItemReference.getHeldItem();
            class_1799 item = ref.getItem();
            List<class_2561> lore = ItemTagReferences.LORE.get(item);
            if (SignatureCommand.hasSignature(lore)) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.translatable("nbteditor.sign.already_added", new Object[0]));
                return 1;
            }
            lore.add(signature);
            ItemTagReferences.LORE.set(item, lore);
            ref.saveItem(item, TextInst.translatable("nbteditor.sign.added", new Object[0]));
            return 1;
        };
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(addSignature)).then(ClientCommandManager.literal("add").executes(addSignature))).then(ClientCommandManager.literal("remove").executes(context -> {
            ItemReference ref = ItemReference.getHeldItem();
            class_1799 item = ref.getItem();
            List<class_2561> lore = ItemTagReferences.LORE.get(item);
            if (!SignatureCommand.hasSignature(lore)) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.translatable("nbteditor.sign.not_added", new Object[0]));
                return 1;
            }
            lore.remove(lore.size() - 1);
            ItemTagReferences.LORE.set(item, lore);
            ref.saveItem(item, TextInst.translatable("nbteditor.sign.removed", new Object[0]));
            return 1;
        }))).then(ClientCommandManager.literal("edit").then(ClientCommandManager.argument("signature", FancyTextArgumentType.fancyText(StyleUtil.BASE_LORE_STYLE)).executes(context -> {
            class_2561 oldSignature = signature;
            try {
                signature = (class_2561)context.getArgument("signature", class_2561.class);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.sign.new.missing_arg", new Object[0])).create();
            }
            try {
                Files.write(SIGNATURE_FILE.toPath(), TextInst.toJsonString(signature).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                NBTEditor.LOGGER.error("Error while saving signature", (Throwable)e);
                throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.sign.save_error", new Object[0])).create();
            }
            ItemReference ref = ItemReference.getHeldItem();
            class_1799 item = ref.getItem();
            List<class_2561> lore = ItemTagReferences.LORE.get(item);
            if (SignatureCommand.hasSignature(lore, oldSignature)) {
                lore.set(lore.size() - 1, signature);
                ItemTagReferences.LORE.set(item, lore);
                ref.saveItem(item, TextInst.translatable("nbteditor.sign.edited", new Object[0]));
            }
            return 1;
        })));
    }

    private static boolean hasSignature(List<class_2561> lore, class_2561 signature) {
        if (lore.isEmpty()) {
            return false;
        }
        return lore.get(lore.size() - 1).getString().equals(signature.getString());
    }

    private static boolean hasSignature(List<class_2561> lore) {
        return SignatureCommand.hasSignature(lore, signature);
    }

    static {
        if (!SIGNATURE_FILE.exists()) {
            signature = TextInst.translatable("nbteditor.sign.default", new Object[0]);
        } else {
            try {
                signature = TextInst.fromJson(new String(Files.readAllBytes(SIGNATURE_FILE.toPath())));
            }
            catch (JsonParseException | IOException e) {
                NBTEditor.LOGGER.error("Error while loading signature", e);
                signature = TextInst.translatable("nbteditor.sign.load_error", new Object[0]);
            }
        }
    }
}

