/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.factories;

import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.arguments.FancyTextArgumentType;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.DisplayScreen;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.StyleUtil;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;

public class LoreCommand
extends ClientCommand {
    private static int getPos(int pos, List<class_2561> lore, boolean afterLast) throws CommandSyntaxException {
        if (pos < 0) {
            pos = pos + lore.size() + (afterLast ? 1 : 0);
        }
        if (pos < 0 || pos > lore.size() || !afterLast && pos == lore.size()) {
            throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.lore.invalid_line", new Object[0])).create();
        }
        return pos;
    }

    @Override
    public String getName() {
        return "lore";
    }

    @Override
    public String getExtremeAlias() {
        return "l";
    }

    @Override
    public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder, String path) {
        Command add = context -> {
            class_2561 line = (class_2561)context.getArgument("text", class_2561.class);
            int pos = -1;
            try {
                pos = (Integer)context.getArgument("line", Integer.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ItemReference ref = ItemReference.getHeldItem();
            class_1799 item = ref.getItem();
            List<class_2561> lore = ItemTagReferences.LORE.get(item);
            lore.add(LoreCommand.getPos(pos, lore, true), line);
            ItemTagReferences.LORE.set(item, lore);
            ref.saveItem(item, TextInst.translatable("nbteditor.lore.edited", new Object[0]));
            return 1;
        };
        Command remove = context -> {
            int pos = -1;
            try {
                pos = (Integer)context.getArgument("line", Integer.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ItemReference ref = ItemReference.getHeldItem();
            class_1799 item = ref.getItem();
            List<class_2561> lore = ItemTagReferences.LORE.get(item);
            lore.remove(LoreCommand.getPos(pos, lore, false));
            ItemTagReferences.LORE.set(item, lore);
            ref.saveItem(item, TextInst.translatable("nbteditor.lore.edited", new Object[0]));
            return 1;
        };
        Command set = context -> {
            class_2561 line = (class_2561)context.getArgument("text", class_2561.class);
            int pos = -1;
            try {
                pos = (Integer)context.getArgument("line", Integer.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ItemReference ref = ItemReference.getHeldItem();
            class_1799 item = ref.getItem();
            List<class_2561> lore = ItemTagReferences.LORE.get(item);
            lore.set(LoreCommand.getPos(pos, lore, false), line);
            ItemTagReferences.LORE.set(item, lore);
            ref.saveItem(item, TextInst.translatable("nbteditor.lore.edited", new Object[0]));
            return 1;
        };
        Command clear = context -> {
            ItemReference ref = ItemReference.getHeldItem();
            class_1799 item = ref.getItem();
            ItemTagReferences.LORE.set(item, new ArrayList());
            ref.saveItem(item, TextInst.translatable("nbteditor.lore.edited", new Object[0]));
            return 1;
        };
        Command list = context -> {
            ItemReference heldItem = ItemReference.getHeldItem(item -> true, TextInst.translatable("nbteditor.no_hand.no_item.to_view", new Object[0]));
            class_1799 item2 = heldItem.getItem();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.literal("[").formatted(class_124.field_1080).append(TextInst.literal("+").formatted(class_124.field_1060)).append(TextInst.literal("] ").formatted(class_124.field_1080)).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/factory display lore add ")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextInst.of("/factory display lore add")))).append(TextInst.literal("[").formatted(class_124.field_1080).append(TextInst.literal("Clear").formatted(class_124.field_1061)).append(TextInst.literal("] ").formatted(class_124.field_1080)).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/factory display lore clear")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextInst.of("/factory display lore clear"))))));
            List<class_2561> lore = ItemTagReferences.LORE.get(item2);
            int i = 0;
            for (class_2561 line : lore) {
                int finalI = i++;
                ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.literal("[").formatted(class_124.field_1080).append(TextInst.literal("-").formatted(class_124.field_1061)).append(TextInst.literal("]").formatted(class_124.field_1080)).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/factory display lore remove " + finalI)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextInst.of("/factory display lore remove " + finalI)))).append(TextInst.literal(" ").formatted(class_124.field_1064).formatted(class_124.field_1056).append(line).styled(style -> MixinLink.withRunClickEvent(style, () -> MainUtil.client.field_1755.method_25430(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11745, "/factory display lore set " + finalI + " " + FancyTextArgumentType.stringifyFancyText(line, StyleUtil.BASE_LORE_STYLE, true))))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextInst.of("/factory display lore set " + finalI))))));
            }
            if (lore.isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.translatable("nbteditor.lore.none", new Object[0]));
            }
            return 1;
        };
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal("add").then(ClientCommandManager.argument("line", IntegerArgumentType.integer()).then(ClientCommandManager.argument("text", FancyTextArgumentType.fancyText(StyleUtil.BASE_LORE_STYLE)).executes(add)))).then(ClientCommandManager.argument("text", FancyTextArgumentType.fancyText(StyleUtil.BASE_LORE_STYLE)).executes(add)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal("remove").then(ClientCommandManager.argument("line", IntegerArgumentType.integer()).executes(remove))).executes(remove))).then(((LiteralArgumentBuilder)ClientCommandManager.literal("set").then(ClientCommandManager.argument("line", IntegerArgumentType.integer()).then(ClientCommandManager.argument("text", FancyTextArgumentType.fancyText(StyleUtil.BASE_LORE_STYLE)).executes(set)))).then(ClientCommandManager.argument("text", FancyTextArgumentType.fancyText(StyleUtil.BASE_LORE_STYLE)).executes(set)))).then(ClientCommandManager.literal("clear").executes(clear))).then(ClientCommandManager.literal("list").executes(list))).executes(context -> {
            MainUtil.client.method_1507(new DisplayScreen<LocalItem>(ItemReference.getHeldItem()));
            return 1;
        });
    }
}

