/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.factories;

import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalBlock;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVComponentType;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.BlockReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReferenceFilter;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ContainerItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.BookScreen;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.WrittenBookTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.StyleUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class BookCommand
extends ClientCommand {
    public static final NBTReferenceFilter BOOK_FILTER = NBTReferenceFilter.create(ref -> ref.getItem().method_7909() == class_1802.field_8360, ref -> {
        if (ref.getBlock() != class_2246.field_16330) {
            return false;
        }
        LocalBlock nbt = ref.getLocalNBT();
        if (!ContainerIO.isContainer(nbt)) {
            return false;
        }
        class_1799[] contents = ContainerIO.read(nbt);
        return contents.length == 1 && contents[0].method_7909() == class_1802.field_8360;
    }, null, TextInst.translatable("nbteditor.no_ref.book", new Object[0]), TextInst.translatable("nbteditor.no_hand.no_item.book", new Object[0]));

    public static boolean convertBookToWritable(ItemReference ref) {
        class_1799 item = MainUtil.setType(class_1802.field_8674, ref.getItem(), 1);
        boolean formatted = false;
        List<class_2561> pages = WrittenBookTagReferences.PAGES.get(item);
        ArrayList<String> convertedPages = new ArrayList<String>();
        for (class_2561 page : pages) {
            if (!formatted && TextUtil.isTextFormatted(page, StyleUtil.BOOK_STYLE)) {
                formatted = true;
            }
            convertedPages.add(page.getString());
        }
        ItemTagReferences.WRITABLE_BOOK_PAGES.set(item, convertedPages);
        if (NBTManagers.COMPONENTS_EXIST) {
            item.remove(MVComponentType.WRITTEN_BOOK_CONTENT);
        }
        if (formatted) {
            MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.book.convert.formatting_saved", new Object[0]), false);
            MainUtil.get(item, true);
        } else {
            ref.saveItem(item, TextInst.translatable("nbteditor.book.convert.success", new Object[0]));
        }
        return !formatted;
    }

    @Override
    public String getName() {
        return "book";
    }

    @Override
    public String getExtremeAlias() {
        return "b";
    }

    @Override
    public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder, String path) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(ClientCommandManager.literal("make_writable").executes(context -> {
            this.getReference(BookCommand::convertBookToWritable);
            return 1;
        }))).then(ClientCommandManager.literal("new").executes(context -> {
            ItemReference ref = ItemReference.getHeldAir();
            class_1799 book = new class_1799((class_1935)class_1802.field_8360);
            WrittenBookTagReferences.TITLE.set(book, "");
            WrittenBookTagReferences.AUTHOR.set(book, "");
            WrittenBookTagReferences.GENERATION.set(book, 0);
            WrittenBookTagReferences.PAGES.set(book, new ArrayList());
            ref.saveItem(book);
            MainUtil.client.method_1507((class_437)new BookScreen(ref));
            return 1;
        }))).executes(context -> {
            this.getReference(ref -> MainUtil.client.method_1507((class_437)new BookScreen((ItemReference)ref)));
            return 1;
        });
    }

    private void getReference(Consumer<ItemReference> consumer) {
        NBTReference.getReference(BOOK_FILTER, false, ref -> {
            if (ref instanceof ItemReference) {
                ItemReference itemRef = (ItemReference)ref;
                consumer.accept(itemRef);
            } else if (ref instanceof BlockReference) {
                BlockReference blockRef = (BlockReference)ref;
                consumer.accept(new ContainerItemReference<LocalBlock>(blockRef, 0));
            }
        });
    }
}

