/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.arguments;

import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyText;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.StyleOption;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.StyleUtil;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public class FancyTextArgumentType
implements ArgumentType<class_2561> {
    private static final List<String> eventTypes = Stream.of(StyleOption.values()).map(action -> "[" + action.name().toLowerCase() + "]").toList();
    private final class_2583 base;

    public static FancyTextArgumentType fancyText(class_2583 base) {
        return new FancyTextArgumentType(base);
    }

    public static ArgumentType<UnparsedText> fancyText() {
        final FancyTextArgumentType defaultArgType = new FancyTextArgumentType(class_2583.field_24360);
        return new ArgumentType<UnparsedText>(){

            public UnparsedText parse(StringReader reader) throws CommandSyntaxException {
                String remaining = reader.getRemaining();
                reader.setCursor(reader.getTotalLength());
                return style -> new FancyTextArgumentType(style).parse(new StringReader(remaining));
            }

            public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
                return defaultArgType.listSuggestions(context, builder);
            }
        };
    }

    public static String stringifyFancyText(class_2561 text, class_2583 base, boolean printErrors) {
        if (ConfigScreen.isJsonText()) {
            return TextInst.toJsonString(text);
        }
        Map.Entry<String, Boolean> output = FancyText.stringify(text, base);
        if (output.getValue().booleanValue() && printErrors) {
            MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.fancy_text_arg_type.stringify_unsupported", new Object[0]), false);
        }
        return output.getKey();
    }

    private FancyTextArgumentType(class_2583 base) {
        this.base = base;
    }

    public class_2561 parse(StringReader reader) throws CommandSyntaxException {
        if (ConfigScreen.isJsonText()) {
            return MVMisc.getTextArg().method_9283(reader);
        }
        class_2561 output = FancyText.parse(reader.getRemaining(), this.base);
        reader.setCursor(reader.getTotalLength());
        return output;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        block8: {
            int lastCloseEvent;
            int lastEvent;
            block10: {
                String event;
                int lastIndex;
                block9: {
                    int lastCloseValue;
                    int lastValue;
                    block7: {
                        if (ConfigScreen.isJsonText()) {
                            return MVMisc.getTextArg().listSuggestions(context, builder);
                        }
                        if (builder.getRemaining().isEmpty()) {
                            return builder.buildFuture();
                        }
                        int lastColor = Math.max(builder.getRemaining().lastIndexOf(38), builder.getRemaining().lastIndexOf(167));
                        int lastShadowColor = builder.getRemaining().lastIndexOf(95);
                        lastEvent = builder.getRemaining().lastIndexOf(91);
                        lastCloseEvent = builder.getRemaining().lastIndexOf(93);
                        lastValue = builder.getRemaining().lastIndexOf(123);
                        lastCloseValue = builder.getRemaining().lastIndexOf(125);
                        lastIndex = builder.getRemaining().length() - 1;
                        if (lastColor != lastIndex && (!StyleUtil.SHADOW_COLOR_EXISTS || lastColor != lastShadowColor - 1 || lastShadowColor != lastIndex)) break block7;
                        builder = builder.createOffset(builder.getStart() + lastIndex + 1);
                        for (class_124 format : class_124.values()) {
                            builder.suggest("" + format.method_36145(), () -> format.method_537());
                        }
                        builder.suggest("#", (Message)TextInst.translatable("nbteditor.fancy_text_arg_type.custom_color", new Object[0]));
                        if (StyleUtil.SHADOW_COLOR_EXISTS && lastColor == lastIndex) {
                            builder.suggest("_", (Message)TextInst.translatable("nbteditor.fancy_text_arg_type.shadow_color", new Object[0]));
                        }
                        break block8;
                    }
                    if (lastCloseValue != lastIndex) break block9;
                    if (lastValue != -1) {
                        builder = builder.createOffset(builder.getStart() + lastCloseValue + 1);
                        builder.suggest("(");
                    }
                    break block8;
                }
                if (lastCloseEvent != lastIndex) break block10;
                if (lastEvent == -1 || !eventTypes.contains(event = builder.getRemaining().substring(lastEvent, lastCloseEvent + 1))) break block8;
                builder = builder.createOffset(builder.getStart() + lastCloseEvent + 1);
                builder.suggest("{");
                if (!event.equals("[show_item]") && !event.equals("[show_entity]")) break block8;
                builder.suggest("(");
                break block8;
            }
            if (lastEvent > lastCloseEvent) {
                builder = builder.createOffset(builder.getStart() + lastEvent);
                String event = builder.getRemaining();
                for (String suggestEvent : eventTypes) {
                    if (!suggestEvent.startsWith(event)) continue;
                    builder.suggest(suggestEvent);
                }
            }
        }
        return builder.buildFuture();
    }

    public static interface UnparsedText {
        public class_2561 parse(class_2583 var1) throws CommandSyntaxException;
    }
}

