/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;

public class EnumArgumentType<T extends Enum<T>>
implements ArgumentType<T> {
    private static final Collection<String> EXAMPLES = Arrays.asList("option1", "option2");
    private final Class<T> options;

    public static <T extends Enum<T>> EnumArgumentType<T> options(Class<T> options) {
        return new EnumArgumentType<T>(options);
    }

    private EnumArgumentType(Class<T> options) {
        this.options = options;
    }

    public T parse(StringReader stringReader) throws CommandSyntaxException {
        StringBuilder value = new StringBuilder();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            value.append(stringReader.read());
        }
        return (T)Arrays.stream((Enum[])this.options.getEnumConstants()).filter(option -> option.name().equalsIgnoreCase(value.toString())).findFirst().orElseThrow(() -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)stringReader));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(Arrays.stream((Enum[])this.options.getEnumConstants()).map(Enum::name).map(String::toLowerCase), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

