/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands;

import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientChestCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.OpenCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.factories.FactoryCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.get.GetCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.nbt.NBTCommand;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CommandHandler {
    public static final Map<String, ClientCommand> COMMANDS = Stream.of(NBTCommand.INSTANCE, ClientChestCommand.INSTANCE, OpenCommand.INSTANCE, GetCommand.INSTANCE, FactoryCommand.INSTANCE).collect(Collectors.toUnmodifiableMap(ClientCommand::getName, cmd -> cmd));

    public static void registerCommands() {
        MVMisc.registerCommands(dispatcher -> {
            for (ClientCommand cmd : COMMANDS.values()) {
                cmd.registerAll(arg_0 -> ((CommandDispatcher)dispatcher).register(arg_0), cmd.getName());
            }
            for (String shortcut : ConfigScreen.getShortcuts()) {
                ClientCommand cmd;
                List<String> path = Arrays.asList(shortcut.split(" "));
                if (path.size() <= 1 || (cmd = COMMANDS.get(path.get(0))) == null || (cmd = cmd.getShortcut(path, 1)) == null) continue;
                LiteralArgumentBuilder<FabricClientCommandSource> builder = ClientCommandManager.literal(path.get(path.size() - 1));
                cmd.register(builder, shortcut);
                dispatcher.register(builder);
            }
        });
    }
}

