/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands;

import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;

public abstract class ClientCommandGroup
extends ClientCommand {
    private final List<ClientCommand> children;

    public ClientCommandGroup(List<ClientCommand> children) {
        this.children = children;
    }

    public final List<ClientCommand> getChildren() {
        return this.children;
    }

    @Override
    public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder, String path) {
        for (ClientCommand child : this.children) {
            child.registerAll(arg_0 -> builder.then(arg_0), path + " " + child.getName());
        }
    }

    @Override
    public ClientCommand getShortcut(List<String> path, int index) {
        ClientCommand output = super.getShortcut(path, index);
        if (output != null || !this.allowShortcuts()) {
            return output;
        }
        if (path.size() > index) {
            String next = path.get(index);
            return this.children.stream().filter(cmd -> cmd.getName().equals(next)).findFirst().map(cmd -> cmd.getShortcut(path, index + 1)).orElse(null);
        }
        return null;
    }

    public boolean allowShortcuts() {
        return false;
    }
}

