/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

public abstract class ClientCommand {
    public static <T> T getDefaultArg(CommandContext<FabricClientCommandSource> context, String name, T defaultValue, Class<T> type) {
        try {
            return (T)context.getArgument(name, type);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public void registerAll(Consumer<LiteralArgumentBuilder<FabricClientCommandSource>> commandHandler, String path) {
        LiteralArgumentBuilder<FabricClientCommandSource> builder = ClientCommandManager.literal(this.getName());
        this.register(builder, path);
        commandHandler.accept(builder);
        HashSet<String> aliases = new HashSet<String>();
        for (ConfigScreen.Alias alias : ConfigScreen.getAliases()) {
            if (!alias.original().equals(path)) continue;
            aliases.add(alias.alias());
        }
        for (String string : aliases) {
            builder = ClientCommandManager.literal(string);
            this.register(builder, path);
            commandHandler.accept(builder);
        }
    }

    public abstract String getName();

    public abstract String getExtremeAlias();

    public abstract void register(LiteralArgumentBuilder<FabricClientCommandSource> var1, String var2);

    public ClientCommand getShortcut(List<String> path, int index) {
        if (path.size() == index) {
            return this;
        }
        return null;
    }
}

