/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.clientchest;

import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestPage;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestPageCache;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;

public class SmallClientChestPageCache
implements ClientChestPageCache {
    private final int maxPages;
    private final HashMap<Integer, ClientChestPage> pages;
    private final SortedSet<Integer> nonEmptyPages;

    public SmallClientChestPageCache(int maxPages) {
        this.maxPages = maxPages;
        this.pages = new HashMap();
        this.nonEmptyPages = new TreeSet<Integer>();
    }

    @Override
    public int getPageCount() {
        return this.maxPages;
    }

    @Override
    public int getDefaultLoadedPagesCount() {
        return this.maxPages;
    }

    @Override
    public ClientChestPage getCachedPage(int page) {
        return this.pages.computeIfAbsent(page, key -> ClientChestPage.unloaded());
    }

    @Override
    public void cachePage(int page, ClientChestPage pageData) {
        this.pages.put(page, pageData);
        this.nonEmptyPages.add(page);
    }

    @Override
    public void cacheEmptyPage(int page) {
        this.pages.put(page, new ClientChestPage());
        this.nonEmptyPages.remove(page);
    }

    @Override
    public void discardPageCache(int page) {
        this.pages.remove(page);
        this.nonEmptyPages.remove(page);
    }

    @Override
    public int[] getNearestItems(int page) {
        SortedSet<Integer> prevSet = this.nonEmptyPages.headSet(page);
        SortedSet<Integer> nextSet = this.nonEmptyPages.tailSet(page + 1);
        int prev = prevSet.isEmpty() ? -1 : prevSet.last();
        int next = nextSet.isEmpty() ? -1 : nextSet.first();
        return new int[]{prev, next};
    }

    @Override
    public void transferTo(ClientChestPageCache cache) {
        int maxPages = cache.getPageCount();
        this.pages.forEach((page, pageData) -> {
            if (page >= maxPages) {
                return;
            }
            if (this.nonEmptyPages.contains(page)) {
                cache.cachePage((int)page, (ClientChestPage)pageData);
            } else {
                cache.cacheEmptyPage((int)page);
            }
        });
    }
}

