/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.clientchest;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChest;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestPage;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestPageCache;
import java.io.File;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1799;

public class LargeClientChestPageCache
implements ClientChestPageCache {
    private final int importantPages;
    private final Cache<Integer, ClientChestPage> pages;

    public LargeClientChestPageCache(int importantPages) {
        this.importantPages = importantPages;
        this.pages = CacheBuilder.newBuilder().softValues().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    }

    @Override
    public int getPageCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDefaultLoadedPagesCount() {
        return this.importantPages;
    }

    @Override
    public ClientChestPage getCachedPage(int page) {
        ClientChestPage output = (ClientChestPage)this.pages.getIfPresent((Object)page);
        if (output == null) {
            output = ClientChestPage.unloaded();
            this.pages.put((Object)page, (Object)output);
        }
        return output;
    }

    @Override
    public void cachePage(int page, ClientChestPage pageData) {
        this.pages.put((Object)page, (Object)pageData);
    }

    @Override
    public void cacheEmptyPage(int page) {
        this.pages.put((Object)page, (Object)new ClientChestPage());
    }

    @Override
    public void discardPageCache(int page) {
        this.pages.invalidate((Object)page);
    }

    @Override
    public int[] getNearestItems(int page) {
        if (!ClientChest.CLIENT_CHEST_FOLDER.exists()) {
            return new int[]{-1, -1};
        }
        int prev = -1;
        int next = -1;
        for (File file : ClientChest.CLIENT_CHEST_FOLDER.listFiles()) {
            if (!file.getName().matches("page[0-9]+\\.nbt")) continue;
            int i = Integer.parseInt(file.getName().substring("page".length(), file.getName().indexOf(46)));
            if (i < page && i > prev) {
                prev = i;
            }
            if (i <= page || i >= next && next != -1) continue;
            next = i;
        }
        return new int[]{prev, next};
    }

    @Override
    public void transferTo(ClientChestPageCache cache) {
        int maxPages = cache.getPageCount();
        this.pages.asMap().forEach((page, pageData) -> {
            boolean empty;
            if (page >= maxPages) {
                return;
            }
            boolean bl = empty = pageData.isInThisVersion() && pageData.dynamicItems().getSlots().isEmpty();
            if (empty) {
                for (class_1799 item : pageData.items()) {
                    if (item == null || item.method_7960()) continue;
                    empty = false;
                    break;
                }
            }
            if (empty) {
                cache.cacheEmptyPage((int)page);
            } else {
                cache.cachePage((int)page, (ClientChestPage)pageData);
            }
        });
    }
}

