/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.clientchest;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.Attempt;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class DynamicItems {
    private final Map<Integer, Map.Entry<class_2487, Boolean>> items;

    public DynamicItems() {
        this.items = new HashMap<Integer, Map.Entry<class_2487, Boolean>>();
    }

    private DynamicItems(Map<Integer, Map.Entry<class_2487, Boolean>> items) {
        this.items = items;
    }

    public void add(int slot, class_2487 nbt, boolean successfullyLoaded) {
        this.items.put(slot, Map.entry(nbt, successfullyLoaded));
    }

    public class_1799 tryAdd(int slot, class_1799 item) {
        if (!NBTManagers.COMPONENTS_EXIST) {
            return item;
        }
        if (item.method_7960()) {
            return class_1799.field_8037;
        }
        class_2487 nbt = NBTManagers.ITEM.serialize(item, true);
        Attempt defaultRegistryItem = MVMisc.withDefaultRegistryManager(() -> NBTManagers.ITEM.tryDeserialize(nbt));
        if (defaultRegistryItem.isSuccessful()) {
            return (class_1799)defaultRegistryItem.getSuccessOrThrow();
        }
        this.add(slot, nbt, true);
        return item;
    }

    public void remove(int slot) {
        this.items.remove(slot);
    }

    public class_1799 tryLoad(int slot) {
        Map.Entry<class_2487, Boolean> item = this.items.get(slot);
        if (item == null) {
            throw new IllegalArgumentException("Not a dynamic slot: " + slot);
        }
        class_2487 nbt = item.getKey();
        Attempt<class_1799> attempt = NBTManagers.ITEM.tryDeserialize(nbt);
        this.items.put(slot, Map.entry(nbt, attempt.isSuccessful()));
        return attempt.value().orElse(class_1799.field_8037);
    }

    public void unloadAll() {
        this.items.replaceAll((slot, entry) -> Map.entry((class_2487)entry.getKey(), false));
    }

    public List<Integer> getSlots() {
        return this.items.keySet().stream().toList();
    }

    public boolean isSlot(int slot) {
        return this.items.containsKey(slot);
    }

    public List<Integer> getLockedSlots() {
        return this.items.entrySet().stream().filter(entry -> (Boolean)((Map.Entry)entry.getValue()).getValue() == false).map(Map.Entry::getKey).toList();
    }

    public boolean isSlotLocked(int slot) {
        Map.Entry<class_2487, Boolean> item = this.items.get(slot);
        return item != null && item.getValue() == false;
    }

    public class_2487 getOriginalNbt(int slot) {
        Map.Entry<class_2487, Boolean> item = this.items.get(slot);
        return item == null ? null : item.getKey();
    }

    public DynamicItems copy() {
        return new DynamicItems(new HashMap<Integer, Map.Entry<class_2487, Boolean>>(this.items));
    }
}

