/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.clientchest;

import com.luneruniverse.minecraft.mod.nbteditor.clientchest.DynamicItems;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.PageLoadLevel;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.DataVersionStatus;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import java.util.Optional;
import net.minecraft.class_1799;

public record ClientChestPage(Optional<Integer> dataVersion, class_1799[] items, DynamicItems dynamicItems, PageLoadLevel loadLevel) {
    public ClientChestPage {
        if (items != null && items.length != 54) {
            throw new IllegalArgumentException("The number of items must be exactly 54");
        }
    }

    public ClientChestPage(class_1799[] items, DynamicItems dynamicItems, PageLoadLevel loadLevel) {
        this(Optional.of(Version.getDataVersion()), items, dynamicItems, loadLevel);
    }

    public ClientChestPage() {
        this(new class_1799[54], new DynamicItems(), PageLoadLevel.DYNAMIC_ITEMS);
    }

    public static ClientChestPage unloaded() {
        return new ClientChestPage(Optional.empty(), null, null, PageLoadLevel.UNLOADED);
    }

    public static ClientChestPage unknownDataVersion() {
        return new ClientChestPage(Optional.empty(), null, null, PageLoadLevel.DYNAMIC_ITEMS);
    }

    public static ClientChestPage wrongDataVersion(int dataVersion) {
        return new ClientChestPage(Optional.of(dataVersion), null, null, PageLoadLevel.DYNAMIC_ITEMS);
    }

    public boolean isInThisVersion() {
        return this.dataVersion.map(value -> value == Version.getDataVersion()).orElse(false);
    }

    public DataVersionStatus getDataVersionStatus() {
        return DataVersionStatus.of(this.dataVersion);
    }

    public class_1799[] getItemsOrThrow() {
        if (this.isInThisVersion()) {
            return this.items;
        }
        throw new IllegalStateException("Cannot get the items of a page in a different DataVersion!");
    }
}

