/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.clientchest;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestPage;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.DynamicItems;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.PageLoadLevel;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class ClientChestHelper {
    private static void trySend(String key) {
        if (MainUtil.client.field_1724 != null) {
            MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable(key, new Object[0]), false);
        }
    }

    public static boolean setNameOfPage(int page, String name) {
        try {
            NBTEditorClient.CLIENT_CHEST.setNameOfPage(page, name);
            return true;
        }
        catch (Exception e) {
            NBTEditor.LOGGER.error("Error saving the client chest!", (Throwable)e);
            ClientChestHelper.trySend("nbteditor.client_chest.save_error");
            return false;
        }
    }

    public static CompletableFuture<Boolean> loadDefaultPages(PageLoadLevel loadLevel) {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.loadDefaultPages(loadLevel).thenApply(v -> true)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.load_error");
                return false;
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error loading the client chest!", (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.load_error");
            return CompletableFuture.completedFuture(false);
        }
    }

    public static CompletableFuture<Optional<ClientChestPage>> getPage(int page, PageLoadLevel loadLevel) {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.getPage(page, loadLevel).thenApply(Optional::of)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.load_error");
                return Optional.empty();
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error loading client chest page " + (page + 1), (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.load_error");
            return CompletableFuture.completedFuture(Optional.empty());
        }
    }

    public static CompletableFuture<Boolean> setPage(int page, class_1799[] items, DynamicItems prevDynamicItems) {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.setPage(page, items, prevDynamicItems).thenApply(v -> true)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.save_error");
                return false;
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error saving client chest page " + (page + 1), (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.save_error");
            return CompletableFuture.completedFuture(false);
        }
    }

    public static CompletableFuture<Boolean> unloadAllPages(PageLoadLevel loadLevel) {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.unloadAllPages(loadLevel).thenApply(v -> true)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.unload_error");
                return false;
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error unloading the client chest!", (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.unload_error");
            return CompletableFuture.completedFuture(false);
        }
    }

    public static CompletableFuture<Optional<ClientChestPage>> unloadPage(int page, PageLoadLevel loadLevel) {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.unloadPage(page, loadLevel).thenApply(Optional::of)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.unload_error");
                return Optional.empty();
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error unloading client chest page " + (page + 1), (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.unload_error");
            return CompletableFuture.completedFuture(Optional.empty());
        }
    }

    public static CompletableFuture<Optional<ClientChestPage>> reloadPage(int page) {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.reloadPage(page).thenApply(Optional::of)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.load_error");
                return Optional.empty();
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error reloading client chest page " + (page + 1), (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.load_error");
            return CompletableFuture.completedFuture(Optional.empty());
        }
    }

    public static CompletableFuture<Boolean> importAllPages() {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.importAllPages().thenApply(v -> true)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.import_error");
                return false;
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error importing the client chest!", (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.import_error");
            return CompletableFuture.completedFuture(false);
        }
    }

    public static CompletableFuture<Boolean> importPage(int page) {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.importPage(page).thenApply(v -> true)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.import_error");
                return false;
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error importing client chest page " + (page + 1), (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.import_error");
            return CompletableFuture.completedFuture(false);
        }
    }

    public static CompletableFuture<Boolean> updateAllPages(Optional<Integer> defaultDataVersion) {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.updateAllPages(defaultDataVersion).thenApply(v -> true)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.update_error");
                return false;
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error updating the client chest!", (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.update_error");
            return CompletableFuture.completedFuture(false);
        }
    }

    public static CompletableFuture<Boolean> updatePage(int page, Optional<Integer> defaultDataVersion) {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.updatePage(page, defaultDataVersion).thenApply(v -> true)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.update_error");
                return false;
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error updating client chest page " + (page + 1), (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.update_error");
            return CompletableFuture.completedFuture(false);
        }
    }

    public static CompletableFuture<Boolean> discardPage(int page) {
        try {
            return ((CompletableFuture)NBTEditorClient.CLIENT_CHEST.discardPage(page).thenApply(v -> true)).exceptionally(e -> {
                ClientChestHelper.trySend("nbteditor.client_chest.save_error");
                return false;
            });
        }
        catch (RuntimeException e2) {
            NBTEditor.LOGGER.error("Error discarding client chest page " + (page + 1), (Throwable)e2);
            ClientChestHelper.trySend("nbteditor.client_chest.save_error");
            return CompletableFuture.completedFuture(false);
        }
    }
}

