/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.clientchest;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestPage;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestPageCache;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.DynamicItems;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.PageLoadLevel;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.DataVersionStatus;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.util.LoadQueue;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.PartitionedLock;
import com.luneruniverse.minecraft.mod.nbteditor.util.SaveQueue;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1208;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;

public class ClientChest {
    public static final File CLIENT_CHEST_FOLDER = new File(NBTEditorClient.SETTINGS_FOLDER, "client_chest");
    private static final File PAGE_NAMES = new File(CLIENT_CHEST_FOLDER, "page_names.json");
    private volatile ClientChestPageCache cache;
    private final Queue<Integer> cachePageCounts;
    private final Map<String, Integer> nameToPage;
    private final Map<Integer, String> pageToName;
    private final PartitionedLock lock;
    private final LoadingCache<Integer, LoadQueue<ClientChestPage>> loadQueues;
    private final LoadingCache<Integer, SaveQueue<ClientChestPage>> saveQueues;
    private final Map<Integer, Integer> uncachedProcessers;

    public ClientChest(ClientChestPageCache cache) {
        this.cache = cache;
        this.cachePageCounts = new ConcurrentLinkedQueue<Integer>();
        if (PAGE_NAMES.exists()) {
            try (FileReader reader = new FileReader(PAGE_NAMES, Charset.forName("UTF-8"));){
                this.nameToPage = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, Integer>>(){}.getType());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read page names!", e);
            }
            this.pageToName = new HashMap<Integer, String>();
            this.nameToPage.forEach((name, page) -> this.pageToName.put((Integer)page, (String)name));
        } else {
            this.nameToPage = new HashMap<String, Integer>();
            this.pageToName = new HashMap<Integer, String>();
        }
        this.lock = new PartitionedLock();
        this.loadQueues = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Integer, LoadQueue<ClientChestPage>>(){

            public LoadQueue<ClientChestPage> load(Integer page) {
                return new LoadQueue<ClientChestPage>("ClientChest/Loading", level -> {
                    ClientChest.this.lock.lock(page);
                    try {
                        ClientChestPage clientChestPage = ClientChest.this.readPageSync(page, PageLoadLevel.values()[level]);
                        return clientChestPage;
                    }
                    catch (Throwable e) {
                        NBTEditor.LOGGER.error("Error loading client chest page " + (page + 1), e);
                        if (e instanceof Error) {
                            Error error = (Error)e;
                            throw error;
                        }
                        ClientChest.this.backupCorruptPage(page);
                        ClientChest.this.cache.cacheEmptyPage(page);
                        ClientChestPage clientChestPage = new ClientChestPage();
                        return clientChestPage;
                    }
                    finally {
                        ClientChest.this.lock.unlock(page);
                    }
                }, true);
            }
        });
        this.saveQueues = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Integer, SaveQueue<ClientChestPage>>(){

            public SaveQueue<ClientChestPage> load(Integer page) {
                return new SaveQueue<ClientChestPage>("ClientChest/Saving", pageData -> {
                    ClientChest.this.lock.lock(page);
                    try {
                        ClientChest.this.writePageSync(page, (ClientChestPage)pageData);
                    }
                    catch (Throwable e) {
                        NBTEditor.LOGGER.error("Error saving client chest page " + (page + 1), e);
                        if (e instanceof Error) {
                            Error error = (Error)e;
                            throw error;
                        }
                        throw new RuntimeException("Error saving client chest page " + (page + 1), e);
                    }
                    finally {
                        ClientChest.this.lock.unlock(page);
                    }
                }, true);
            }
        });
        this.uncachedProcessers = new ConcurrentHashMap<Integer, Integer>();
    }

    public CompletableFuture<Void> setCache(ClientChestPageCache cache) {
        this.cachePageCounts.add(cache.getPageCount());
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            this.lock.lockAll();
            try {
                this.cache.transferTo(cache);
                this.cache = cache;
                this.cachePageCounts.remove();
                future.complete(null);
            }
            finally {
                this.lock.unlockAll();
            }
        }, "NBTEditor/Async/ClientChest/SwitchingCache");
        thread.start();
        return future;
    }

    public ClientChestPageCache getCache() {
        return this.cache;
    }

    public int getPageCount() {
        return Math.min(this.cache.getPageCount(), this.cachePageCounts.stream().mapToInt(pageCount -> pageCount).min().orElse(Integer.MAX_VALUE));
    }

    public Integer getPageFromName(String name) {
        return this.nameToPage.get(name);
    }

    public String getNameFromPage(int page) {
        return this.pageToName.getOrDefault(page, "");
    }

    public List<String> getAllPageNames(boolean withinPageCount) {
        if (!withinPageCount) {
            return new ArrayList<String>(this.nameToPage.keySet());
        }
        return this.nameToPage.entrySet().stream().filter(entry -> (Integer)entry.getValue() < this.getPageCount()).map(Map.Entry::getKey).toList();
    }

    public boolean isNameUsedByOther(String name, int page) {
        return this.nameToPage.getOrDefault(name, page) != page;
    }

    public void setNameOfPage(int page, String name) throws Exception {
        if (Objects.equals(this.pageToName.get(page), name != null && name.isEmpty() ? null : name)) {
            return;
        }
        if (name == null || name.isEmpty()) {
            this.nameToPage.remove(this.pageToName.remove(page));
        } else {
            this.nameToPage.remove(this.pageToName.get(page));
            Integer oldPage = this.nameToPage.put(name, page);
            if (oldPage != null && oldPage != page) {
                this.pageToName.remove(oldPage);
            }
            this.pageToName.put(page, name);
        }
        if (!CLIENT_CHEST_FOLDER.exists()) {
            CLIENT_CHEST_FOLDER.mkdir();
        }
        try (FileWriter writer = new FileWriter(PAGE_NAMES, Charset.forName("UTF-8"));){
            new Gson().toJson(this.nameToPage, new TypeToken<Map<Integer, String>>(){}.getType(), (Appendable)writer);
        }
    }

    public void stop() {
        this.lock.stop();
    }

    public boolean isProcessingPage(int page) {
        if (this.lock.isLocked(page) || this.isUncachedProcessingPage(page)) {
            return true;
        }
        LoadQueue loadQueue = (LoadQueue)this.loadQueues.getIfPresent((Object)page);
        if (loadQueue != null && loadQueue.isLoading()) {
            return true;
        }
        SaveQueue saveQueue = (SaveQueue)this.saveQueues.getIfPresent((Object)page);
        return saveQueue != null && saveQueue.isSaving();
    }

    public boolean isUncachedProcessingPage(int page) {
        return this.uncachedProcessers.getOrDefault(page, 0) > 0 || this.uncachedProcessers.getOrDefault(-1, 0) > 0;
    }

    public CompletableFuture<Void> loadDefaultPages(PageLoadLevel level) {
        if (level == PageLoadLevel.UNLOADED) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            this.lock.lockAll();
            try {
                Exception toThrow = new Exception("Error loading page(s)");
                for (int i = 0; i < this.cache.getDefaultLoadedPagesCount(); ++i) {
                    try {
                        this.readPageSync(i, level);
                        continue;
                    }
                    catch (Throwable e) {
                        toThrow.addSuppressed(new Exception("Page " + (i + 1), e));
                        if (e instanceof Error) continue;
                        this.backupCorruptPage(i);
                        this.cache.cacheEmptyPage(i);
                    }
                }
                if (toThrow.getSuppressed().length > 0) {
                    NBTEditor.LOGGER.error("Error loading the client chest!", (Throwable)toThrow);
                    future.completeExceptionally(toThrow);
                } else {
                    future.complete(null);
                }
            }
            finally {
                this.lock.unlockAll();
            }
        }, "NBTEditor/Async/ClientChest/Loading");
        thread.setDaemon(true);
        thread.start();
        return future;
    }

    public PageLoadLevel getLoadLevel(int page) {
        return this.cache.getCachedPage(page).loadLevel();
    }

    public CompletableFuture<ClientChestPage> getPage(int page, PageLoadLevel loadLevel) {
        if (!this.isUncachedProcessingPage(page)) {
            ClientChestPage cachedPage = this.cache.getCachedPage(page);
            if (loadLevel.ordinal() <= cachedPage.loadLevel().ordinal()) {
                return CompletableFuture.completedFuture(cachedPage);
            }
        }
        return ((LoadQueue)this.loadQueues.getUnchecked((Object)page)).load(loadLevel.ordinal());
    }

    public CompletableFuture<Void> setPage(int page, class_1799[] items, DynamicItems prevDynamicItems) {
        Optional<DataVersionStatus> dataVersionStatus = this.getDataVersionStatus(page);
        if (dataVersionStatus.isEmpty()) {
            try {
                dataVersionStatus = Optional.of(this.readDataVersionStatusSync(page));
            }
            catch (Exception e) {
                NBTEditor.LOGGER.error("Error saving client chest page " + (page + 1), (Throwable)e);
                return CompletableFuture.failedFuture(e);
            }
        }
        if (dataVersionStatus.get() != DataVersionStatus.CURRENT) {
            throw new IllegalStateException("Cannot write to a page which has a different DataVersion!");
        }
        boolean allAir = prevDynamicItems.getLockedSlots().isEmpty();
        if (allAir) {
            for (class_1799 item : items) {
                if (item == null || item.method_7960()) continue;
                allAir = false;
                break;
            }
        }
        if (allAir) {
            this.cache.cacheEmptyPage(page);
            try {
                Files.deleteIfExists(this.getFile(page).toPath());
            }
            catch (Exception e) {
                NBTEditor.LOGGER.error("Error saving client chest page " + (page + 1), (Throwable)e);
                return CompletableFuture.failedFuture(e);
            }
            return CompletableFuture.completedFuture(null);
        }
        DynamicItems dynamicItems = new DynamicItems();
        for (int i = 0; i < items.length; ++i) {
            if (prevDynamicItems.isSlotLocked(i)) {
                dynamicItems.add(i, prevDynamicItems.getOriginalNbt(i), false);
                continue;
            }
            if (items[i] == null) continue;
            items[i] = dynamicItems.tryAdd(i, items[i]);
        }
        ClientChestPage pageData = new ClientChestPage(items, dynamicItems, PageLoadLevel.DYNAMIC_ITEMS);
        this.cache.cachePage(page, pageData);
        return ((SaveQueue)this.saveQueues.getUnchecked((Object)page)).save(pageData);
    }

    public CompletableFuture<Void> unloadAllPages(PageLoadLevel loadLevel) {
        if (!CLIENT_CHEST_FOLDER.exists() || loadLevel == PageLoadLevel.DYNAMIC_ITEMS) {
            return CompletableFuture.completedFuture(null);
        }
        this.startUncachedProcessingAll();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            this.lock.lockAll();
            try {
                Exception toThrow = new Exception("Error unloading page(s)");
                for (File file : CLIENT_CHEST_FOLDER.listFiles()) {
                    int page;
                    if (!file.getName().matches("page[0-9]+\\.nbt") || (page = Integer.parseInt(file.getName().substring("page".length(), file.getName().indexOf(46)))) >= this.cache.getPageCount() || !this.getDataVersionStatus(page).map(status -> status == DataVersionStatus.CURRENT).orElse(false).booleanValue()) continue;
                    try {
                        this.unloadPageSync(page, loadLevel);
                    }
                    catch (Throwable e) {
                        toThrow.addSuppressed(new Exception("Page " + (page + 1), e));
                    }
                }
                if (toThrow.getSuppressed().length > 0) {
                    NBTEditor.LOGGER.error("Error unloading the client chest!", (Throwable)toThrow);
                    future.completeExceptionally(toThrow);
                } else {
                    future.complete(null);
                }
            }
            finally {
                this.lock.unlockAll();
                this.finishUncachedProcessingAll();
            }
        }, "NBTEditor/Async/ClientChest/Unloading");
        thread.start();
        return future;
    }

    public CompletableFuture<ClientChestPage> unloadPage(int page, PageLoadLevel loadLevel) {
        ClientChestPage cachedPage;
        if (!(this.isUncachedProcessingPage(page) || (cachedPage = this.cache.getCachedPage(page)).loadLevel().ordinal() > loadLevel.ordinal() && cachedPage.isInThisVersion())) {
            return CompletableFuture.completedFuture(cachedPage);
        }
        this.startUncachedProcessing(page);
        CompletableFuture<ClientChestPage> future = new CompletableFuture<ClientChestPage>();
        Thread thread = new Thread(() -> {
            this.lock.lock(page);
            try {
                future.complete(this.unloadPageSync(page, loadLevel));
            }
            catch (Throwable e) {
                NBTEditor.LOGGER.error("Error unloading client chest page " + (page + 1), e);
                future.completeExceptionally(e);
            }
            finally {
                this.lock.unlock(page);
                this.finishUncachedProcessing(page);
            }
        }, "NBTEditor/Async/ClientChest/Unloading/" + page);
        thread.start();
        return future;
    }

    public CompletableFuture<ClientChestPage> reloadPage(int page) {
        PageLoadLevel loadLevel = this.getLoadLevel(page);
        this.cache.discardPageCache(page);
        return this.getPage(page, loadLevel);
    }

    public CompletableFuture<Void> importAllPages() {
        if (!CLIENT_CHEST_FOLDER.exists()) {
            return CompletableFuture.completedFuture(null);
        }
        this.startUncachedProcessingAll();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            this.lock.lockAll();
            try {
                Exception toThrow = new Exception("Error importing page(s)");
                for (File file : CLIENT_CHEST_FOLDER.listFiles()) {
                    int page;
                    if (!file.getName().matches("page[0-9]+\\.nbt") || (page = Integer.parseInt(file.getName().substring("page".length(), file.getName().indexOf(46)))) >= this.cache.getPageCount() || !this.getDataVersionStatus(page).map(status -> status == DataVersionStatus.UNKNOWN).orElse(true).booleanValue()) continue;
                    try {
                        this.importPageSync(page, true);
                    }
                    catch (Throwable e) {
                        toThrow.addSuppressed(new Exception("Page " + (page + 1), e));
                    }
                }
                if (toThrow.getSuppressed().length > 0) {
                    NBTEditor.LOGGER.error("Error importing the client chest!", (Throwable)toThrow);
                    future.completeExceptionally(toThrow);
                } else {
                    future.complete(null);
                }
            }
            finally {
                this.lock.unlockAll();
                this.finishUncachedProcessingAll();
            }
        }, "NBTEditor/Async/ClientChest/Importing");
        thread.start();
        return future;
    }

    public CompletableFuture<Void> importPage(int page) {
        File file = this.getFile(page);
        if (!file.exists()) {
            throw new IllegalStateException("Cannot import an up to date page!");
        }
        if (this.getDataVersionStatus(page).map(status -> status != DataVersionStatus.UNKNOWN).orElse(false).booleanValue()) {
            throw new IllegalStateException("Cannot import a page with a DataVersion tag!");
        }
        this.startUncachedProcessing(page);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            this.lock.lock(page);
            try {
                this.importPageSync(page, false);
                future.complete(null);
            }
            catch (Throwable e) {
                NBTEditor.LOGGER.error("Error importing client chest page " + (page + 1), e);
                future.completeExceptionally(e);
            }
            finally {
                this.lock.unlock(page);
                this.finishUncachedProcessing(page);
            }
        }, "NBTEditor/Async/ClientChest/Importing/" + page);
        thread.start();
        return future;
    }

    public CompletableFuture<Void> updateAllPages(Optional<Integer> defaultDataVersion) {
        if (!CLIENT_CHEST_FOLDER.exists()) {
            return CompletableFuture.completedFuture(null);
        }
        this.startUncachedProcessingAll();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            this.lock.lockAll();
            try {
                Exception toThrow = new Exception("Error updating page(s)");
                for (File file : CLIENT_CHEST_FOLDER.listFiles()) {
                    int page;
                    if (!file.getName().matches("page[0-9]+\\.nbt") || (page = Integer.parseInt(file.getName().substring("page".length(), file.getName().indexOf(46)))) >= this.cache.getPageCount() || !this.getDataVersionStatus(page).map(status -> status.canBeUpdated(defaultDataVersion.isPresent())).orElse(true).booleanValue()) continue;
                    try {
                        boolean unloaded;
                        boolean bl = unloaded = this.getLoadLevel(page) == PageLoadLevel.UNLOADED;
                        if (this.updatePageSync(page, defaultDataVersion, true) == null || !unloaded) continue;
                        this.cache.discardPageCache(page);
                    }
                    catch (Throwable e) {
                        toThrow.addSuppressed(new Exception("Page " + (page + 1), e));
                    }
                }
                if (toThrow.getSuppressed().length > 0) {
                    NBTEditor.LOGGER.error("Error updating the client chest!", (Throwable)toThrow);
                    future.completeExceptionally(toThrow);
                } else {
                    future.complete(null);
                }
            }
            finally {
                this.lock.unlockAll();
                this.finishUncachedProcessingAll();
            }
        }, "NBTEditor/Async/ClientChest/Updating");
        thread.start();
        return future;
    }

    public CompletableFuture<ClientChestPage> updatePage(int page, Optional<Integer> defaultDataVersion) {
        File file = new File(CLIENT_CHEST_FOLDER, "page" + page + ".nbt");
        if (!file.exists()) {
            throw new IllegalStateException("Cannot update an already up to date page!");
        }
        this.getDataVersion(page).ifPresent(fileDataVersion -> {
            int dataVersion = (Integer)fileDataVersion.or(() -> defaultDataVersion).orElseThrow(() -> new IllegalStateException("Missing DataVersion tag and default DataVersion!"));
            if (dataVersion == Version.getDataVersion()) {
                throw new IllegalStateException("Cannot update an already up to date page!");
            }
            if (dataVersion > Version.getDataVersion()) {
                throw new IllegalStateException("Cannot downgrade pages!");
            }
        });
        this.startUncachedProcessing(page);
        CompletableFuture<ClientChestPage> future = new CompletableFuture<ClientChestPage>();
        Thread thread = new Thread(() -> {
            this.lock.lock(page);
            try {
                future.complete(this.updatePageSync(page, defaultDataVersion, false));
            }
            catch (Throwable e) {
                NBTEditor.LOGGER.error("Error updating client chest page " + (page + 1), e);
                future.completeExceptionally(e);
            }
            finally {
                this.lock.unlock(page);
                this.finishUncachedProcessing(page);
            }
        }, "NBTEditor/Async/ClientChest/Updating/" + page);
        thread.start();
        return future;
    }

    public CompletableFuture<Void> discardPage(int page) {
        File file = new File(CLIENT_CHEST_FOLDER, "page" + page + ".nbt");
        if (!file.exists()) {
            throw new IllegalStateException("Cannot discard an up to date page!");
        }
        if (this.getDataVersionStatus(page).map(status -> status == DataVersionStatus.CURRENT).orElse(false).booleanValue()) {
            throw new IllegalStateException("Cannot discard an up to date page!");
        }
        this.startUncachedProcessing(page);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            this.lock.lock(page);
            try {
                this.discardPageSync(page);
                future.complete(null);
            }
            catch (Throwable e) {
                NBTEditor.LOGGER.error("Error discarding client chest page " + (page + 1), e);
                future.completeExceptionally(e);
            }
            finally {
                this.lock.unlock(page);
                this.finishUncachedProcessing(page);
            }
        }, "NBTEditor/Async/ClientChest/Discarding/" + page);
        thread.start();
        return future;
    }

    public int[] getNearestPOIs(int page) {
        int pageCount = this.getPageCount();
        int[] output = this.cache.getNearestItems(page);
        if (output[1] >= pageCount) {
            output[1] = -1;
        }
        for (int namedPage : this.pageToName.keySet()) {
            if (namedPage >= pageCount) continue;
            if (namedPage < page && namedPage > output[0]) {
                output[0] = namedPage;
            }
            if (namedPage <= page || namedPage >= output[1] && output[1] != -1) continue;
            output[1] = namedPage;
        }
        return output;
    }

    private void startUncachedProcessing(int page) {
        this.uncachedProcessers.compute(page, (key, value) -> (value == null ? 0 : value) + 1);
    }

    private void finishUncachedProcessing(int page) {
        this.uncachedProcessers.compute(page, (key, value) -> value == 1 ? null : Integer.valueOf(value - 1));
    }

    private void startUncachedProcessingAll() {
        this.startUncachedProcessing(-1);
    }

    private void finishUncachedProcessingAll() {
        this.finishUncachedProcessing(-1);
    }

    private File getFile(int page) {
        return new File(CLIENT_CHEST_FOLDER, "page" + page + ".nbt");
    }

    private Optional<Optional<Integer>> getDataVersion(int page) {
        ClientChestPage pageData = this.cache.getCachedPage(page);
        if (pageData.loadLevel() == PageLoadLevel.UNLOADED) {
            return Optional.empty();
        }
        return Optional.of(pageData.dataVersion());
    }

    private Optional<DataVersionStatus> getDataVersionStatus(int page) {
        return this.getDataVersion(page).map(DataVersionStatus::of);
    }

    private Optional<Integer> readDataVersionSync(int page) throws Exception {
        File file = this.getFile(page);
        if (!file.exists()) {
            return Optional.of(Version.getDataVersion());
        }
        class_2487 pageNbt = MVMisc.readNbt(file);
        if (!pageNbt.method_10573("DataVersion", 99)) {
            return Optional.empty();
        }
        return Optional.of(pageNbt.method_10550("DataVersion"));
    }

    private DataVersionStatus readDataVersionStatusSync(int page) throws Exception {
        return DataVersionStatus.of(this.readDataVersionSync(page));
    }

    private ClientChestPage readPageSync(int page, PageLoadLevel loadLevel) throws Throwable {
        ClientChestPage cachedPage = this.cache.getCachedPage(page);
        if (loadLevel.ordinal() <= cachedPage.loadLevel().ordinal()) {
            return cachedPage;
        }
        if (loadLevel == PageLoadLevel.DYNAMIC_ITEMS && cachedPage.loadLevel() == PageLoadLevel.NORMAL_ITEMS) {
            class_1799[] items = Arrays.copyOf(cachedPage.items(), 54);
            DynamicItems dynamicItems = cachedPage.dynamicItems().copy();
            for (int slot : dynamicItems.getSlots()) {
                items[slot] = dynamicItems.tryLoad(slot);
            }
            ClientChestPage pageData = new ClientChestPage(items, dynamicItems, PageLoadLevel.DYNAMIC_ITEMS);
            this.cache.cachePage(page, pageData);
            return pageData;
        }
        File file = this.getFile(page);
        if (!file.exists()) {
            this.cache.cacheEmptyPage(page);
            return new ClientChestPage();
        }
        class_2487 pageNbt = MVMisc.readNbt(file);
        if (!pageNbt.method_10573("DataVersion", 99)) {
            ClientChestPage output = ClientChestPage.unknownDataVersion();
            this.cache.cachePage(page, output);
            return output;
        }
        int dataVersion = pageNbt.method_10550("DataVersion");
        if (dataVersion != Version.getDataVersion()) {
            ClientChestPage output = ClientChestPage.wrongDataVersion(dataVersion);
            this.cache.cachePage(page, output);
            return output;
        }
        class_2499 itemsNbt = pageNbt.method_10554("items", 10);
        class_1799[] items = new class_1799[54];
        DynamicItems dynamicItems = new DynamicItems();
        boolean empty = true;
        int i = -1;
        for (class_2520 itemElementNbt : itemsNbt) {
            ++i;
            class_2487 itemNbt = (class_2487)itemElementNbt;
            if (itemNbt.method_10573("dynamic", 1) && itemNbt.method_10577("dynamic")) {
                itemNbt.method_10551("dynamic");
                dynamicItems.add(i, itemNbt, false);
                empty = false;
                continue;
            }
            items[i] = MVMisc.withDefaultRegistryManager(() -> NBTManagers.ITEM.deserialize(itemNbt, true));
            if (!empty || items[i] == null || items[i].method_7960()) continue;
            empty = false;
        }
        if (empty) {
            this.cache.cacheEmptyPage(page);
            Files.delete(file.toPath());
            return new ClientChestPage();
        }
        if (loadLevel == PageLoadLevel.DYNAMIC_ITEMS) {
            for (int slot : dynamicItems.getSlots()) {
                items[slot] = dynamicItems.tryLoad(slot);
            }
        }
        ClientChestPage output = new ClientChestPage(items, dynamicItems, loadLevel);
        this.cache.cachePage(page, output);
        return output;
    }

    private void writePageSync(int page, ClientChestPage pageData) throws Throwable {
        if (pageData.loadLevel() == PageLoadLevel.UNLOADED) {
            return;
        }
        Optional<DataVersionStatus> dataVersionStatus = this.getDataVersionStatus(page);
        if (dataVersionStatus.isEmpty()) {
            dataVersionStatus = Optional.of(this.readDataVersionStatusSync(page));
        }
        if (dataVersionStatus.get() != DataVersionStatus.CURRENT) {
            throw new IllegalStateException("Cannot write to a page which has a different DataVersion!");
        }
        class_1799[] items = pageData.getItemsOrThrow();
        DynamicItems dynamicItems = pageData.dynamicItems();
        class_2487 pageNbt = new class_2487();
        pageNbt.method_10569("DataVersion", Version.getDataVersion());
        class_2499 itemsNbt = new class_2499();
        for (int i = 0; i < items.length; ++i) {
            class_2487 itemNbt = dynamicItems.isSlot(i) ? dynamicItems.getOriginalNbt(i) : (items[i] == null ? class_1799.field_8037 : items[i]).manager$serialize(true);
            if (dynamicItems.isSlot(i)) {
                itemNbt = itemNbt.method_10553();
                itemNbt.method_10567("dynamic", (byte)1);
            }
            itemsNbt.add((Object)itemNbt);
        }
        pageNbt.method_10566("items", (class_2520)itemsNbt);
        if (!CLIENT_CHEST_FOLDER.exists()) {
            CLIENT_CHEST_FOLDER.mkdir();
        }
        File file = this.getFile(page);
        File tmpFile = new File(CLIENT_CHEST_FOLDER, "saving_page" + page + "_" + System.currentTimeMillis() + ".nbt");
        MixinLink.throwHiddenException(() -> MVMisc.writeNbt(pageNbt, tmpFile));
        Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private ClientChestPage unloadPageSync(int page, PageLoadLevel loadLevel) {
        ClientChestPage cachedPage = this.cache.getCachedPage(page);
        if (cachedPage.loadLevel().ordinal() <= loadLevel.ordinal() || !cachedPage.isInThisVersion()) {
            return this.cache.getCachedPage(page);
        }
        if (loadLevel == PageLoadLevel.UNLOADED) {
            this.cache.discardPageCache(page);
            return ClientChestPage.unloaded();
        }
        DynamicItems dynamicItems = cachedPage.dynamicItems().copy();
        dynamicItems.unloadAll();
        cachedPage = new ClientChestPage(cachedPage.items(), dynamicItems, PageLoadLevel.NORMAL_ITEMS);
        this.cache.cachePage(page, cachedPage);
        return cachedPage;
    }

    private void importPageSync(int page, boolean ignoreInvalidDataVersion) throws Throwable {
        File file = this.getFile(page);
        if (!file.exists()) {
            if (ignoreInvalidDataVersion) {
                return;
            }
            throw new IllegalStateException("Cannot import an up to date page!");
        }
        class_2487 pageNbt = MVMisc.readNbt(file);
        if (pageNbt.method_10573("DataVersion", 99)) {
            if (ignoreInvalidDataVersion) {
                return;
            }
            throw new IllegalStateException("Cannot import a page with a DataVersion tag!");
        }
        Files.copy(file.toPath(), new File(CLIENT_CHEST_FOLDER, "importing_page" + page + "_" + System.currentTimeMillis() + ".nbt").toPath(), new CopyOption[0]);
        pageNbt.method_10569("DataVersion", Version.getDataVersion());
        File tmpFile = new File(CLIENT_CHEST_FOLDER, "saving_page" + page + "_" + System.currentTimeMillis() + ".nbt");
        MixinLink.throwHiddenException(() -> MVMisc.writeNbt(pageNbt, tmpFile));
        Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        PageLoadLevel loadLevel = this.getLoadLevel(page);
        this.cache.discardPageCache(page);
        this.readPageSync(page, loadLevel);
    }

    private ClientChestPage updatePageSync(int page, Optional<Integer> defaultDataVersion, boolean ignoreInvalidDataVersion) throws Throwable {
        int dataVersion;
        File file = new File(CLIENT_CHEST_FOLDER, "page" + page + ".nbt");
        if (!file.exists()) {
            if (ignoreInvalidDataVersion) {
                return null;
            }
            throw new IllegalStateException("Cannot update an already up to date page!");
        }
        class_2487 pageNbt = MVMisc.readNbt(file);
        try {
            int n = dataVersion = pageNbt.method_10573("DataVersion", 99) ? pageNbt.method_10550("DataVersion") : defaultDataVersion.orElseThrow(() -> new IllegalStateException("Missing DataVersion tag and default DataVersion!")).intValue();
            if (dataVersion == Version.getDataVersion()) {
                throw new IllegalStateException("Cannot update an already up to date page!");
            }
            if (dataVersion > Version.getDataVersion()) {
                throw new IllegalStateException("Cannot downgrade pages!");
            }
        }
        catch (IllegalStateException e) {
            if (ignoreInvalidDataVersion) {
                return null;
            }
            throw e;
        }
        Files.copy(file.toPath(), new File(CLIENT_CHEST_FOLDER, "updating_page" + page + "_" + System.currentTimeMillis() + ".nbt").toPath(), new CopyOption[0]);
        class_2499 itemsNbt = pageNbt.method_10554("items", 10);
        class_1799[] items = new class_1799[54];
        DynamicItems dynamicItems = new DynamicItems();
        boolean empty = true;
        int i = -1;
        for (class_2520 itemElementNbt : itemsNbt) {
            boolean dynamic;
            ++i;
            class_2487 itemNbt = (class_2487)itemElementNbt;
            boolean bl = dynamic = itemNbt.method_10573("dynamic", 1) && itemNbt.method_10577("dynamic");
            if (dynamic) {
                itemNbt.method_10551("dynamic");
            }
            itemNbt = MainUtil.updateDynamic(class_1208.field_5712, itemNbt, dataVersion);
            if (dynamic) {
                dynamicItems.add(i, itemNbt, false);
                empty = false;
                continue;
            }
            class_2487 finalItemNbt = itemNbt;
            items[i] = MVMisc.withDefaultRegistryManager(() -> NBTManagers.ITEM.deserialize(finalItemNbt, true));
            if (!empty || items[i] == null || items[i].method_7960()) continue;
            empty = false;
        }
        if (empty) {
            this.cache.cacheEmptyPage(page);
            Files.delete(file.toPath());
            return new ClientChestPage();
        }
        ClientChestPage output = new ClientChestPage(items, dynamicItems, PageLoadLevel.NORMAL_ITEMS);
        this.cache.cachePage(page, output);
        this.writePageSync(page, output);
        return output;
    }

    private void discardPageSync(int page) throws Throwable {
        File file = new File(CLIENT_CHEST_FOLDER, "page" + page + ".nbt");
        if (!file.exists()) {
            throw new IllegalStateException("Cannot discard an up to date page!");
        }
        class_2487 pageNbt = MVMisc.readNbt(file);
        if (pageNbt.method_10573("DataVersion", 99) && pageNbt.method_10550("DataVersion") == Version.getDataVersion()) {
            throw new IllegalStateException("Cannot discard an up to date page!");
        }
        this.cache.cacheEmptyPage(page);
        Files.delete(file.toPath());
    }

    private void backupCorruptPage(int page) {
        File file = this.getFile(page);
        if (!file.exists()) {
            return;
        }
        file.renameTo(new File(CLIENT_CHEST_FOLDER, "corrupt_page" + page + "_" + System.currentTimeMillis() + ".nbt"));
        this.warnCorrupt();
    }

    public void warnIfCorrupt() {
        if (!CLIENT_CHEST_FOLDER.exists()) {
            return;
        }
        try {
            if (Files.list(CLIENT_CHEST_FOLDER.toPath()).anyMatch(path -> path.toFile().getName().startsWith("corrupt_page"))) {
                this.warnCorrupt();
            }
        }
        catch (Exception e) {
            NBTEditor.LOGGER.error("Error checking for corrupt pages", (Throwable)e);
        }
    }

    private void warnCorrupt() {
        if (MainUtil.client.field_1724 == null) {
            return;
        }
        MainUtil.client.field_1724.method_7353(ClientChest.attachShowFolder(TextInst.translatable("nbteditor.client_chest.corrupt_warning", new Object[0])), false);
    }

    public static class_2561 attachShowFolder(EditableText text) {
        return text.append(" ").append(TextInst.translatable("nbteditor.file_options.show", new Object[0]).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, CLIENT_CHEST_FOLDER.getAbsolutePath()))));
    }
}

