/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.async;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class UpdateCheckerThread
extends Thread {
    private static final String VERSION;
    private static final URL URL;
    public static boolean UPDATE_AVAILABLE;

    public UpdateCheckerThread() {
        super("NBTEditor/Async/UpdateChecker");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        if (URL == null) {
            return;
        }
        try {
            String thisGameVersion = Version.getReleaseTarget();
            HttpURLConnection conn = (HttpURLConnection)URL.openConnection();
            JsonArray versions = (JsonArray)new Gson().fromJson(new String(conn.getInputStream().readAllBytes(), "UTF-8"), JsonArray.class);
            String highestVersion = null;
            for (JsonElement version : versions) {
                if (!version.getAsJsonObject().get("version_type").getAsString().equals("release")) continue;
                for (JsonElement gameVersion : version.getAsJsonObject().get("game_versions").getAsJsonArray()) {
                    if (!thisGameVersion.equals(gameVersion.getAsString())) continue;
                    String number = version.getAsJsonObject().get("version_number").getAsString();
                    if (highestVersion != null && UpdateCheckerThread.versionCompare(highestVersion, number)[0] >= 0) continue;
                    highestVersion = number;
                }
            }
            if (highestVersion == null) {
                NBTEditor.LOGGER.warn("Unable to check for updates! Is the game version invalid?");
            } else {
                int[] versionDiff = UpdateCheckerThread.versionCompare(highestVersion, VERSION);
                if (versionDiff[0] > 0) {
                    UPDATE_AVAILABLE = true;
                    NBTEditor.LOGGER.warn("NBT Editor is outdated! (" + highestVersion + " > " + VERSION + ")");
                    if (versionDiff[1] <= ConfigScreen.getCheckUpdates().getLevel()) {
                        MVMisc.showToast(TextInst.translatable("nbteditor.outdated.title", new Object[0]), TextInst.translatable("nbteditor.outdated.desc", new Object[0]));
                    }
                } else {
                    NBTEditor.LOGGER.info("NBT Editor is fully updated!");
                }
            }
        }
        catch (Exception e) {
            NBTEditor.LOGGER.error("Unable to check for updates!", (Throwable)e);
        }
    }

    private static int[] versionCompare(String a, String b) {
        int[] aInts = UpdateCheckerThread.getVersionInts(a);
        int[] bInts = UpdateCheckerThread.getVersionInts(b);
        for (int i = 0; i < Math.min(aInts.length, bInts.length); ++i) {
            int output = Integer.compare(aInts[i], bInts[i]);
            if (output == 0) continue;
            return new int[]{output, i};
        }
        return new int[]{Integer.compare(aInts.length, bInts.length), Math.min(aInts.length, bInts.length)};
    }

    private static int[] getVersionInts(String version) {
        return Stream.of(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
    }

    static {
        URL url;
        VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("nbteditor").orElseThrow()).getMetadata().getVersion().getFriendlyString();
        try {
            url = new URI("https://api.modrinth.com/v2/project/5Osk0m1G/version").toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            NBTEditor.LOGGER.error("Unable to check for updates!", (Throwable)e);
            url = null;
        }
        URL = url;
        UPDATE_AVAILABLE = false;
    }
}

