/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.async;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.OptionalLong;
import java.util.WeakHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class ItemSize {
    private static final WeakHashMap<class_1799, OptionalLong> uncompressedSizes = new WeakHashMap();
    private static final WeakHashMap<class_1799, OptionalLong> compressedSizes = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OptionalLong getItemSize(class_1799 stack, boolean compressed) {
        OptionalLong size;
        WeakHashMap<class_1799, OptionalLong> sizes;
        if (!stack.manager$hasNbt()) {
            return OptionalLong.of(ItemSize.calcItemSize(stack, compressed));
        }
        WeakHashMap<class_1799, OptionalLong> weakHashMap = sizes = compressed ? compressedSizes : uncompressedSizes;
        synchronized (weakHashMap) {
            size = sizes.get(stack);
            if (size != null) {
                return size;
            }
            size = OptionalLong.empty();
            sizes.put(stack, size);
        }
        Thread thread = new Thread(() -> {
            long knownSize = ItemSize.calcItemSize(stack, compressed);
            WeakHashMap weakHashMap = sizes;
            synchronized (weakHashMap) {
                sizes.put(stack, OptionalLong.of(knownSize));
            }
        }, "NBTEditor/Async/ItemSizeProcessor [" + String.valueOf(MVRegistry.ITEM.getId(stack.method_7909())) + "]");
        thread.setDaemon(true);
        thread.start();
        return size;
    }

    private static long calcItemSize(class_1799 stack, boolean compressed) {
        ByteCountingOutputStream stream = new ByteCountingOutputStream();
        try {
            class_2487 nbt = stack.manager$serialize(true);
            if (compressed) {
                MVMisc.writeCompressedNbt(nbt, stream);
            } else {
                MVMisc.writeNbt(nbt, stream);
            }
        }
        catch (Exception e) {
            NBTEditor.LOGGER.error("Error while getting the size of an item", (Throwable)e);
        }
        return stream.getCount();
    }

    private static class ByteCountingOutputStream
    extends OutputStream {
        private long count;

        private ByteCountingOutputStream() {
        }

        public long getCount() {
            return this.count;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.count;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.count += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.count += (long)len;
        }
    }
}

