/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.addons;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.addons.NBTEditorAddon;
import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.factories.FactoryCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.get.GetCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.get.GetPresetCommand;
import com.luneruniverse.minecraft.mod.nbteditor.containers.BlockContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.BlockEntityTagContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.EntityContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.EntityTagContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ItemContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReferenceFilter;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.LocalFactoryScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder.NBTFolder;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.CreativeTabWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.NbtFormatter;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.DSL;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_437;
import net.minecraft.class_481;

public class NBTEditorAPI {
    public static NBTEditorAddon getAddon(String modId) {
        return NBTEditorClient.getAddon(modId);
    }

    public static Map<String, NBTEditorAddon> getAddons() {
        return NBTEditorClient.getAddons();
    }

    public static void registerAdvancedFactory(final String name, final String extremeAlias, final Consumer<LiteralArgumentBuilder<FabricClientCommandSource>> onRegister) {
        FactoryCommand.INSTANCE.getChildren().add(new ClientCommand(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getExtremeAlias() {
                return extremeAlias;
            }

            @Override
            public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder, String path) {
                onRegister.accept(builder);
            }
        });
    }

    public static void registerFactory(String name, String extremeAlias, Consumer<NBTReference<?>> factory) {
        NBTEditorAPI.registerAdvancedFactory(name, extremeAlias, builder -> builder.executes(context -> {
            NBTReference.getReference(NBTReferenceFilter.ANY, false, factory);
            return 1;
        }));
    }

    public static void registerFactory(String name, String extremeAlias, class_2561 buttonMsg, Predicate<NBTReference<?>> supported, class_2561 unsupportedMsg, Consumer<NBTReference<?>> factory) {
        NBTEditorAPI.registerFactory(name, extremeAlias, ref -> {
            if (supported.test((NBTReference<?>)ref)) {
                factory.accept((NBTReference<?>)ref);
            } else if (MainUtil.client.field_1724 != null) {
                MainUtil.client.field_1724.method_7353(unsupportedMsg, false);
            }
        });
        LocalFactoryScreen.BASIC_FACTORIES.add(new LocalFactoryScreen.LocalFactoryReference(buttonMsg, supported, factory));
    }

    public static void registerGetCommand(final String name, final String extremeAlias, final Consumer<LiteralArgumentBuilder<FabricClientCommandSource>> onRegister) {
        GetCommand.INSTANCE.getChildren().add(new ClientCommand(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getExtremeAlias() {
                return extremeAlias;
            }

            @Override
            public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder, String path) {
                onRegister.accept(builder);
            }
        });
    }

    public static void registerPresetItem(String name, Supplier<class_1799> item) {
        GetPresetCommand.registerPresetItem(name, item);
    }

    public static Supplier<class_1799> registerPresetItem(String name, boolean reloadable) {
        Supplier<class_1799> item;
        Supplier<class_1799> reloadHandledItem = item = GetPresetCommand.registerPresetItem(name);
        if (!reloadable) {
            reloadHandledItem = new Supplier<class_1799>(){
                private class_1799 value;

                @Override
                public class_1799 get() {
                    if (this.value == null) {
                        this.value = (class_1799)item.get();
                    }
                    return this.value;
                }
            };
            GetPresetCommand.registerPresetItem(name, reloadHandledItem);
        }
        return reloadHandledItem;
    }

    public static void registerItemContainer(class_1792 item, ItemContainerIO container) {
        ContainerIO.registerItemIO(item, container);
    }

    public static void registerBlockContainer(class_2248 block, BlockContainerIO container) {
        ContainerIO.registerBlockIO(block, container);
    }

    public static void registerEntityContainer(class_1299<?> entity, EntityContainerIO container) {
        ContainerIO.registerEntityIO(entity, container);
    }

    public static void registerBlockEntityTagContainer(class_1747 blockItem, BlockEntityTagContainerIO container) {
        ContainerIO.registerBlockEntityTagIO(blockItem, container);
    }

    public static void registerBlockEntityTagContainer(class_1747 blockItem, Function<class_2591<?>, BlockEntityTagContainerIO> container) {
        ContainerIO.registerBlockEntityTagIO(blockItem, container);
    }

    public static void registerEntityTagContainer(class_1792 item, class_1299<?> entity, EntityTagContainerIO container) {
        ContainerIO.registerEntityTagIO(item, entity, container);
    }

    public static void registerEntityTagContainer(class_1792 item, class_1299<?> entity, Function<class_1299<?>, EntityTagContainerIO> container) {
        ContainerIO.registerEntityTagIO(item, entity, container);
    }

    public static void registerNBTFolderType(Class<? extends class_2520> clazz, NBTFolder.Constructor<?> folder) {
        NBTFolder.TYPES.put(clazz, folder);
    }

    public static void registerConfigItem(Consumer<ConfigCategory> item) {
        ConfigScreen.ADDED_OPTIONS.add(item);
    }

    public static void registerConfigItem(String name, Supplier<ConfigPath> item) {
        NBTEditorAPI.registerConfigItem(config -> config.setConfigurable(name, (ConfigPath)item.get()));
    }

    public static void registerInventoryTab(class_1799 item, Runnable onClick, Predicate<class_437> whenToShow) {
        CreativeTabWidget.TABS.add(new CreativeTabWidget.CreativeTabData(item, onClick, whenToShow));
    }

    public static void registerInventoryTab(class_1799 item, Runnable onClick) {
        NBTEditorAPI.registerInventoryTab(item, onClick, screen -> screen instanceof class_481);
    }

    public static void setNBTFormatter(NbtFormatter.Impl formatter) {
        NbtFormatter.FORMATTER = formatter;
    }

    public static <T extends class_2520> T updateNBT(DSL.TypeReference typeRef, T nbt, int oldVersion) {
        return MainUtil.update(typeRef, nbt, oldVersion);
    }

    public static <T extends class_2520> T updateNBTDynamic(DSL.TypeReference typeRef, T nbt, class_2520 dataVersionTag, int defaultOldVersion) {
        return MainUtil.updateDynamic(typeRef, nbt, dataVersionTag, defaultOldVersion);
    }

    public static class_2487 updateNBTDynamic(DSL.TypeReference typeRef, class_2487 nbt, int defaultOldVersion) {
        return MainUtil.updateDynamic(typeRef, nbt, defaultOldVersion);
    }

    public static class_2487 updateNBTDynamic(DSL.TypeReference typeRef, class_2487 nbt) {
        return MainUtil.updateDynamic(typeRef, nbt);
    }
}

