/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVClientNetworking;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ContainerScreenS2CPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ProtocolVersionS2CPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ResponsePacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ViewBlockS2CPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ViewEntityS2CPacket;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientChestScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ContainerScreen;
import com.luneruniverse.minecraft.mod.nbteditor.server.ServerMVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_437;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_634;

public class NBTEditorServerConn
implements MVClientNetworking.PlayNetworkStateEvents.Start,
MVClientNetworking.PlayNetworkStateEvents.Stop {
    private Status status = Status.DISCONNECTED;
    private boolean containerScreen = false;
    private int lastRequestId = -1;
    private final Map<Integer, CompletableFuture<MVPacket>> requests = new HashMap<Integer, CompletableFuture<MVPacket>>();

    public NBTEditorServerConn() {
        MVClientNetworking.registerListener(ProtocolVersionS2CPacket.ID, this::onProtocolVersionPacket);
        MVClientNetworking.registerListener(ContainerScreenS2CPacket.ID, this::onContainerScreenPacket);
        MVClientNetworking.registerListener(ViewBlockS2CPacket.ID, this::receiveRequest);
        MVClientNetworking.registerListener(ViewEntityS2CPacket.ID, this::receiveRequest);
        MVClientNetworking.PlayNetworkStateEvents.Start.EVENT.register((Object)this);
        MVClientNetworking.PlayNetworkStateEvents.Stop.EVENT.register((Object)this);
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isEditingExpanded() {
        if (this.status != Status.BOTH) {
            return false;
        }
        class_1934 gameMode = MainUtil.client.field_1761.method_2920();
        return (gameMode.method_8386() || gameMode.method_8388()) && ServerMVMisc.hasPermissionLevel((class_1657)MainUtil.client.field_1724, 2);
    }

    public boolean isEditingAllowed() {
        return MainUtil.client.field_1761.method_2920().method_8386() || this.isEditingExpanded();
    }

    public boolean isScreenEditable() {
        class_437 screen = MainUtil.client.field_1755;
        return screen instanceof class_481 || screen instanceof ClientChestScreen || screen instanceof ContainerScreen || this.isEditingExpanded() && (screen instanceof class_490 || this.containerScreen);
    }

    public void closeContainerScreen() {
        this.containerScreen = false;
    }

    public boolean isContainerScreen() {
        return this.containerScreen;
    }

    public <T extends MVPacket> CompletableFuture<Optional<T>> sendRequest(Function<Integer, MVPacket> packet, Class<T> responseType) {
        if (!this.isEditingExpanded()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        CompletableFuture future = new CompletableFuture();
        int requestId = ++this.lastRequestId;
        this.requests.put(requestId, future);
        MVClientNetworking.send(packet.apply(requestId));
        return ((CompletableFuture)future.thenApply(response -> {
            if (responseType.isInstance(response)) {
                return Optional.of((MVPacket)responseType.cast(response));
            }
            return Optional.empty();
        })).completeOnTimeout(Optional.empty(), 1000L, TimeUnit.MILLISECONDS).thenApply(output -> {
            this.requests.remove(requestId);
            return output;
        });
    }

    private void receiveRequest(ResponsePacket packet) {
        CompletableFuture<MVPacket> receiver = this.requests.remove(packet.getRequestId());
        if (receiver != null) {
            receiver.complete(packet);
        }
    }

    @Override
    public void onPlayStart(class_634 networkHandler) {
        this.status = Status.CLIENT_ONLY;
    }

    @Override
    public void onPlayStop() {
        this.status = Status.DISCONNECTED;
    }

    private void onProtocolVersionPacket(ProtocolVersionS2CPacket packet) {
        if (packet.getVersion() == 1) {
            this.status = Status.BOTH;
        } else {
            this.status = Status.INCOMPATIBLE;
            if (ConfigScreen.isWarnIncompatibleProtocol()) {
                MVMisc.showToast(TextInst.translatable("nbteditor.incompatible_protocol.title", new Object[0]), TextInst.translatable("nbteditor.incompatible_protocol.desc", new Object[0]));
            }
        }
    }

    private void onContainerScreenPacket(ContainerScreenS2CPacket packet) {
        this.containerScreen = true;
    }

    public static enum Status {
        DISCONNECTED,
        CLIENT_ONLY,
        INCOMPATIBLE,
        BOTH;

    }
}

