/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor;

import com.luneruniverse.minecraft.mod.nbteditor.MC_1_17_Link;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorServerConn;
import com.luneruniverse.minecraft.mod.nbteditor.addons.NBTEditorAPI;
import com.luneruniverse.minecraft.mod.nbteditor.addons.NBTEditorAddon;
import com.luneruniverse.minecraft.mod.nbteditor.async.HeadRefreshThread;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChest;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestHelper;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.LargeClientChestPageCache;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.PageLoadLevel;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.SmallClientChestPageCache;
import com.luneruniverse.minecraft.mod.nbteditor.commands.CommandHandler;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVEnchantments;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVClientNetworking;
import com.luneruniverse.minecraft.mod.nbteditor.packets.OpenEnderChestC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientChestScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.CursorManager;
import com.luneruniverse.minecraft.mod.nbteditor.server.NBTEditorServer;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_481;
import net.minecraft.class_490;
import tsp.headdb.ported.HeadAPI;

public class NBTEditorClient
implements ClientModInitializer {
    public static final File SETTINGS_FOLDER;
    public static CursorManager CURSOR_MANAGER;
    public static ClientChest CLIENT_CHEST;
    public static NBTEditorServerConn SERVER_CONN;
    private static final Map<String, NBTEditorAddon> addons;

    public static NBTEditorAddon getAddon(String modId) {
        return addons.get(modId);
    }

    public static Map<String, NBTEditorAddon> getAddons() {
        return Collections.unmodifiableMap(addons);
    }

    public void onInitializeClient() {
        NBTEditorServer.IS_DEDICATED = false;
        if (!SETTINGS_FOLDER.exists()) {
            SETTINGS_FOLDER.mkdir();
        }
        MVMisc.onRegistriesLoad(this::onRegistriesLoad);
    }

    private void onRegistriesLoad() {
        CommandHandler.registerCommands();
        try {
            HeadAPI.loadFavorites();
        }
        catch (IOException e) {
            NBTEditor.LOGGER.error("Error while loading HeadDB favorites", (Throwable)e);
        }
        ContainerIO.loadClass();
        new HeadRefreshThread().start();
        ConfigScreen.loadSettings();
        CURSOR_MANAGER = new CursorManager();
        CLIENT_CHEST = new ClientChest(ConfigScreen.isLargeClientChest() ? new LargeClientChestPageCache(5) : new SmallClientChestPageCache(100));
        ClientChestHelper.loadDefaultPages(PageLoadLevel.NORMAL_ITEMS);
        MVClientNetworking.PlayNetworkStateEvents.Start.EVENT.register(networkHandler -> ClientChestHelper.loadDefaultPages(PageLoadLevel.DYNAMIC_ITEMS));
        MVClientNetworking.PlayNetworkStateEvents.Stop.EVENT.register(() -> ClientChestHelper.unloadAllPages(PageLoadLevel.NORMAL_ITEMS));
        class_1799 clientChestIcon = new class_1799((class_1935)class_1802.field_8466).manager$setCustomName((class_2561)TextInst.translatable("itemGroup.nbteditor.client_chest", new Object[0]));
        MVEnchantments.addEnchantment(clientChestIcon, MVEnchantments.LOYALTY, 1);
        MixinLink.ENCHANT_GLINT_FIX.add(clientChestIcon);
        NBTEditorAPI.registerInventoryTab(clientChestIcon, ClientChestScreen::show, screen -> screen instanceof class_481 || screen instanceof class_490 && SERVER_CONN.isEditingExpanded());
        NBTEditorAPI.registerInventoryTab(new class_1799((class_1935)class_1802.field_8106).manager$setCustomName((class_2561)TextInst.translatable("itemGroup.nbteditor.inventory", new Object[0])), CURSOR_MANAGER::showRoot, screen -> screen instanceof ClientChestScreen);
        NBTEditorAPI.registerInventoryTab(new class_1799((class_1935)class_1802.field_8466), () -> {
            CURSOR_MANAGER.closeRoot();
            MVClientNetworking.send(new OpenEnderChestC2SPacket());
        }, screen -> (screen instanceof class_481 || screen instanceof class_490 || screen instanceof ClientChestScreen) && SERVER_CONN.isEditingExpanded());
        SERVER_CONN = new NBTEditorServerConn();
        for (EntrypointContainer container : FabricLoader.getInstance().getEntrypointContainers("nbteditor", NBTEditorAddon.class)) {
            addons.put(container.getProvider().getMetadata().getId(), (NBTEditorAddon)container.getEntrypoint());
        }
        addons.forEach((id, addon) -> addon.onInit());
    }

    static {
        MC_1_17_Link.MixinLink.ENCHANT_GLINT_FIX = MixinLink.ENCHANT_GLINT_FIX;
        MC_1_17_Link.MixinLink.USE_DIRECT_ITEM_GLINT_CONSUMER = Version.newSwitch().range("1.21.2", null, false).range(null, "1.21.1", true).get();
        MC_1_17_Link.ConfigScreen.isEnchantGlintFix_impl = ConfigScreen::isEnchantGlintFix;
        SETTINGS_FOLDER = new File("nbteditor");
        addons = new HashMap<String, NBTEditorAddon>();
    }
}

