/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.fabric.xray.screens.forge;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3965;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import net.minecraft.class_918;
import pro.mikey.fabric.xray.ScanController;
import pro.mikey.fabric.xray.StateSettings;
import pro.mikey.fabric.xray.XRay;
import pro.mikey.fabric.xray.records.BasicColor;
import pro.mikey.fabric.xray.records.BlockEntry;
import pro.mikey.fabric.xray.records.BlockGroup;
import pro.mikey.fabric.xray.screens.forge.GuiAddBlock;
import pro.mikey.fabric.xray.screens.forge.GuiBase;
import pro.mikey.fabric.xray.screens.forge.GuiBlockList;
import pro.mikey.fabric.xray.screens.forge.GuiEdit;
import pro.mikey.fabric.xray.screens.forge.GuiHelp;
import pro.mikey.fabric.xray.screens.forge.ScrollingList;
import pro.mikey.fabric.xray.storage.BlockStore;
import pro.mikey.fabric.xray.storage.SettingsStore;

public class GuiSelectionScreen
extends GuiBase {
    private static final List<class_2248> ORE_TAGS = List.of(class_2246.field_10571, class_2246.field_10212, class_2246.field_10442, class_2246.field_10080, class_2246.field_10090, class_2246.field_10418, class_2246.field_10013, class_2246.field_27120, class_2246.field_29026, class_2246.field_29027, class_2246.field_29029, class_2246.field_29030, class_2246.field_29028, class_2246.field_29219, class_2246.field_29220, class_2246.field_29221, class_2246.field_23077, class_2246.field_22109);
    private static final class_2960 CIRCLE = new class_2960(XRay.PREFIX_GUI + "circle.png");
    private final List<BlockEntry> originalList;
    public class_918 render;
    private class_4185 distButtons;
    private class_342 search;
    private String lastSearch = "";
    private List<BlockEntry> itemList;
    private ScrollingBlockList scrollList;

    public GuiSelectionScreen() {
        super(true);
        this.setSideTitle(class_1074.method_4662((String)"xray.single.tools", (Object[])new Object[0]));
        this.populateDefault();
        this.itemList = BlockStore.getInstance().get().size() >= 1 ? ((BlockGroup)BlockStore.getInstance().get().get(0)).entries() : new ArrayList<BlockEntry>();
        this.itemList.sort(Comparator.comparingInt(BlockEntry::getOrder));
        this.originalList = this.itemList;
    }

    private void populateDefault() {
        if (BlockStore.getInstance().justCreated && BlockStore.getInstance().get().size() == 0) {
            AtomicInteger order = new AtomicInteger();
            Random random = new Random();
            BlockStore.getInstance().get().add(new BlockGroup("default", ORE_TAGS.stream().map(e -> new BlockEntry(e.method_9564(), e.method_8389().method_7848().getString(), new BasicColor(random.nextInt(255), random.nextInt(255), random.nextInt(255)), order.getAndIncrement(), true, true)).collect(Collectors.toList()), 0, true));
            BlockStore.getInstance().updateCache();
        }
    }

    public void method_25426() {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        this.render = class_310.method_1551().method_1480();
        this.scrollList = new ScrollingBlockList(this.getWidth() / 2 - 37, this.getHeight() / 2 + 10, 203, 185, this.itemList, this);
        this.method_37063((class_364)this.scrollList);
        this.search = new class_342(this.getFontRender(), this.getWidth() / 2 - 137, this.getHeight() / 2 - 105, 202, 18, (class_2561)class_2561.method_43473());
        this.search.method_1856(true);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"xray.input.add"), button -> {
            this.field_22787.field_1724.method_3137();
            this.field_22787.method_1507((class_437)new GuiBlockList());
        }).method_46433(this.getWidth() / 2 + 79, this.getHeight() / 2 - 60).method_46437(120, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"xray.tooltips.add_block"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"xray.input.add_hand"), button -> {
            this.field_22787.field_1724.method_3137();
            class_1799 handItem = this.field_22787.field_1724.method_5998(class_1268.field_5808);
            if (!(handItem.method_7909() instanceof class_1747)) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("[XRay] " + class_1074.method_4662((String)"xray.message.invalid_hand", (Object[])new Object[]{handItem.method_7964().getString()}))), false);
                return;
            }
            this.field_22787.method_1507((class_437)new GuiAddBlock(((class_1747)handItem.method_7909()).method_7711().method_9564(), GuiSelectionScreen::new));
        }).method_46433(this.getWidth() / 2 + 79, this.getHeight() / 2 - 38).method_46437(120, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"xray.tooltips.add_block_in_hand"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"xray.input.add_look"), button -> {
            class_746 player = this.field_22787.field_1724;
            if (this.field_22787.field_1687 == null || player == null) {
                return;
            }
            this.method_25419();
            try {
                class_239 look = player.method_5745(100.0, 1.0f, false);
                if (look.method_17783() == class_239.class_240.field_1332) {
                    class_2680 state = this.field_22787.field_1687.method_8320(((class_3965)look).method_17777());
                    player.method_3137();
                    this.field_22787.method_1507((class_437)new GuiAddBlock(state, GuiSelectionScreen::new));
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)("[XRay] " + class_1074.method_4662((String)"xray.message.nothing_infront", (Object[])new Object[0]))), false);
                }
            }
            catch (NullPointerException ex) {
                player.method_7353((class_2561)class_2561.method_43470((String)("[XRay] " + class_1074.method_4662((String)"xray.message.thats_odd", (Object[])new Object[0]))), false);
            }
        }).method_46433(this.getWidth() / 2 + 79, this.getHeight() / 2 - 16).method_46437(120, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"xray.tooltips.add_block_looking_at"))).method_46431());
        this.distButtons = class_4185.method_46430((class_2561)class_2561.method_43469((String)"xray.input.show-lava", (Object[])new Object[]{SettingsStore.getInstance().get().isShowLava()}), button -> {
            SettingsStore.getInstance().get().setShowLava(!SettingsStore.getInstance().get().isShowLava());
            ScanController.runTask(true);
            button.method_25355((class_2561)class_2561.method_43469((String)"xray.input.show-lava", (Object[])new Object[]{SettingsStore.getInstance().get().isShowLava()}));
        }).method_46433(this.getWidth() / 2 + 79, this.getHeight() / 2 + 6).method_46437(120, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"xray.tooltips.show_lava"))).method_46431();
        this.method_37063((class_364)this.distButtons);
        this.distButtons = class_4185.method_46430((class_2561)class_2561.method_43469((String)"xray.input.distance", (Object[])new Object[]{StateSettings.getVisualRadius()}), button -> {
            SettingsStore.getInstance().get().increaseRange();
            button.method_25355((class_2561)class_2561.method_43469((String)"xray.input.distance", (Object[])new Object[]{StateSettings.getVisualRadius()}));
        }).method_46433(this.getWidth() / 2 + 79, this.getHeight() / 2 + 36).method_46437(120, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"xray.tooltips.distance"))).method_46431();
        this.method_37063((class_364)this.distButtons);
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"xray.single.help"), button -> {
            this.field_22787.field_1724.method_3137();
            this.field_22787.method_1507((class_437)new GuiHelp());
        }).method_46433(this.getWidth() / 2 + 79, this.getHeight() / 2 + 58).method_46437(60, 20).method_46431());
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"xray.single.close"), button -> this.method_25419()).method_46433(this.getWidth() / 2 + 79 + 62, this.getHeight() / 2 + 58).method_46437(59, 20).method_46431());
    }

    private void updateSearch() {
        if (this.lastSearch.equals(this.search.method_1882())) {
            return;
        }
        if (this.search.method_1882().equals("")) {
            this.itemList = this.originalList;
            this.scrollList.updateEntries(this.itemList);
            this.lastSearch = "";
            return;
        }
        this.itemList = this.originalList.stream().filter(b -> b.getName().toLowerCase().contains(this.search.method_1882().toLowerCase())).collect(Collectors.toCollection(ArrayList::new));
        this.itemList.sort(Comparator.comparingInt(BlockEntry::getOrder));
        this.scrollList.updateEntries(this.itemList);
        this.lastSearch = this.search.method_1882();
    }

    public void method_25393() {
        super.method_25393();
        this.search.method_1865();
        this.updateSearch();
    }

    public boolean method_25402(double x, double y, int mouse) {
        if (this.search.method_25402(x, y, mouse)) {
            this.method_25395((class_364)this.search);
        }
        if (mouse == 1 && this.distButtons.method_25405(x, y)) {
            SettingsStore.getInstance().get().decreaseRange();
            this.distButtons.method_25355((class_2561)class_2561.method_43469((String)"xray.input.distance", (Object[])new Object[]{StateSettings.getVisualRadius()}));
            this.distButtons.method_25354(this.field_22787.method_1483());
        }
        return super.method_25402(x, y, mouse);
    }

    @Override
    public void renderExtra(class_332 guiGraphics, int x, int y, float partialTicks) {
        this.search.method_25394(guiGraphics, x, y, partialTicks);
        this.scrollList.method_25394(guiGraphics, x, y, partialTicks);
        if (!this.search.method_25370() && this.search.method_1882().equals("")) {
            guiGraphics.method_25303(this.field_22793, class_1074.method_4662((String)"xray.single.search", (Object[])new Object[0]), this.getWidth() / 2 - 130, this.getHeight() / 2 - 101, Color.GRAY.getRGB());
        }
    }

    public void method_25419() {
        SettingsStore.getInstance().write();
        BlockStore.getInstance().write();
        BlockStore.getInstance().updateCache();
        ScanController.runTask(true);
        super.method_25419();
    }

    public static class ScrollingBlockList
    extends ScrollingList<BlockSlot> {
        static final int SLOT_HEIGHT = 35;
        GuiSelectionScreen parent;

        ScrollingBlockList(int x, int y, int width, int height, List<BlockEntry> blocks, GuiSelectionScreen parent) {
            super(x, y, width, height, 35);
            this.updateEntries(blocks);
            this.parent = parent;
        }

        void setSelected(BlockSlot entry, int mouse) {
            if (entry == null) {
                return;
            }
            if (GuiSelectionScreen.method_25442()) {
                this.field_22740.field_1724.method_3137();
                this.field_22740.method_1507((class_437)new GuiEdit(entry.block));
                return;
            }
            try {
                int index = ((BlockGroup)BlockStore.getInstance().get().get(0)).entries().indexOf(entry.getBlock());
                BlockEntry blockEntry = ((BlockGroup)BlockStore.getInstance().get().get(0)).entries().get(index);
                blockEntry.setActive(!blockEntry.isActive());
                ((BlockGroup)BlockStore.getInstance().get().get(0)).entries().set(index, blockEntry);
                BlockStore.getInstance().write();
                BlockStore.getInstance().updateCache();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void updateEntries(List<BlockEntry> blocks) {
            this.method_25339();
            blocks.forEach(block -> this.method_25321(new BlockSlot((BlockEntry)block, this)));
        }

        public Optional<class_364> method_19355(double mouseX, double mouseY) {
            return Optional.empty();
        }

        public class BlockSlot
        extends class_350.class_351<BlockSlot> {
            BlockEntry block;
            ScrollingBlockList parent;

            BlockSlot(BlockEntry block, ScrollingBlockList parent) {
                this.block = block;
                this.parent = parent;
            }

            public BlockEntry getBlock() {
                return this.block;
            }

            public void method_25343(class_332 guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                BlockEntry blockData = this.block;
                class_327 font = ((ScrollingBlockList)this.parent).field_22740.field_1772;
                guiGraphics.method_25303(font, blockData.getName(), left + 35, top + 7, 0xFFFFFF);
                guiGraphics.method_25303(font, blockData.isActive() ? "Enabled" : "Disabled", left + 35, top + 17, blockData.isActive() ? Color.GREEN.getRGB() : Color.RED.getRGB());
                guiGraphics.method_51427(blockData.getStack(), left + 10, top + 7);
                if (mouseX > left && mouseX < left + entryWidth && mouseY > top && mouseY < top + entryHeight && mouseY < this.parent.field_19085 + this.parent.field_22743 && mouseY > this.parent.field_19085) {
                    guiGraphics.method_51447(font, Arrays.asList(class_2561.method_43471((String)"xray.tooltips.edit1").method_30937(), class_2561.method_43471((String)"xray.tooltips.edit2").method_30937()), left + 15, entryIdx == this.parent.method_25396().size() - 1 && entryIdx != 0 ? top - (entryHeight - 20) : top + (entryHeight + 15));
                }
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                guiGraphics.method_25290(CIRCLE, left + entryWidth - 32, (int)((float)top + (float)entryHeight / 2.0f - 9.0f), 0.0f, 0.0f, 14, 14, 14, 14);
                RenderSystem.setShaderColor((float)((float)blockData.getHex().red() / 255.0f), (float)((float)blockData.getHex().green() / 255.0f), (float)((float)blockData.getHex().blue() / 255.0f), (float)1.0f);
                guiGraphics.method_25290(CIRCLE, left + entryWidth - 30, (int)((float)top + (float)entryHeight / 2.0f - 7.0f), 0.0f, 0.0f, 10, 10, 10, 10);
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }

            public boolean method_25402(double p_mouseClicked_1_, double p_mouseClicked_3_, int mouse) {
                this.parent.setSelected(this, mouse);
                return false;
            }
        }
    }
}

