/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.fabric.xray;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.mikey.fabric.xray.ScanController;
import pro.mikey.fabric.xray.StateSettings;
import pro.mikey.fabric.xray.render.RenderOutlines;
import pro.mikey.fabric.xray.screens.forge.GuiOverlay;
import pro.mikey.fabric.xray.screens.forge.GuiSelectionScreen;
import pro.mikey.fabric.xray.storage.BlockStore;
import pro.mikey.fabric.xray.storage.SettingsStore;

public class XRay
implements ModInitializer {
    public static final String MOD_ID = "advanced-xray-fabric";
    public static final String PREFIX_GUI = String.format("%s:textures/gui/", "advanced-xray-fabric");
    public static final Logger LOGGER = LogManager.getLogger((String)"advanced-xray-fabric");
    private final class_304 xrayButton = new class_304("keybinding.enable_xray", 92, "category.xray");
    private final class_304 guiButton = new class_304("keybinding.open_gui", 71, "category.xray");

    public void onInitialize() {
        LOGGER.info("XRay mod has been initialized");
        ClientTickEvents.END_CLIENT_TICK.register(this::clientTickEvent);
        ClientLifecycleEvents.CLIENT_STOPPING.register(this::gameClosing);
        ClientLifecycleEvents.CLIENT_STARTED.register(this::started);
        HudRenderCallback.EVENT.register(GuiOverlay::RenderGameOverlayEvent);
        WorldRenderEvents.LAST.register(RenderOutlines::render);
        PlayerBlockBreakEvents.AFTER.register(ScanController::blockBroken);
        KeyBindingHelper.registerKeyBinding((class_304)this.xrayButton);
        KeyBindingHelper.registerKeyBinding((class_304)this.guiButton);
    }

    private void started(class_310 minecraft) {
        LOGGER.info("Client started, setting up xray store");
    }

    private void gameClosing(class_310 client) {
        SettingsStore.getInstance().write();
        BlockStore.getInstance().write();
    }

    private void clientTickEvent(class_310 mc) {
        if (mc.field_1724 == null || mc.field_1687 == null || mc.field_1755 != null) {
            return;
        }
        ScanController.runTask(false);
        while (this.guiButton.method_1436()) {
            mc.method_1507((class_437)new GuiSelectionScreen());
        }
        while (this.xrayButton.method_1436()) {
            BlockStore.getInstance().updateCache();
            StateSettings stateSettings = SettingsStore.getInstance().get();
            stateSettings.setActive(!stateSettings.isActive());
            ScanController.runTask(true);
            mc.field_1724.method_7353((class_2561)class_2561.method_43471((String)("message.xray_" + (!stateSettings.isActive() ? "deactivate" : "active"))).method_27692(stateSettings.isActive() ? class_124.field_1060 : class_124.field_1061), true);
        }
    }
}

