/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.impl.client.NinePatchTextureRendererImpl;
import io.github.cottonmc.cotton.gui.widget.WAbstractSlider;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import juuxel.libninepatch.ContextualTextureRenderer;
import juuxel.libninepatch.NinePatch;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class WScrollBar
extends WWidget {
    private static final int SCROLLING_SPEED = 4;
    protected Axis axis = Axis.HORIZONTAL;
    protected int value;
    protected int maxValue = 100;
    protected int window = 16;
    protected int anchor = -1;
    protected int anchorValue = -1;
    protected boolean sliding = false;

    public WScrollBar() {
    }

    public WScrollBar(Axis axis) {
        this.axis = axis;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        NinePatch<class_2960> painter;
        class_4587 matrices = context.method_51448();
        boolean darkMode = this.shouldRenderInDarkMode();
        Painters.BACKGROUND.paintBackground(context, x, y, this);
        NinePatch<class_2960> ninePatch = painter = darkMode ? Painters.SCROLL_BAR_DARK : Painters.SCROLL_BAR;
        if (this.maxValue <= 0) {
            return;
        }
        if (this.sliding) {
            painter = darkMode ? Painters.SCROLL_BAR_PRESSED_DARK : Painters.SCROLL_BAR_PRESSED;
        } else if (this.isWithinBounds(mouseX, mouseY)) {
            painter = darkMode ? Painters.SCROLL_BAR_HOVERED_DARK : Painters.SCROLL_BAR_HOVERED;
        }
        matrices.method_22903();
        if (this.axis == Axis.HORIZONTAL) {
            matrices.method_46416((float)(x + 1 + this.getHandlePosition()), (float)(y + 1), 0.0f);
            painter.draw((ContextualTextureRenderer)NinePatchTextureRendererImpl.INSTANCE, (Object)context, this.getHandleSize(), this.height - 2);
            if (this.isFocused()) {
                Painters.FOCUS.draw((ContextualTextureRenderer)NinePatchTextureRendererImpl.INSTANCE, (Object)context, this.getHandleSize(), this.height - 2);
            }
        } else {
            matrices.method_46416((float)(x + 1), (float)(y + 1 + this.getHandlePosition()), 0.0f);
            painter.draw((ContextualTextureRenderer)NinePatchTextureRendererImpl.INSTANCE, (Object)context, this.width - 2, this.getHandleSize());
            if (this.isFocused()) {
                Painters.FOCUS.draw((ContextualTextureRenderer)NinePatchTextureRendererImpl.INSTANCE, (Object)context, this.width - 2, this.getHandleSize());
            }
        }
        matrices.method_22909();
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    public int getHandleSize() {
        int bar;
        float percentage = this.window >= this.maxValue ? 1.0f : (float)this.window / (float)this.maxValue;
        int result = (int)(percentage * (float)(bar = this.axis == Axis.HORIZONTAL ? this.width - 2 : this.height - 2));
        if (result < 6) {
            result = 6;
        }
        return result;
    }

    public int getMovableDistance() {
        int bar = this.axis == Axis.HORIZONTAL ? this.width - 2 : this.height - 2;
        return bar - this.getHandleSize();
    }

    public int pixelsToValues(int pixels) {
        int bar = this.getMovableDistance();
        float percent = (float)pixels / (float)bar;
        return (int)(percent * (float)(this.maxValue - this.window));
    }

    public int getHandlePosition() {
        float percent = (float)this.value / (float)Math.max(this.maxValue - this.window, 1);
        return (int)(percent * (float)this.getMovableDistance());
    }

    public int getMaxScrollValue() {
        return this.maxValue - this.window;
    }

    protected void adjustSlider(int x, int y) {
        int delta = 0;
        delta = this.axis == Axis.HORIZONTAL ? x - this.anchor : y - this.anchor;
        int valueDelta = this.pixelsToValues(delta);
        int valueNew = this.anchorValue + valueDelta;
        if (valueNew > this.getMaxScrollValue()) {
            valueNew = this.getMaxScrollValue();
        }
        if (valueNew < 0) {
            valueNew = 0;
        }
        this.value = valueNew;
    }

    @Override
    public InputResult onMouseDown(int x, int y, int button) {
        this.requestFocus();
        if (this.axis == Axis.HORIZONTAL) {
            this.anchor = x;
            this.anchorValue = this.value;
        } else {
            this.anchor = y;
            this.anchorValue = this.value;
        }
        this.sliding = true;
        return InputResult.PROCESSED;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseDrag(int x, int y, int button, double deltaX, double deltaY) {
        this.adjustSlider(x, y);
        return InputResult.PROCESSED;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseUp(int x, int y, int button) {
        this.anchor = -1;
        this.anchorValue = -1;
        this.sliding = false;
        return InputResult.PROCESSED;
    }

    @Override
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        WAbstractSlider.Direction direction;
        WAbstractSlider.Direction direction2 = direction = this.axis == Axis.HORIZONTAL ? WAbstractSlider.Direction.RIGHT : WAbstractSlider.Direction.DOWN;
        if (WAbstractSlider.isIncreasingKey(ch, direction)) {
            if (this.value < this.getMaxScrollValue()) {
                ++this.value;
            }
            return InputResult.PROCESSED;
        }
        if (WAbstractSlider.isDecreasingKey(ch, direction)) {
            if (this.value > 0) {
                --this.value;
            }
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseScroll(int x, int y, double amount) {
        this.setValue(this.getValue() + (int)(-amount) * 4);
        return InputResult.PROCESSED;
    }

    public int getValue() {
        return this.value;
    }

    public WScrollBar setValue(int value) {
        this.value = value;
        this.checkValue();
        return this;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public WScrollBar setMaxValue(int max) {
        this.maxValue = max;
        this.checkValue();
        return this;
    }

    public int getWindow() {
        return this.window;
    }

    public WScrollBar setWindow(int window) {
        this.window = window;
        return this;
    }

    protected void checkValue() {
        if (this.value > this.maxValue - this.window) {
            this.value = this.maxValue - this.window;
        }
        if (this.value < 0) {
            this.value = 0;
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, NarrationMessages.SCROLL_BAR_TITLE);
        builder.method_37034(class_6381.field_33791, NarrationMessages.SLIDER_USAGE);
    }

    @Environment(value=EnvType.CLIENT)
    static final class Painters {
        static final NinePatch<class_2960> SCROLL_BAR = NinePatch.builder((Object)new class_2960("libgui", "textures/widget/scroll_bar/scroll_bar_light.png")).cornerSize(4).cornerUv(0.25f).build();
        static final NinePatch<class_2960> SCROLL_BAR_DARK = NinePatch.builder((Object)new class_2960("libgui", "textures/widget/scroll_bar/scroll_bar_dark.png")).cornerSize(4).cornerUv(0.25f).build();
        static final NinePatch<class_2960> SCROLL_BAR_PRESSED = NinePatch.builder((Object)new class_2960("libgui", "textures/widget/scroll_bar/scroll_bar_pressed_light.png")).cornerSize(4).cornerUv(0.25f).build();
        static final NinePatch<class_2960> SCROLL_BAR_PRESSED_DARK = NinePatch.builder((Object)new class_2960("libgui", "textures/widget/scroll_bar/scroll_bar_pressed_dark.png")).cornerSize(4).cornerUv(0.25f).build();
        static final NinePatch<class_2960> SCROLL_BAR_HOVERED = NinePatch.builder((Object)new class_2960("libgui", "textures/widget/scroll_bar/scroll_bar_hovered_light.png")).cornerSize(4).cornerUv(0.25f).build();
        static final NinePatch<class_2960> SCROLL_BAR_HOVERED_DARK = NinePatch.builder((Object)new class_2960("libgui", "textures/widget/scroll_bar/scroll_bar_hovered_dark.png")).cornerSize(4).cornerUv(0.25f).build();
        static final BackgroundPainter BACKGROUND = BackgroundPainter.createLightDarkVariants(BackgroundPainter.createNinePatch(new class_2960("libgui", "textures/widget/scroll_bar/background_light.png")), BackgroundPainter.createNinePatch(new class_2960("libgui", "textures/widget/scroll_bar/background_dark.png")));
        static final NinePatch<class_2960> FOCUS = NinePatch.builder((Object)new class_2960("libgui", "textures/widget/scroll_bar/focus.png")).cornerSize(4).cornerUv(0.25f).build();

        Painters() {
        }
    }
}

