/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.ValidatedSlot;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.Rect2i;
import io.github.cottonmc.cotton.gui.widget.focus.Focus;
import io.github.cottonmc.cotton.gui.widget.focus.FocusModel;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class WItemSlot
extends WWidget {
    public static final class_2960 SLOT_TEXTURE = new class_2960("libgui", "textures/widget/item_slot.png");
    private static final VisualLogger LOGGER = new VisualLogger(WItemSlot.class);
    private final List<ValidatedSlot> peers = new ArrayList<ValidatedSlot>();
    @Nullable
    @Environment(value=EnvType.CLIENT)
    private BackgroundPainter backgroundPainter;
    @Nullable
    private Icon icon = null;
    private class_1263 inventory;
    private int startIndex = 0;
    private int slotsWide = 1;
    private int slotsHigh = 1;
    private boolean big = false;
    private boolean insertingAllowed = true;
    private boolean takingAllowed = true;
    private int focusedSlot = -1;
    private int hoveredSlot = -1;
    private Predicate<class_1799> inputFilter = ValidatedSlot.DEFAULT_ITEM_FILTER;
    private Predicate<class_1799> outputFilter = ValidatedSlot.DEFAULT_ITEM_FILTER;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();
    private final FocusModel<Integer> focusModel = new FocusModel<Integer>(){

        @Override
        public boolean isFocused(Focus<Integer> focus) {
            return WItemSlot.this.focusedSlot == focus.key();
        }

        @Override
        public void setFocused(Focus<Integer> focus) {
            WItemSlot.this.focusedSlot = focus.key();
        }

        @Override
        public Stream<Focus<Integer>> foci() {
            Stream.Builder<Focus<Integer>> builder = Stream.builder();
            int index = 0;
            for (int y = 0; y < WItemSlot.this.slotsHigh; ++y) {
                for (int x = 0; x < WItemSlot.this.slotsWide; ++x) {
                    int slotX = x * 18;
                    int slotY = y * 18;
                    int size = 18;
                    if (WItemSlot.this.big) {
                        slotX -= 4;
                        slotY -= 4;
                        size = 26;
                    }
                    builder.add(new Focus<Integer>(index, new Rect2i(slotX, slotY, size, size)));
                    ++index;
                }
            }
            return builder.build();
        }
    };

    public WItemSlot(class_1263 inventory, int startIndex, int slotsWide, int slotsHigh, boolean big) {
        this();
        this.inventory = inventory;
        this.startIndex = startIndex;
        this.slotsWide = slotsWide;
        this.slotsHigh = slotsHigh;
        this.big = big;
    }

    private WItemSlot() {
        this.hoveredProperty().addListener((property, from, to) -> {
            assert (to != null);
            if (!to.booleanValue()) {
                this.hoveredSlot = -1;
            }
        });
    }

    public static WItemSlot of(class_1263 inventory, int index) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = index;
        return w;
    }

    public static WItemSlot of(class_1263 inventory, int startIndex, int slotsWide, int slotsHigh) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = startIndex;
        w.slotsWide = slotsWide;
        w.slotsHigh = slotsHigh;
        return w;
    }

    public static WItemSlot outputOf(class_1263 inventory, int index) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = index;
        w.big = true;
        return w;
    }

    public static WItemSlot ofPlayerStorage(final class_1263 inventory) {
        WItemSlot w = new WItemSlot(){

            @Override
            protected class_2561 getNarrationName() {
                class_2561 class_25612;
                if (inventory instanceof class_1661) {
                    class_1661 inv = (class_1661)inventory;
                    class_25612 = inv.method_5476();
                } else {
                    class_25612 = NarrationMessages.Vanilla.INVENTORY;
                }
                return class_25612;
            }
        };
        w.inventory = inventory;
        w.startIndex = 9;
        w.slotsWide = 9;
        w.slotsHigh = 3;
        return w;
    }

    @Override
    public int getWidth() {
        return this.slotsWide * 18;
    }

    @Override
    public int getHeight() {
        return this.slotsHigh * 18;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    public boolean isBigSlot() {
        return this.big;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    public WItemSlot setIcon(@Nullable Icon icon) {
        this.icon = icon;
        if (icon != null && this.slotsWide * this.slotsHigh > 1) {
            LOGGER.warn("Setting icon {} for item slot {} with more than 1 slot ({})", icon, this, this.slotsWide * this.slotsHigh);
        }
        return this;
    }

    public boolean isModifiable() {
        return this.takingAllowed || this.insertingAllowed;
    }

    public WItemSlot setModifiable(boolean modifiable) {
        this.insertingAllowed = modifiable;
        this.takingAllowed = modifiable;
        for (ValidatedSlot peer : this.peers) {
            peer.setInsertingAllowed(modifiable);
            peer.setTakingAllowed(modifiable);
        }
        return this;
    }

    public boolean isInsertingAllowed() {
        return this.insertingAllowed;
    }

    public WItemSlot setInsertingAllowed(boolean insertingAllowed) {
        this.insertingAllowed = insertingAllowed;
        for (ValidatedSlot peer : this.peers) {
            peer.setInsertingAllowed(insertingAllowed);
        }
        return this;
    }

    public boolean isTakingAllowed() {
        return this.takingAllowed;
    }

    public WItemSlot setTakingAllowed(boolean takingAllowed) {
        this.takingAllowed = takingAllowed;
        for (ValidatedSlot peer : this.peers) {
            peer.setTakingAllowed(takingAllowed);
        }
        return this;
    }

    public int getFocusedSlot() {
        return this.focusedSlot;
    }

    @Override
    public void validate(GuiDescription host) {
        super.validate(host);
        this.peers.clear();
        int index = this.startIndex;
        for (int y = 0; y < this.slotsHigh; ++y) {
            for (int x = 0; x < this.slotsWide; ++x) {
                ValidatedSlot slot = this.createSlotPeer(this.inventory, index, this.getAbsoluteX() + x * 18 + 1, this.getAbsoluteY() + y * 18 + 1);
                slot.setInsertingAllowed(this.insertingAllowed);
                slot.setTakingAllowed(this.takingAllowed);
                slot.setInputFilter(this.inputFilter);
                slot.setOutputFilter(this.outputFilter);
                for (ChangeListener listener : this.listeners) {
                    slot.addChangeListener(this, listener);
                }
                this.peers.add(slot);
                host.addSlotPeer(slot);
                ++index;
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        if (WItemSlot.isActivationKey(ch) && this.host instanceof class_1703 && this.focusedSlot >= 0) {
            class_1703 handler = (class_1703)this.host;
            class_310 client = class_310.method_1551();
            ValidatedSlot peer = this.peers.get(this.focusedSlot);
            client.field_1761.method_2906(handler.field_7763, peer.field_7874, 0, class_1713.field_7790, (class_1657)client.field_1724);
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    protected ValidatedSlot createSlotPeer(class_1263 inventory, int index, int x, int y) {
        return new ValidatedSlot(inventory, index, x, y);
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public BackgroundPainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    @Environment(value=EnvType.CLIENT)
    public void setBackgroundPainter(@Nullable BackgroundPainter painter) {
        this.backgroundPainter = painter;
    }

    public Predicate<class_1799> getInputFilter() {
        return this.inputFilter;
    }

    public WItemSlot setInputFilter(Predicate<class_1799> inputFilter) {
        this.inputFilter = inputFilter;
        for (ValidatedSlot peer : this.peers) {
            peer.setInputFilter(inputFilter);
        }
        return this;
    }

    public Predicate<class_1799> getOutputFilter() {
        return this.outputFilter;
    }

    public WItemSlot setOutputFilter(Predicate<class_1799> outputFilter) {
        this.outputFilter = outputFilter;
        for (ValidatedSlot peer : this.peers) {
            peer.setOutputFilter(outputFilter);
        }
        return this;
    }

    @Deprecated(forRemoval=true)
    public Predicate<class_1799> getFilter() {
        return this.inputFilter;
    }

    @Deprecated(forRemoval=true)
    public WItemSlot setFilter(Predicate<class_1799> filter) {
        return this.setInputFilter(filter);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        if (this.backgroundPainter != null) {
            this.backgroundPainter.paintBackground(context, x, y, this);
        }
        if (this.icon != null) {
            this.icon.paint(context, x + 1, y + 1, 16);
        }
    }

    @Override
    @Nullable
    public FocusModel<?> getFocusModel() {
        return this.focusModel;
    }

    @Override
    public void onFocusLost() {
        this.focusedSlot = -1;
    }

    public void addChangeListener(ChangeListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
        for (ValidatedSlot peer : this.peers) {
            peer.addChangeListener(this, listener);
        }
    }

    @Override
    public void onShown() {
        for (ValidatedSlot peer : this.peers) {
            peer.setVisible(true);
        }
    }

    @Override
    public InputResult onMouseMove(int x, int y) {
        int slotX = x / 18;
        int slotY = y / 18;
        this.hoveredSlot = slotX + slotY * this.slotsWide;
        return InputResult.PROCESSED;
    }

    @Override
    public void onHidden() {
        super.onHidden();
        for (ValidatedSlot peer : this.peers) {
            peer.setVisible(false);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addPainters() {
        this.backgroundPainter = BackgroundPainter.SLOT;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(class_6382 builder) {
        ArrayList<Object> parts = new ArrayList<Object>();
        class_2561 name = this.getNarrationName();
        if (name != null) {
            parts.add(name);
        }
        if (this.focusedSlot >= 0) {
            parts.add(class_2561.method_43469((String)"widget.libgui.item_slot.narration.title", (Object[])new Object[]{this.focusedSlot + 1, this.slotsWide * this.slotsHigh}));
        } else if (this.hoveredSlot >= 0) {
            parts.add(class_2561.method_43469((String)"widget.libgui.item_slot.narration.title", (Object[])new Object[]{this.hoveredSlot + 1, this.slotsWide * this.slotsHigh}));
        }
        builder.method_37035(class_6381.field_33788, parts.toArray(new class_2561[0]));
    }

    @Nullable
    protected class_2561 getNarrationName() {
        return null;
    }

    @FunctionalInterface
    public static interface ChangeListener {
        public void onStackChanged(WItemSlot var1, class_1263 var2, int var3, class_1799 var4);
    }
}

