/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl;

import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.networking.NetworkSide;
import io.github.cottonmc.cotton.gui.networking.ScreenNetworking;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScreenNetworkingImpl
implements ScreenNetworking {
    public static final class_2960 SCREEN_MESSAGE_S2C = new class_2960("libgui", "screen_message_s2c");
    public static final class_2960 SCREEN_MESSAGE_C2S = new class_2960("libgui", "screen_message_c2s");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<SyncedGuiDescription, ScreenNetworkingImpl> instanceCache = new WeakHashMap<SyncedGuiDescription, ScreenNetworkingImpl>();
    private final Map<class_2960, ScreenNetworking.MessageReceiver> messages = new HashMap<class_2960, ScreenNetworking.MessageReceiver>();
    private SyncedGuiDescription description;
    private final NetworkSide side;

    private ScreenNetworkingImpl(SyncedGuiDescription description, NetworkSide side) {
        this.description = description;
        this.side = side;
    }

    @Override
    public void receive(class_2960 message, ScreenNetworking.MessageReceiver receiver) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(receiver, "receiver");
        if (this.messages.containsKey(message)) {
            throw new IllegalStateException("Message " + String.valueOf(message) + " on side " + String.valueOf((Object)this.side) + " already registered");
        }
        this.messages.put(message, receiver);
    }

    @Override
    public void send(class_2960 message, Consumer<class_2540> writer) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(writer, "writer");
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(this.description.field_7763);
        buf.method_10812(message);
        writer.accept(buf);
        this.description.getPacketSender().sendPacket(this.side == NetworkSide.SERVER ? SCREEN_MESSAGE_S2C : SCREEN_MESSAGE_C2S, buf);
    }

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SCREEN_MESSAGE_C2S, (server, player, networkHandler, buf, responseSender) -> ScreenNetworkingImpl.handle((Executor)server, (class_1657)player, buf));
    }

    public static void handle(Executor executor, class_1657 player, class_2540 buf) {
        class_1703 screenHandler = player.field_7512;
        int syncId = buf.method_10816();
        class_2960 messageId = buf.method_10810();
        if (!(screenHandler instanceof SyncedGuiDescription)) {
            LOGGER.error("Received message packet for screen handler {} which is not a SyncedGuiDescription", (Object)screenHandler);
            return;
        }
        if (syncId != screenHandler.field_7763) {
            LOGGER.error("Received message for sync ID {}, current sync ID: {}", (Object)syncId, (Object)screenHandler.field_7763);
            return;
        }
        ScreenNetworkingImpl networking = instanceCache.get(screenHandler);
        if (networking != null) {
            ScreenNetworking.MessageReceiver receiver = networking.messages.get(messageId);
            if (receiver != null) {
                buf.retain();
                executor.execute(() -> {
                    try {
                        receiver.onMessage(buf);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error handling screen message {} for {} on side {}", (Object)messageId, (Object)screenHandler, (Object)networking.side, (Object)e);
                    }
                    finally {
                        buf.release();
                    }
                });
            } else {
                LOGGER.warn("Message {} not registered for {} on side {}", (Object)messageId, (Object)screenHandler, (Object)networking.side);
            }
        } else {
            LOGGER.warn("GUI description {} does not use networking", (Object)screenHandler);
        }
    }

    public static ScreenNetworking of(SyncedGuiDescription description, NetworkSide networkSide) {
        Objects.requireNonNull(description, "description");
        Objects.requireNonNull(networkSide, "networkSide");
        if (description.getNetworkSide() == networkSide) {
            return instanceCache.computeIfAbsent(description, it -> new ScreenNetworkingImpl(description, networkSide));
        }
        return DummyNetworking.INSTANCE;
    }

    private static final class DummyNetworking
    extends ScreenNetworkingImpl {
        static final DummyNetworking INSTANCE = new DummyNetworking();

        private DummyNetworking() {
            super(null, null);
        }

        @Override
        public void receive(class_2960 message, ScreenNetworking.MessageReceiver receiver) {
        }

        @Override
        public void send(class_2960 message, Consumer<class_2540> writer) {
        }
    }
}

