/*
 * Decompiled with CFR 0.152.
 */
package pt.carlosalmeida.screen;

import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import pt.carlosalmeida.CraftLinkClient;
import pt.carlosalmeida.config.CraftLinkConfig;
import pt.carlosalmeida.screen.Browser;

@Environment(value=EnvType.CLIENT)
public class Search
extends BaseOwoScreen<FlowLayout> {
    private final class_437 parent;
    private static final String suggestionText = "Enter search or use '>' followed by URL";
    public static TextBoxComponent textBoxComponent = (TextBoxComponent)Components.textBox((Sizing)Sizing.fill((int)60)).tooltip(class_2561.method_30163((String)"Enter search or use '>' followed by URL"));
    public static String lastSearch = Browser.chooseHomeURL();
    private boolean justOpened = true;

    public Search() {
        this.parent = null;
    }

    public Search(class_437 parent) {
        this.parent = parent;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        boolean isInBrowser = this.parent instanceof Browser;
        rootComponent.child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)textBoxComponent).padding(Insets.of((int)10)).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER)).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).surface(isInBrowser ? Surface.blur((float)2.0f, (float)20.0f).and(Surface.VANILLA_TRANSLUCENT) : Surface.BLANK);
        textBoxComponent.method_1880(2083);
    }

    public boolean method_25421() {
        if (this.parent != null) {
            return this.parent.method_25421();
        }
        return false;
    }

    public void method_25419() {
        CraftLinkClient.minecraft.method_1507(this.parent);
    }

    public static String encodePureURL(String url) {
        return URLEncoder.encode(url, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static String encodeURL(String search) {
        return Search.chooseQuery() + Search.encodePureURL(search);
    }

    private static String chooseQuery() {
        if (CraftLinkConfig.query_url != null && !CraftLinkConfig.query_url.isEmpty()) {
            return CraftLinkConfig.query_url;
        }
        return switch (CraftLinkConfig.default_search_engine) {
            default -> throw new IncompatibleClassChangeError();
            case CraftLinkConfig.SearchEngineEnumChoice.GOOGLE -> "https://www.google.com/search?q=";
            case CraftLinkConfig.SearchEngineEnumChoice.BING -> "https://www.bing.com/search?q=";
            case CraftLinkConfig.SearchEngineEnumChoice.YAHOO -> "https://search.yahoo.com/search?p=";
            case CraftLinkConfig.SearchEngineEnumChoice.DUCKDUCKGO -> "https://duckduckgo.com/?q=";
            case CraftLinkConfig.SearchEngineEnumChoice.ECOSIA -> "https://www.ecosia.org/search?q=";
            case CraftLinkConfig.SearchEngineEnumChoice.ASK -> "https://www.ask.com/web?q=";
        };
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.justOpened = false;
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode != 258 && (!textBoxComponent.method_25370() || this.justOpened)) {
            this.method_25404(258, 48, 0);
            this.justOpened = false;
        }
        String query = textBoxComponent.method_1882();
        if (keyCode == 257 && !query.isEmpty()) {
            if (query.charAt(0) == '>') {
                String url;
                lastSearch = url = query.substring(1);
                CraftLinkClient.minecraft.method_1507((class_437)new Browser((class_2561)class_2561.method_43470((String)"CraftLink Browser"), url));
                Browser.setURL(url);
            } else {
                String url;
                lastSearch = url = query;
                url = Search.encodeURL(url);
                CraftLinkClient.minecraft.method_1507((class_437)new Browser((class_2561)class_2561.method_43470((String)"CraftLink Browser"), url));
                Browser.setURL(url);
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

