/*
 * Decompiled with CFR 0.152.
 */
package pt.carlosalmeida.screen;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFBrowser;
import com.mojang.blaze3d.systems.RenderSystem;
import eu.midnightdust.lib.config.MidnightConfig;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import pt.carlosalmeida.CraftLinkClient;
import pt.carlosalmeida.config.CraftLinkConfig;
import pt.carlosalmeida.screen.Search;

@Environment(value=EnvType.CLIENT)
public class Browser
extends BaseOwoScreen<FlowLayout> {
    public static final int BROWSER_DRAW_OFFSET = 20;
    public static final String BROWSER_DEFAULT_HOME_URL = Browser.chooseHomeURL();
    public static final double BROWSER_DEFAULT_ZOOM_LEVEL = 0.0;
    public static final float BROWSER_DEFAULT_SCALE_FACTOR;
    public static float scaleFactor;
    private static boolean browserRender;
    private boolean controlKeyPressed = false;
    private boolean shiftKeyPressed = false;
    public static String openURL;
    private double previousBrowserZoomLevel = 0.0;
    private static MCEFBrowser browser;
    private final class_310 minecraft = class_310.method_1551();
    static FlowLayout helpPanel;
    class_370 systemToastScale = new class_370(class_370.class_371.field_36445, (class_2561)class_2561.method_43470((String)"150%"), (class_2561)class_2561.method_43470((String)"Scale factor"));
    class_370 systemToastZoom = new class_370(class_370.class_371.field_36445, (class_2561)class_2561.method_43470((String)"---"), (class_2561)class_2561.method_43470((String)"Zoom level"));

    private String util_scaleText() {
        return scaleFactor * 100.0f + "%" + (scaleFactor == BROWSER_DEFAULT_SCALE_FACTOR ? " (Default)" : "");
    }

    private String util_zoomText() {
        return browser.getZoomLevel() + (browser.getZoomLevel() == 0.0 ? " (Default)" : "");
    }

    private void refreshScaleLabel() {
        this.systemToastScale.method_1991((class_2561)class_2561.method_43470((String)this.util_scaleText()), (class_2561)class_2561.method_43470((String)"Scale factor"));
    }

    private void refreshZoomLabel() {
        this.systemToastZoom.method_1991((class_2561)class_2561.method_43470((String)this.util_zoomText()), (class_2561)class_2561.method_43470((String)"Zoom level"));
    }

    public Browser(class_2561 title) {
        super(title);
    }

    public Browser(class_2561 title, String moddedOpenURL) {
        super(title);
        openURL = moddedOpenURL;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        this.subBuild(rootComponent);
    }

    public static String chooseHomeURL() {
        if (CraftLinkConfig.home_url != null && !CraftLinkConfig.home_url.isEmpty()) {
            return CraftLinkConfig.home_url;
        }
        return switch (CraftLinkConfig.default_home_url) {
            default -> throw new IncompatibleClassChangeError();
            case CraftLinkConfig.SearchEngineEnumChoice.GOOGLE -> "https://www.google.com";
            case CraftLinkConfig.SearchEngineEnumChoice.BING -> "https://www.bing.com";
            case CraftLinkConfig.SearchEngineEnumChoice.YAHOO -> "https://www.yahoo.com";
            case CraftLinkConfig.SearchEngineEnumChoice.DUCKDUCKGO -> "https://www.duckduckgo.com";
            case CraftLinkConfig.SearchEngineEnumChoice.ECOSIA -> "https://www.ecosia.org";
            case CraftLinkConfig.SearchEngineEnumChoice.ASK -> "https://www.ask.com";
        };
    }

    public static void searchLastSearch() {
        Browser.setURL(Search.encodeURL(Search.lastSearch));
        CraftLinkClient.minecraft.method_1507((class_437)new Browser((class_2561)class_2561.method_43470((String)"CraftLink Browser")));
    }

    void subBuild(FlowLayout rootComponent) {
        rootComponent.child((Component)helpPanel).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER);
    }

    public static void setURL(String newURL) {
        if (browser != null) {
            browser.loadURL(newURL);
            Browser.setBrowserActive(true);
        }
    }

    protected void method_25426() {
        super.method_25426();
        if (browser == null) {
            boolean transparent = false;
            browser = MCEF.createBrowser((String)openURL, (boolean)transparent);
            this.resizeBrowser();
            Browser.setBrowserActive(true);
            Browser.setURL(openURL);
            browser.setZoomLevel(0.0);
        }
    }

    private static void setBrowserActive(boolean activity) {
        browserRender = activity;
        if (activity) {
            helpPanel.sizing(Sizing.fixed((int)20), Sizing.fixed((int)20));
        } else {
            helpPanel.sizing(Sizing.content(), Sizing.content());
        }
    }

    private int mouseX(double x) {
        return (int)((x - 20.0) * this.minecraft.method_22683().method_4495() / (double)scaleFactor);
    }

    private int mouseY(double y) {
        return (int)((y - 20.0) * this.minecraft.method_22683().method_4495() / (double)scaleFactor);
    }

    private int scaleX(double x) {
        return (int)((x - 40.0) * this.minecraft.method_22683().method_4495() / (double)scaleFactor);
    }

    private int scaleY(double y) {
        return (int)((y - 40.0) * this.minecraft.method_22683().method_4495() / (double)scaleFactor);
    }

    private void resizeBrowser() {
        if (this.field_22789 > 100 && this.field_22790 > 100) {
            browser.resize(this.scaleX(this.field_22789), this.scaleY(this.field_22790));
        }
    }

    public void method_25410(class_310 minecraft, int i, int j) {
        super.method_25410(minecraft, i, j);
        this.resizeBrowser();
    }

    public void method_25419() {
        super.method_25419();
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        class_5489 multilineText;
        String helpString;
        Browser.setBrowserActive(!this.controlKeyPressed || !this.shiftKeyPressed);
        super.method_25394(guiGraphics, i, j, f);
        if (browserRender) {
            RenderSystem.disableDepthTest();
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (int)browser.getRenderer().getTextureID());
            class_289 t = class_289.method_1348();
            class_287 buffer = t.method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            buffer.method_22912(20.0, (double)(this.field_22790 - 20), 0.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
            buffer.method_22912((double)(this.field_22789 - 20), (double)(this.field_22790 - 20), 0.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
            buffer.method_22912((double)(this.field_22789 - 20), 20.0, 0.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
            buffer.method_22912(20.0, 20.0, 0.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
            t.method_1350();
            RenderSystem.setShaderTexture((int)0, (int)0);
            RenderSystem.enableDepthTest();
        }
        if (CraftLinkClient.popUpTimerScale > 0.0f) {
            this.systemToastScale.method_1986(guiGraphics, new class_374(CraftLinkClient.minecraft), 400L);
        }
        if (CraftLinkClient.popUpTimerZoom > 0.0f) {
            this.systemToastZoom.method_1986(guiGraphics, new class_374(CraftLinkClient.minecraft), 400L);
        }
        if (this.controlKeyPressed && CraftLinkConfig.help_text_overlay) {
            helpString = "CTRL + SHIFT: Help++ | CTRL + Space: Search | CTRL + R: Refresh | CTRL + H: Home | CTRL + Scroll: Zoom";
            multilineText = class_5489.method_30890((class_327)this.field_22793, (class_5348)class_2561.method_43470((String)helpString), (int)(this.field_22789 - 20));
            multilineText.method_30889(guiGraphics, this.field_22789 / 2, this.field_22790 - 30, 12, 65280);
        }
        if (browser.isLoading() && CraftLinkConfig.loading_text_overlay) {
            helpString = "Loading...";
            multilineText = class_5489.method_30890((class_327)this.field_22793, (class_5348)class_2561.method_43470((String)helpString), (int)(this.field_22789 - 20));
            multilineText.method_30889(guiGraphics, 25, 5, 12, 3319890);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        browser.sendMousePress(this.mouseX(mouseX), this.mouseY(mouseY), button);
        browser.setFocus(true);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        browser.sendMouseRelease(this.mouseX(mouseX), this.mouseY(mouseY), button);
        browser.setFocus(true);
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        browser.sendMouseMove(this.mouseX(mouseX), this.mouseY(mouseY));
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.controlKeyPressed && !this.shiftKeyPressed) {
            if (delta > 0.0) {
                browser.setZoomLevel(browser.getZoomLevel() + 1.0);
            } else {
                browser.setZoomLevel(browser.getZoomLevel() - 1.0);
            }
        }
        this.checkZoomChangeAndHandle();
        browser.sendMouseWheel(this.mouseX(mouseX), this.mouseY(mouseY), delta, 0);
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 341: {
                this.controlKeyPressed = true;
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            case 340: {
                this.shiftKeyPressed = true;
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            case 72: {
                if (!this.controlKeyPressed) break;
                Browser.setURL(BROWSER_DEFAULT_HOME_URL);
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            case 82: {
                if (!this.controlKeyPressed) break;
                browser.reload();
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            case 265: {
                if (!this.controlKeyPressed) break;
                scaleFactor += 0.25f;
                this.refreshScaleLabel();
                CraftLinkClient.popUpTimerScale = 10.0f;
                CraftLinkClient.popUpTimerZoom = 0.0f;
                this.resizeBrowser();
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            case 264: {
                if (!this.controlKeyPressed) break;
                if ((scaleFactor -= 0.25f) < 1.0f) {
                    scaleFactor = 1.0f;
                }
                this.refreshScaleLabel();
                CraftLinkClient.popUpTimerScale = 10.0f;
                CraftLinkClient.popUpTimerZoom = 0.0f;
                this.resizeBrowser();
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            case 32: {
                if (!this.controlKeyPressed) break;
                CraftLinkClient.minecraft.method_1507((class_437)new Search((class_437)this));
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            case 83: {
                if (!this.controlKeyPressed) break;
                if (this.shiftKeyPressed) {
                    Browser.searchLastSearch();
                    return super.method_25404(keyCode, scanCode, modifiers);
                }
                CraftLinkClient.minecraft.method_1507(MidnightConfig.getScreen((class_437)this, (String)"craftlink"));
                return super.method_25404(keyCode, scanCode, modifiers);
            }
        }
        browser.sendKeyPress(keyCode, (long)scanCode, modifiers);
        this.checkZoomChangeAndHandle();
        browser.setFocus(true);
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void checkZoomChangeAndHandle() {
        double bZoom = browser.getZoomLevel();
        if (bZoom != this.previousBrowserZoomLevel) {
            this.previousBrowserZoomLevel = bZoom;
            this.refreshZoomLabel();
            CraftLinkClient.popUpTimerZoom = 10.0f;
            CraftLinkClient.popUpTimerScale = 0.0f;
        }
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.controlKeyPressed = false;
        }
        if (keyCode == 340) {
            this.shiftKeyPressed = false;
        }
        browser.sendKeyRelease(keyCode, (long)scanCode, modifiers);
        browser.setFocus(true);
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (codePoint == '\u0000') {
            return false;
        }
        browser.sendKeyTyped(codePoint, modifiers);
        browser.setFocus(true);
        return super.method_25400(codePoint, modifiers);
    }

    static {
        scaleFactor = BROWSER_DEFAULT_SCALE_FACTOR = CraftLinkConfig.scale_factor;
        browserRender = true;
        openURL = BROWSER_DEFAULT_HOME_URL;
        helpPanel = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Components.label((class_2561)class_2561.method_43470((String)"You're holding CTRL + SHIFT. This hides the browser and shows this window.")).color(Color.ofRgb((int)0xFFFF00)).margins(Insets.both((int)0, (int)5))).child((Component)Components.label((class_2561)class_2561.method_43470((String)"If the page's URL hasn't loaded, press CTRL + SHIFT + S to search for it instead.")).margins(Insets.both((int)0, (int)5))).child((Component)Components.label((class_2561)class_2561.method_43470((String)"CTRL + S: Configuration Screen | CTRL + H: Home | CTRL + R: Refresh")).margins(Insets.both((int)0, (int)5))).child((Component)Components.label((class_2561)class_2561.method_43470((String)"CTRL + \u2191: Upscale browser | CTRL + \u2193: Downscale browser | CTRL + Space: Search")).margins(Insets.both((int)0, (int)5))).child((Component)Components.label((class_2561)class_2561.method_43470((String)"CTRL + Scroll Up: Zoom in | CTRL + Scroll Down: Zoom out")).margins(Insets.both((int)0, (int)5))).child((Component)Components.label((class_2561)class_2561.method_43470((String)"Up/downscaling changes the browser's resolution.")).margins(Insets.both((int)0, (int)5))).child((Component)Components.label((class_2561)class_2561.method_43470((String)"Zooming keeps the resolution and makes the elements bigger or smaller.")).margins(Insets.both((int)0, (int)5))).padding(Insets.of((int)10)).surface(Surface.DARK_PANEL).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER);
    }
}

