/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.cache;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.Arrays;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.Logger;

public class ServerBlockStateCache {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final BlockState state;
    public final LevelReader level;
    public final BlockPos pos;
    boolean noCollision = false;
    boolean[] occludeFaces = null;
    boolean[] fullFaces = null;
    boolean isShapeResolved = false;

    public ServerBlockStateCache(BlockState blockState, ILevelWrapper samplingLevel, DhBlockPos samplingPos) {
        this.state = blockState;
        this.level = (LevelReader)samplingLevel.getWrappedMcObject();
        this.pos = McObjectConverter.Convert(samplingPos);
        this.resolveShapes();
    }

    public void resolveShapes() {
        if (this.isShapeResolved) {
            return;
        }
        if (this.state.m_60819_().m_76178_()) {
            this.noCollision = this.state.m_60812_((BlockGetter)this.level, this.pos).m_83281_();
            this.occludeFaces = new boolean[6];
            if (this.state.m_60815_()) {
                for (Direction dir : Direction.values()) {
                    this.occludeFaces[McObjectConverter.Convert((Direction)dir).ordinal()] = !this.state.m_60655_((BlockGetter)this.level, this.pos, dir).m_83281_();
                }
            }
            VoxelShape voxelShape = this.state.m_60808_((BlockGetter)this.level, this.pos);
            this.fullFaces = new boolean[6];
            if (!voxelShape.m_83281_()) {
                for (Direction dir : Direction.values()) {
                    VoxelShape faceShape = voxelShape.m_83263_(dir);
                    AABB aabb = faceShape.m_83215_();
                    boolean xFull = aabb.f_82288_ <= 0.01 && aabb.f_82291_ >= 0.99;
                    boolean yFull = aabb.f_82289_ <= 0.01 && aabb.f_82292_ >= 0.99;
                    boolean zFull = aabb.f_82290_ <= 0.01 && aabb.f_82293_ >= 0.99;
                    this.fullFaces[McObjectConverter.Convert((Direction)dir).ordinal()] = !(!xFull && !dir.m_122434_().equals((Object)Direction.Axis.X) || !yFull && !dir.m_122434_().equals((Object)Direction.Axis.Y) || !zFull && !dir.m_122434_().equals((Object)Direction.Axis.Z));
                }
            }
        } else {
            this.occludeFaces = new boolean[6];
            Arrays.fill(this.occludeFaces, true);
            this.fullFaces = new boolean[6];
            Arrays.fill(this.fullFaces, true);
        }
    }
}

