/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeWrapper
implements IBiomeWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ConcurrentMap<Holder<Biome>, BiomeWrapper> WRAPPER_BY_BIOME = new ConcurrentHashMap<Holder<Biome>, BiomeWrapper>();
    public static final String EMPTY_STRING = "EMPTY";
    public static final BiomeWrapper EMPTY_WRAPPER = new BiomeWrapper(null, null);
    private static final HashSet<String> BrokenResourceLocationStrings = new HashSet();
    public final Holder<Biome> biome;
    private String serialString = null;

    public static IBiomeWrapper getBiomeWrapper(Holder<Biome> biome, ILevelWrapper levelWrapper) {
        if (biome == null) {
            return EMPTY_WRAPPER;
        }
        if (WRAPPER_BY_BIOME.containsKey(biome)) {
            return (IBiomeWrapper)WRAPPER_BY_BIOME.get(biome);
        }
        BiomeWrapper newWrapper = new BiomeWrapper(biome, levelWrapper);
        WRAPPER_BY_BIOME.put(biome, newWrapper);
        return newWrapper;
    }

    private BiomeWrapper(Holder<Biome> biome, ILevelWrapper levelWrapper) {
        this.biome = biome;
        this.serialString = this.serialize(levelWrapper);
        LOGGER.trace("Created BiomeWrapper [" + this.serialString + "] for [" + biome + "]");
    }

    @Override
    public String getName() {
        if (this == EMPTY_WRAPPER) {
            return EMPTY_STRING;
        }
        return this.biome.m_203543_().orElse(Biomes.f_48173_).m_211136_().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BiomeWrapper that = (BiomeWrapper)obj;
        return Objects.equals(this.getSerialString(), that.getSerialString());
    }

    public int hashCode() {
        return Objects.hash(this.getSerialString());
    }

    @Override
    public String getSerialString() {
        return this.serialString;
    }

    @Override
    public Object getWrappedMcObject() {
        return this.biome;
    }

    public String toString() {
        return this.getSerialString();
    }

    public String serialize(ILevelWrapper levelWrapper) {
        if (levelWrapper == null) {
            return EMPTY_STRING;
        }
        if (this.serialString == null) {
            RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
            ResourceLocation resourceLocation = registryAccess.m_175515_(Registries.f_256952_).m_7981_((Object)((Biome)this.biome.m_203334_()));
            if (resourceLocation == null) {
                String biomeName = ((Biome)this.biome.m_203334_()).toString();
                LOGGER.warn("unable to serialize: " + biomeName);
                this.serialString = "";
            } else {
                this.serialString = resourceLocation.m_135827_() + ":" + resourceLocation.m_135815_();
            }
        }
        return this.serialString;
    }

    public static IBiomeWrapper deserialize(String resourceLocationString, ILevelWrapper levelWrapper) throws IOException {
        if (resourceLocationString.equals(EMPTY_STRING)) {
            LOGGER.warn("[EMPTY] biome string deserialized. This may mean there was a file saving error or a biome saving error.");
            return EMPTY_WRAPPER;
        }
        if (resourceLocationString.trim().isEmpty() || resourceLocationString.equals("")) {
            LOGGER.warn("Null biome string deserialized.");
            return EMPTY_WRAPPER;
        }
        int separatorIndex = resourceLocationString.indexOf(":");
        if (separatorIndex == -1) {
            throw new IOException("Unable to parse resource location string: [" + resourceLocationString + "].");
        }
        ResourceLocation resourceLocation = new ResourceLocation(resourceLocationString.substring(0, separatorIndex), resourceLocationString.substring(separatorIndex + 1));
        try {
            Level level = (Level)levelWrapper.getWrappedMcObject();
            RegistryAccess registryAccess = level.m_9598_();
            Biome unwrappedBiome = (Biome)registryAccess.m_175515_(Registries.f_256952_).m_7745_(resourceLocation);
            boolean success = unwrappedBiome != null;
            Holder.Direct biome = new Holder.Direct((Object)unwrappedBiome);
            if (!success) {
                if (!BrokenResourceLocationStrings.contains(resourceLocationString)) {
                    BrokenResourceLocationStrings.add(resourceLocationString);
                    LOGGER.warn("Unable to deserialize biome from string: [" + resourceLocationString + "]");
                }
                return EMPTY_WRAPPER;
            }
            return BiomeWrapper.getBiomeWrapper((Holder<Biome>)biome, levelWrapper);
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize the string [" + resourceLocationString + "] into a BiomeWrapper: " + e.getMessage(), e);
        }
    }
}

